<?php
namespace brandmeaningmatrix\svc;
/***********************************************************************************
 * Restful service for all things session related.
 ***********************************************************************************/
// error_reporting(E_ALL);
// ini_set('display_errors', 1);

require_once($_SERVER["DOCUMENT_ROOT"].'/models/JsonUtil.php');
use \brandmeaningmatrix\model\JsonUtil;
require_once($_SERVER["DOCUMENT_ROOT"].'/models/Bmm_User_SessionsDataAccess.php');
use \brandmeaningmatrix\model\Bmm_User_SessionsDataAccess;
require_once($_SERVER["DOCUMENT_ROOT"].'/models/SendGridDataAccess.php');
use \brandmeaningmatrix\model\SendGridDataAccess;
require_once($_SERVER["DOCUMENT_ROOT"].'/models/Bmm_Send_NewsletterDataAccess.php');
use \brandmeaningmatrix\model\Bmm_Send_NewsletterDataAccess;
use stdClass;

class Bmmuser {

	const COOKIE_NAME = 'First-timer';
	const COOKIE_VALUE = 'Yes';

	public function __construct() {
	}

	public function authenticate($data) {
		$jsonUtil = new JsonUtil();
		$res = new stdClass();
		$bmmUserSessionsDA = new Bmm_User_SessionsDataAccess();
		$bmmUserSessionsDA->updateVisited($data);
		$res->exists = $bmmUserSessionsDA->checkIfExists($data['bmm_session_seq']);
		$res->completed = $bmmUserSessionsDA->checkIfComplete($data['bmm_session_seq']);
		$jsonUtil->writeJsonSuccess($res);
	}

	public function walkthru($data) {
		$jsonUtil = new JsonUtil();
		$res = new stdClass();
		$bmmUserSessionsDA = new Bmm_User_SessionsDataAccess();
		$bmmUserSessionsDA->updateVisited($data);
		$res->exists = $bmmUserSessionsDA->checkIfExists($data['bmm_session_seq']);
		$res->completed = $bmmUserSessionsDA->checkIfComplete($data['bmm_session_seq']);
		$res->already_visited = $this->checkCookie();
		$jsonUtil->writeJsonSuccess($res);
	}

	public function sendFirstEmailBlast($data) {
		$jsonUtil = new JsonUtil();
		$res = new stdClass();
		if($data['code'] !== 'justin_cateron_yztre139') {
			$res->results = 'failed';
			$jsonUtil->writeJsonSuccess($res);
		}
		$bmmUserSessionsDA = new Bmm_User_SessionsDataAccess();
		$res->results = $bmmUserSessionsDA->getForFirstEmail();
		$jsonUtil->writeJsonSuccess($res);
	}

	public function sendSecondEmailBlast($data) {
		$jsonUtil = new JsonUtil();
		$res = new stdClass();
		if($data['code'] !== 'justin_cateron_yztre139') {
			$res->results = 'failed';
			$jsonUtil->writeJsonSuccess($res);
		}
		$bmmUserSessionsDA = new Bmm_User_SessionsDataAccess();
		$res->results = $bmmUserSessionsDA->getForSecondEmail();
		$jsonUtil->writeJsonSuccess($res);
	}

	public function sendThirdEmailBlast($data) {
		$jsonUtil = new JsonUtil();
		$res = new stdClass();
		if($data['code'] !== 'justin_cateron_yztre139') {
			$res->results = 'failed';
			$jsonUtil->writeJsonSuccess($res);
		}
		$bmmUserSessionsDA = new Bmm_User_SessionsDataAccess();
		$res->results = $bmmUserSessionsDA->getForThirdEmail();
		$jsonUtil->writeJsonSuccess($res);
	}

	public function add($data) {
		$jsonUtil = new JsonUtil();
		$bmmUserSessionsDA = new Bmm_User_SessionsDataAccess();
		$id = $bmmUserSessionsDA->add($data);
		$res = new stdClass();
		$res->results = $id;
		$jsonUtil->writeJsonSuccess($res);
	}

	public function cronToSendNewsLetter($data) {
		$jsonUtil = new JsonUtil();
		$res = new stdClass();
		if($data['code'] !== 'justin_cateron_yztre139') {
			$res->results = 'failed';
			$jsonUtil->writeJsonSuccess($res);
		}
		$bmmSendNewsLetterDA = new Bmm_Send_NewsletterDataAccess();
		$res->results = $bmmSendNewsLetterDA->get();
		$jsonUtil->writeJsonSuccess($res);
	}

	// public function initAdd($data) {
	// 	$jsonUtil = new JsonUtil();
	// 	$res = new stdClass();
		
	// 	$bmmUserSessionsDA = new Bmm_User_SessionsDataAccess();
	// 	$bmmUserSessionsDA->initalStarters();
	// 	$res->results = true;
	// 	$jsonUtil->writeJsonSuccess($res);
	// }

	// public function initAdd($data) {
	// 	$jsonUtil = new JsonUtil();
	// 	$res = new stdClass();
		
	// 	$bmmUserSessionsDA = new Bmm_User_SessionsDataAccess();
	// 	$users = $bmmUserSessionsDA->initalStarters();
	// 	foreach($users as $a_user) {
	// 		echo $a_user->email_address . ', ' . $a_user->bmm_session_seq;
	// 		echo "<br>";
	// 	}
	// 	// $res->results = $bmmUserSessionsDA->initalStarters();
	// 	// $jsonUtil->writeJsonSuccess($res);
	// }

	// public function add($data) {
	// 	$jsonUtil = new JsonUtil();
	// 	$bmmUserSessionsDA = new Bmm_User_SessionsDataAccess();
	// 	$id = $bmmUserSessionsDA->add($data);
	// 	$res = new stdClass();
	// 	$res->results = $id;
	// 	$res->already_visited = $this->checkCookie();
	// 	//create a user session
	// 	$sessionHdlr = new SignonSessionHandler();
	// 	$session = $sessionHdlr->getSession(false);
	// 	$session->signedOn = true;
	// 	$session->key = $id;
	// 	$sessionHdlr->saveSession($session);
	// 	$jsonUtil->writeJsonSuccess($res);
	// }

	public function postFinalQuestion($data) {
		$jsonUtil = new JsonUtil();
		$bmmUserSessionsDA = new Bmm_User_SessionsDataAccess();
		$updated = $bmmUserSessionsDA->updateFinalQuestion($data);
		$res = new stdClass();
		$res->results = $updated;
		$jsonUtil->writeJsonSuccess($res);
	}

	private function checkCookie() {
		$response = '';
		if(!isset($_COOKIE[self::COOKIE_NAME])) {
		    $response = 'No';
		    $this->setCookie();
		} else {
		    $response = 'Yes';
		}
		return $response;
	}

	private function setCookie() {
		setcookie(self::COOKIE_NAME, self::COOKIE_VALUE, time() + (86400 * 30), "/"); // 86400 = 1 day
	}

	public function unsubscribeEmail($data) {
		$jsonUtil = new JsonUtil();
		$res = new stdClass();
		$senGridDA = new SendGridDataAccess();
		$res->results = $senGridDA->addToGlobalUnsubscribe($data);
		$jsonUtil->writeJsonSuccess($res);
	}

}