<?php
namespace brandmeaningmatrix\svc;
/***********************************************************************************
 * Restful service for all things session related.
 ***********************************************************************************/
// error_reporting(E_ALL);
// ini_set('display_errors', 1);

require_once($_SERVER["DOCUMENT_ROOT"].'/models/JsonUtil.php');
use \brandmeaningmatrix\model\JsonUtil;
require_once($_SERVER["DOCUMENT_ROOT"].'/models/Bmm_Results.php');
use \brandmeaningmatrix\model\Bmm_Results;
require_once($_SERVER["DOCUMENT_ROOT"].'/models/Bmm_User_SessionsDataAccess.php');
use \brandmeaningmatrix\model\Bmm_User_SessionsDataAccess;
use stdClass;

class Bmmresults {

	public function __construct() {
	}

	public function generateResults($data) {
		$jsonUtil = new JsonUtil();
		$res = new stdClass();
		$bmmResults = new Bmm_Results();
		$results = $bmmResults->generateResults($data);
		$bmmUserSessionsDA = new Bmm_User_SessionsDataAccess();
		$res->exists = $bmmUserSessionsDA->checkIfExists($data['bmm_session_seq']);
		$res->completed = $bmmUserSessionsDA->checkIfComplete($data['bmm_session_seq']);
		$res->results = $results;
		$jsonUtil->writeJsonSuccess($res);
	}

	public function requestTheReport($data) {
		$jsonUtil = new JsonUtil();
		$bmmResults = new Bmm_Results();
		$results = $bmmResults->reportRequest($data);
		$bmmUserSessionsDA = new Bmm_User_SessionsDataAccess();
		$bmmUserSessionsDA->updateCompleted($data);
		$res = new stdClass();
		$res->results = $results;
		$jsonUtil->writeJsonSuccess($res);
	}

	public function addImage($data) {
		$jsonUtil = new JsonUtil();
		$bmmResults = new Bmm_Results();
		$results = $bmmResults->addResultsImage($data);
		$res = new stdClass();
		$res->results = 'added';
		$jsonUtil->writeJsonSuccess($res);
	}


}