<?php
require_once($_SERVER["DOCUMENT_ROOT"].'/models/Bmm_User_SessionsDataAccess.php');
use \brandmeaningmatrix\model\Bmm_User_SessionsDataAccess;
require_once($_SERVER["DOCUMENT_ROOT"].'/models/Bmm_Results.php');
use \brandmeaningmatrix\model\Bmm_Results;
require_once($_SERVER["DOCUMENT_ROOT"].'/models/Bmm_AttributesDataAccess.php');
use \brandmeaningmatrix\model\Bmm_AttributesDataAccess;

$seq = (isset($_POST['id'])) ? $_POST : $_GET;
$bmmUserSessionDA = new Bmm_User_SessionsDataAccess();
$user = $bmmUserSessionDA->getByBmmSessionSeq($seq['id']);
$bmmResults = new Bmm_Results();
$user_images = $bmmResults->getResultsImages($seq['id']);
// var_dump($user_images);
// die();
//set page variables
$brandname = html_entity_decode($user->brand_name, ENT_QUOTES | ENT_XML1, 'UTF-8');
$count_brand_name = strlen($brandname);
if($count_brand_name > 20) {
	$brandname = mb_strimwidth($brandname, 0, 20, "...");
}
$main_brand_type = '';
if(!empty($user_images)) {
	foreach($user_images as $a_image) {
		if($a_image->type == 'main_brand_type') {
			$main_brand_type = $a_image->image_url;
		}
	}
}
//get results
$bmmAttributesDA = new Bmm_AttributesDataAccess();
$send_data = new stdClass();
$send_data->attribute_code = $user->top_attribute_code;
$bmm_attributes = $bmmAttributesDA->getByAttrCode($send_data);
$attribute_category = $user->primary_type;
//brand type description
$attribute_category_description = '';
//$css_class_color = '';
$functional_description = 'Your brand is predominantly a <span class="functional_text_color"><strong>functional brand.</strong></span> The primary benefit of your brand is its ability to offer your customer superior performance, greater efficiency or better economy.';
$experience_description = 'Your brand is predominantly an <span class="experience_text_color"><strong>experience brand.</strong></span> The primary benefit of your brand is its ability to deliver a unique and engaging experience for your customer.';
$image_description = 'Your brand is predominantly an <span class="image_text_color"><strong>image brand.</strong></span> The primary benefit of your brand is its ability to convey a desirable impression of your customer to other people.';
$mentor_description = 'Your brand is predominantly a <span class="mentor_text_color"><strong>mentor brand.</strong></span> The primary benefit of your brand is its ability to provide value-added information, inspiration or customer advocacy.';
if($attribute_category == 'Functional') {
	$attribute_category_description = $functional_description;
	//$css_class_color = 'functional_text_color';
} elseif ($attribute_category == 'Experience') {
	$attribute_category_description = $experience_description;
	//$css_class_color = 'experience_text_color';
} elseif ($attribute_category == 'Image') {
	$attribute_category_description = $image_description;
	//$css_class_color = 'image_text_color';
} elseif ($attribute_category == 'Mentor') {
	$attribute_category_description = $mentor_description;
	//$css_class_color = 'mentor_text_color';
}

?>
<html>
	<head>
		<style>
			.purple_text {
				color: #564f75;
			}
			.heading_title {
				font-size: 30px;
				text-align: center;
				font-family: Arial, "Helvetica Neue", Helvetica, sans-serif;
				margin-bottom: 5px;
			}
			.page_two_paragraph_text {
				font-family: Arial, "Helvetica Neue", Helvetica, sans-serif;
				color: #656565;
				font-size: 14px;
				font-weight: normal;
				line-height: 18px;
				letter-spacing: 0.5px;
				font-variant: normal;
				margin-top: 10px;
				line-height: 1.5;
			}
			.brand_type_icon {
				height: 40px;
				width: 40px;
			}
			.spacer td {
				padding-top: 10px;
				padding-bottom: 10px
			}
			.tripple_spacer td {
				padding-top: 50px;
				padding-bottom: 50px
			}
			.header_hr {
				height: 2px;
				background-color: #564f75;
				color: #564f75;
				border-top: solid 2px #564f75 !important;
				padding-top: 0px;
				padding-bottom: 0px;
			}
			.image_icons_pg_two {
				width: 40px;
				height: auto;
			}
			.brand_type_main_table {
				margin-top: 10px;
				width: 100%; 
			}
			.full_width {
				width: 100%
			}
			.thirty_width {
				width: 30%
			}
			.one_width {
				width: 1%;
			}
			.brand_results_image_pgtwo {
				height: 350px;
				width: auto;
			}
			.type_descriptions_table {
				margin-top: 20px; 
				width: 100%; 
				background-color: #edeceb;
				/*padding: 15px 10px 20px 10px;*/
				padding: 5px 5px 10px 5px;
			}
			.functional_text_color {
				color: #A4C230;
				margin-bottom: 3px;
			}
			.experience_text_color {
				color: #F38B00;
				margin-bottom: 3px;
			}
			.image_text_color {
				color: #00AFE3;
			}
			.mentor_text_color {
				color: #564f75;
			}
			.bolded_font {
				font-weight: bold;
			}
			.type_desc_table_text {
				font-size: 12px;
				font-family: arial;
				color: #656565;
			}
			.type_descriptions_table td {
				line-height: 1.50;
			}
			.padding-top-lastrow {
				padding-top: 25px;
			}
		</style>
	</head>
	<body>
		<section class="page_two_pdf">
		    <p class="purple_text heading_title">What Type of Brand Is <?= $brandname ?>?</p>
			<hr class="header_hr">
			<p class="page_two_paragraph_text"><?= $attribute_category_description ?></p>

			<table class="no-border brand_type_main_table" cellspacing="0" cellpadding="3">
				<tr>
					<td colspan="3" class="full_width" align="center">
						<img class="brand_type_icon" src="/img/letter-f-new.png" alt="Functional">
					</td>
				</tr>
				<tr>
					<td class="thirty_width" align="right">
						<img class="brand_type_icon" src="/img/letter-m-new.png" alt="Mentor">
					</td>
					<td class="one_width">
						<img style="" class="brand_results_image_pgtwo" src="<?= $main_brand_type ?>" alt="Brand Results Image">
					</td>
					<td class="thirty_width" align="left">
						<img class="brand_type_icon" src="/img/letter-e-new.png" alt="Experience">
					</td>
				</tr>
				<tr>
					<td colspan="3" class="full_width" align="center">
						<img class="brand_type_icon" src="/img/letter-i-new.png" alt="Image">
					</td>
				</tr>
			</table>
			<table class="no-border type_descriptions_table" cellpadding="7">
				<tr>
					<td valign="top" style="padding-left: 20px; padding-top: 10px;">
						<img class="image_icons_pg_two" src="/img/brand_type_icons/green_star-new.png">
					</td>
					<td valign="top" style="padding-top: 10px;">
						<h4 class="functional_text_color">Functional</h4>
						<p class="type_desc_table_text">A <span class="bolded_font">functional brand</span> is differentiated primarily by helping customers do something better, perform more efficiently or be more economical in their daily lives. Examples of functional brands include <span class="bolded_font">Gillette</span><sup>&reg;</sup> razors and <span class="bolded_font">GEICO</span><sup>&reg;</sup> insurance.</p>
					</td>
					<td valign="top" style="padding-left: 20px; padding-top: 10px;">
						<img class="image_icons_pg_two" src="/img/brand_type_icons/orange_dots-new.png">
					</td>
					<td valign="top" style="padding-top: 10px;">
						<h4 class="experience_text_color">Experience</h4>
						<p class="type_desc_table_text">An <span class="bolded_font">experience brand</span> is differentiated primarily by offering its customers a unique or engaging experience. Examples of experience brands include <span class="bolded_font">American Girl</span><sup>&reg;</sup> stores and <span class="bolded_font">Starbucks</span><sup>&reg;</sup> coffee shops.</p>
					</td>
				</tr>
				<tr>
					<td class="padding-top-lastrow" valign="top" style="padding-left: 20px;">
						<img class="image_icons_pg_two" src="/img/brand_type_icons/purple_people-new.png">
					</td>
					<td class="padding-top-lastrow" valign="top">
						<h4 class="mentor_text_color">Mentor</h4>
						<p class="type_desc_table_text">A <span class="bolded_font">mentor brand</span> is differentiated primarily based on the value-added information, ongoing inspiration or customer advocacy it provides. Examples of mentor brands include <span class="bolded_font">Nike</span><sup>&reg;</sup> athletic apparel and The <span class="bolded_font">Home Depot</span><sup>&reg;</sup> stores.</p>
					</td>
					<td class="padding-top-lastrow" valign="top" style="padding-left: 20px;">
						<img class="image_icons_pg_two" src="/img/brand_type_icons/blue_image-new.png">
					</td>
					<td class="padding-top-lastrow" valign="top">
						<h4 class="image_text_color">Image</h4>
						<p class="type_desc_table_text">An <span class="bolded_font">image brand</span> is differentiated primarily based on the statement it makes about the customer to other people. Examples of image brands include <span class="bolded_font">Tiffany &amp; Co.</span><sup>&reg;</sup> jewelry and <span class="bolded_font">Harley-Davidson</span><sup>&reg;</sup> motorcycles.</p>
					</td>
				</tr>
			</table>
		</section><!--end #page_one -->
	</body>
</html>