<?php
require_once($_SERVER["DOCUMENT_ROOT"].'/models/Bmm_User_SessionsDataAccess.php');
use \brandmeaningmatrix\model\Bmm_User_SessionsDataAccess;
require_once($_SERVER["DOCUMENT_ROOT"].'/models/Bmm_Results.php');
use \brandmeaningmatrix\model\Bmm_Results;
require_once($_SERVER["DOCUMENT_ROOT"].'/models/Bmm_AttributesDataAccess.php');
use \brandmeaningmatrix\model\Bmm_AttributesDataAccess;

$seq = (isset($_POST['id'])) ? $_POST : $_GET;
$bmmUserSessionDA = new Bmm_User_SessionsDataAccess();
$user = $bmmUserSessionDA->getByBmmSessionSeq($seq['id']);
$bmmResults = new Bmm_Results();
$user_images = $bmmResults->getResultsImages($seq['id']);
$radar_charts = $bmmResults->getBenchmarkRadar($user->primary_type);
// var_dump($user);
// var_dump($radar_charts);
$radar_name_one = $radar_charts[0]->name;
$radar_name_two = $radar_charts[1]->name;
$radar_img_one = $radar_charts[0]->radar_chart;
$radar_img_two = $radar_charts[1]->radar_chart;
$radar_text_one = $radar_charts[0]->description;
$radar_text_two = $radar_charts[1]->description;
//die();
// var_dump($user_images);
// die();
//set page variables
$brandname = html_entity_decode($user->brand_name, ENT_QUOTES | ENT_XML1, 'UTF-8');
$count_brand_name = strlen($brandname);
if($count_brand_name > 20) {
	$brandname = mb_strimwidth($brandname, 0, 20, "...");
}
$radar_compare_image = '';
if(!empty($user_images)) {
	foreach($user_images as $a_image) {
		if($a_image->type == 'radar_compare_brand_type') {
			$radar_compare_image = $a_image->image_url;
		}
	}
}
$bmmAttributesDA = new Bmm_AttributesDataAccess();
$send_data = new stdClass();
$send_data->attribute_code = $user->top_attribute_code;
$bmm_attributes = $bmmAttributesDA->getByAttrCode($send_data);
$attribute_category = $user->primary_type;

if($attribute_category == 'Functional') {
	$css_class_color = 'functional_background_color';
} elseif ($attribute_category == 'Experience') {
	$css_class_color = 'experience_background_color';
} elseif ($attribute_category == 'Image') {
	$css_class_color = 'image_background_color';
} elseif ($attribute_category == 'Mentor') {
	$css_class_color = 'mentor_background_color';
}
?>
<html>
	<head>
		<style>
			.purple_text {
				color: #564f75;
			}
			.heading_title {
				font-size: 30px;
				text-align: center;
				font-family: Arial, "Helvetica Neue", Helvetica, sans-serif;
				margin-bottom: 5px;
			}
			.page_two_paragraph_text {
				font-family: Arial, "Helvetica Neue", Helvetica, sans-serif;
				color: #656565;
				font-size: 14px;
				font-weight: normal;
				line-height: 18px;
				letter-spacing: 0.5px;
				font-variant: normal;
				margin-top: 10px;
				line-height: 1.5;
			}
			.brand_type_icon {
				height: 40px;
				width: 40px;
			}
			.spacer td {
				padding-top: 10px;
				padding-bottom: 10px
			}
			.tripple_spacer td {
				padding-top: 50px;
				padding-bottom: 50px
			}
			.header_hr {
				height: 2px;
				background-color: #564f75;
				color: #564f75;
				border-top: solid 2px #564f75 !important;
				padding-top: 0px;
				padding-bottom: 0px;
			}
			.brand_radar_table {
				margin-top: 15px; 
				width: 100%; 
				background-color: #fff;
			} 
			.no-border {
				border: none;
			}
			.two_radar_charts_table {
				margin-top: 5px; 
				width: 100%; 
				background-color: #fff;
			}
			.radar_name_text {
				background-color: #fff; 
				color: #564f75; 
				text-align: center;
				padding-top: 3px;
				padding-bottom: 5px;
				font-size: 17px;
			}
			.center_me {
				text-align: center;
			}
			.radar_desc_text {
				line-height: 14px; 
				color: #564f75; 
				font-size: 12px;
				padding: 0 25px 20px 30px;
				line-height: 1.4;
			}
			.radar_two_image {
				height: 230px;
			}
			.my_brand_img_h {
				height: 250px;
				padding-top: 1px;
				padding-bottom: 1px;
			}
			.table_text_brand {
				margin-right: 20px; 
				margin-left: 15px;
			}
			.table_text_brand_p {
				color: #656565; 
				font-size: 14px;
				padding-top: 20px;
				padding-right: 20px;
			}
			.table_brand_key_chart {
				margin-top: 15px; 
				margin-left: 15px;
			}
			.table_brand_key_chart_img {
				width: 20px; 
				height: auto;
			}
			.table_brand_key_chart_txt {
				font-size: 12px; 
				color: #656565;
			}
			.table_bench_vs_brand {
				margin-top: 15px; 
				margin-left: 15px;
			}
			.title_bench_vs {
				background-color: #fff; 
				color: #564f75; 
				text-align: center;
				padding-top: 5px;
				padding-bottom: 8px;
				font-size: 17px;
			}
			.padding_image {
				padding-top: 7px;
			}
			.full_width {
				width: 100%;
			}
			.brand_type_icon_three {
				width: 25px;
				height: 25px;
			}
			.bottom_i_padding {
				padding-bottom: 20px;
			}
			.padding_mentor_td {
				padding-left: 8px;
			}
			.functional_background_color {
				/*background-color: #A4C230;*/
				background: rgba(164, 194, 48, 0.25);
			}
			.experience_background_color {
				/*background-color: #F38B00;*/
    			background: rgba(243, 139, 0, 0.25);
			}
			.image_background_color {
				/*background-color: #00AFE3;*/
				background: rgba(0, 175, 227, 0.25);
			}
			.mentor_background_color {
				/*background-color: #564f75;*/
				background: rgba(51, 11, 56, 0.25);
			}
			.border_botom_dotted {
				border-bottom: 2px dotted #564f75;
			}
		</style>
	</head>
	<body>
		<section class="page_three_pdf">
		    <p class="purple_text heading_title">How Does Your Brand Compare?</p>
			<hr class="header_hr">
			<p class="page_two_paragraph_text">By understanding how your brand's typology compares with other benchmark brands, you can begin to see some of the different strategies these brands employ &mdash; and gain insight into how best to shape your brand's marketplace meaning.</p>

			<table class="no-border brand_radar_table" border="0" cellspacing="0" cellpadding="1">
				<tr>
					<td colspan="2" class="title_bench_vs"><?= $brandname ?> vs. Average of Benchmark Brands &ndash; <?= $attribute_category ?></td>
				</tr>
				<tr>
					<td colspan="2" class="border_botom_dotted"></td>
				</tr>
				<tr>
					<td>
						<table class="no-border" border="0" cellspacing="0" cellpadding="1">
							<tr>
								<td style="padding-top: 10px;" class="full_width" align="center">
									<img class="brand_type_icon_three" src="/img/letter-f-new.png" alt="Functional">
								</td>
							</tr>
							<tr>
								<td>
									<table class="no-border" border="0" cellspacing="0" cellpadding="1">
										<tr>
											<td class="padding_mentor_td">
												<img class="brand_type_icon_three" src="/img/letter-m-new.png" alt="Mentor">
											</td>
											<td>
												<img class="my_brand_img_h" src="<?= $radar_compare_image ?>">
											</td>
											<td>
												<img class="brand_type_icon_three" src="/img/letter-e-new.png" alt="Experience">
											</td>
										</tr>
									</table>
								</td>
							</tr>
							<tr>
								<td class="full_width bottom_i_padding" align="center">
									<img class="brand_type_icon_three" src="/img/letter-i-new.png" alt="Image">
								</td>
							</tr>
						</table>
					</td>
					<td valign="top">
						<table class="table_text_brand">
							<tr>
								<td class="table_text_brand_p">
									Take a look at how your brand's results compare to the average results of other predominantly <?= $attribute_category ?> brands &mdash; and note how their secondary, tertiary and quaternary attributes differ or align with your overall results.
								</td>
							</tr>
						</table>
						<table class="table_brand_key_chart">
							<tr>
								<td><img class="table_brand_key_chart_img" src="/img/legend-functional-new.png"></td>
								<td class="table_brand_key_chart_txt">Functional</td>
							</tr>
							<tr>
								<td><img class="table_brand_key_chart_img" src="/img/legend-experience-new.png"></td>
								<td class="table_brand_key_chart_txt">Experience</td>
							</tr>
							<tr>
								<td><img class="table_brand_key_chart_img" src="/img/legend-image-new.png"></td>
								<td class="table_brand_key_chart_txt">Image</td>
							</tr>
							<tr>
								<td><img class="table_brand_key_chart_img" src="/img/legend-mentor-new.png"></td>
								<td class="table_brand_key_chart_txt">Mentor</td>
							</tr>
						</table>
						<table class="table_bench_vs_brand">
							<tr>
								<td>
									<table>
										<tr>
											<td style="height: 20px; width: 20px;" class="<?= $css_class_color ?>"></td>
										</tr>
									</table>
								</td>
								<td class="table_brand_key_chart_txt"><?= $brandname ?></td>
							</tr>
							<tr>
								<td>
									<table>
										<tr>
											<td style="height: 20px; width: 20px; background-color: #AAAAAA"></td>
										</tr>
									</table>
								</td>
								<td class="table_brand_key_chart_txt">Average of Benchmark Brands</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>

			<table class="no-border two_radar_charts_table" border="0" cellspacing="0" cellpadding="0">
				<tr>
					<td class="radar_name_text" style="border-right: 2px solid #fff;">
						<?= $radar_name_one ?><sup>&reg;</sup>
						<table style="width: 100%;">
							<tr>
								<td class="border_botom_dotted"></td>
							</tr>
						</table>
					</td>
					<td class="radar_name_text" style="border-left: 2px solid #fff;">
						<?= $radar_name_two ?><sup>&reg;</sup>
						<table style="width: 100%;">
							<tr>
								<td class="border_botom_dotted"></td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td class="center_me padding_image">
						<img class="radar_two_image" src="<?= $radar_img_one ?>">
					</td>
					<td class="center_me padding_image">
						<img class="radar_two_image" src="<?= $radar_img_two ?>">
					</td>
				</tr>
				<tr>
					<td class="radar_desc_text">
						<?= $radar_text_one ?>
					</td>
					<td class="radar_desc_text">
						<?= $radar_text_two ?>
					</td>
				</tr>
			</table>
			
		</section><!--end #page_one -->
	</body>
</html>