<?php
require_once($_SERVER["DOCUMENT_ROOT"].'/models/Bmm_User_SessionsDataAccess.php');
use \brandmeaningmatrix\model\Bmm_User_SessionsDataAccess;
require_once($_SERVER["DOCUMENT_ROOT"].'/models/Bmm_Results.php');
use \brandmeaningmatrix\model\Bmm_Results;
require_once($_SERVER["DOCUMENT_ROOT"].'/models/DomainUtil.php');
use \brandmeaningmatrix\model\DomainUtil;

$seq = (isset($_POST['id'])) ? $_POST : $_GET;
$bmmUserSessionDA = new Bmm_User_SessionsDataAccess();
$user = $bmmUserSessionDA->getByBmmSessionSeq($seq['id']);
$bmmResults = new Bmm_Results();
$user_images = $bmmResults->getResultsImages($seq['id']);
$domainUtil = new DomainUtil();
$root_url = $domainUtil->getRoot();

//set page variables
$brandname = html_entity_decode($user->brand_name, ENT_QUOTES | ENT_XML1, 'UTF-8');
?>
<html>
	<head>
		<style>
			.special_bg {
/*				background-image: url(/img/purple_bg.jpg);*/
/*				background-image-resize:6;*/
          background: #564f75;
			}
			@page {
				margin-top: 4%;
				margin-bottom: 4%;
				margin-left: 6%;
				margin-right: 6%;
				background-color: #fff;
				odd-footer-name: LogoFooter;
			}
			.white-text {
				color: #fff;
			}
			td {
				font-family: Arial, "Helvetica Neue", Helvetica, sans-serif;
				font-size: 16px;
				font-weight: normal;
				line-height: 18px;
				letter-spacing: 0.5px;
				font-variant: normal;
			}
			.brand_name_page_one {
				font-family: Arial, "Helvetica Neue", Helvetica, sans-serif;
				font-size: 24px;
				font-weight: normal;
				line-height: 24px;
				letter-spacing: 0.5px;
				color: #fff;
				text-align: center;
				padding-top: 65px;
				font-variant: normal;
				padding-bottom: 400px;
			}
			.white_hr {
				height: 2px;
				background-color: #fff;
				color: #fff;
				border-top: solid 2px #fff !important;
				padding-top: 0px;
				padding-bottom: 0px;
			}
			.center_text {
				text-align: center;
			}
			.first_page_paragraph {
				font-family: Arial, "Helvetica Neue", Helvetica, sans-serif;
				font-size: 14px;
				font-weight: normal;
				line-height: 20px;
				letter-spacing: 0.5px;
				color: #fff;
				text-align: left;
				padding-left: 120px;
				padding-right: 120px;
			}
			.meyocks_logo_first {
				padding-top: 150px;
			}
			.brand_meaing_logo_first {
				padding-top: 75px;
				padding-left: 120px;
				padding-right: 120px;
			}
			.typology_img {
				width: 425px;
			}
			.pgone_meyockslogo {
				width: 200px;
			}
			.one_hundred_percent_height {
				height: 100%;
			}
		</style>
	</head>
	<body>
		<table class="no-border special_bg one_hundred_percent_height">
			<tr>
				<td>
					<table class="no-border first_page_table">
						<tr>
							<td class="center_text meyocks_logo_first">
								<img class="pgone_meyockslogo" src="/img/logo.png" alt="Meyocks">
							</td>
						</tr>
						<tr>
							<td class="center_text brand_meaing_logo_first">
								<img class="typology_img" src="/img/brand-typology-report-2.png" alt="Brand Typology Report">
								<hr class="white_hr">
							</td>
						</tr>
						<tr>
							<td class="first_page_paragraph">
								At Meyocks, we make brands mean more. We developed the Brand Typology Tool to help marketers like you establish a framework for understanding the dimensions that shape your brand's marketplace meaning. Consider this information as a starting point that can assist you in making brand strategy decisions.
							</td>
						</tr>
						<tr>
							<td class="brand_name_page_one">
								<?= $brandname ?>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</body>
</html>