<?php
require_once($_SERVER["DOCUMENT_ROOT"].'/models/Bmm_User_SessionsDataAccess.php');
use \brandmeaningmatrix\model\Bmm_User_SessionsDataAccess;
require_once($_SERVER["DOCUMENT_ROOT"].'/models/Bmm_Results.php');
use \brandmeaningmatrix\model\Bmm_Results;

$seq = (isset($_POST['id'])) ? $_POST : $_GET;
$bmmUserSessionDA = new Bmm_User_SessionsDataAccess();
$user = $bmmUserSessionDA->getByBmmSessionSeq($seq['id']);
$bmmResults = new Bmm_Results();
$user_images = $bmmResults->getResultsImages($seq['id']);
// var_dump($user_images);
// die();
//set page variables
$brandname = html_entity_decode($user->brand_name, ENT_QUOTES | ENT_XML1, 'UTF-8');
$count_brand_name = strlen($brandname);
if($count_brand_name > 20) {
	$brandname = mb_strimwidth($brandname, 0, 20, "...");
}
$polar_image_brand = '';
if(!empty($user_images)) {
	foreach($user_images as $a_image) {
		if($a_image->type == 'polar_brand_type') {
			$polar_image_brand = $a_image->image_url;
		}
	}
}
?>
<html>
	<head>
		<style>
			.purple_text {
				color: #564f75;
			}
			.heading_title {
				font-size: 30px;
				text-align: center;
				font-family: Arial, "Helvetica Neue", Helvetica, sans-serif;
				margin-bottom: 5px;
			}
			.page_two_paragraph_text {
				font-family: Arial, "Helvetica Neue", Helvetica, sans-serif;
				color: #656565;
				font-size: 14px;
				font-weight: normal;
				line-height: 18px;
				letter-spacing: 0.5px;
				font-variant: normal;
				margin-top: 10px;
				margin-bottom: 5px;
				line-height: 1.5;
			}
			.brand_type_icon {
				height: 40px;
				width: 40px;
			}
			.spacer td {
				padding-top: 10px;
				padding-bottom: 10px
			}
			.tripple_spacer td {
				padding-top: 50px;
				padding-bottom: 50px
			}
			.header_hr {
				height: 3px;
				background-color: #564f75;
				color: #564f75;
				border-top: solid 3px #564f75 !important;
				padding-top: 0px;
				padding-bottom: 0px;
			}
			.three_mentor_table {
				margin-top: 10px; 
				width: 100%; 
				background-color: #fff;
			}
			.three_mentor_names {
				background-color: #fff; 
				color: #564f75; 
				text-align: center;
				padding-top: 3px;
				padding-bottom: 5px;
				font-size: 17px;
			}
			.main_mentor_names {
				background-color: #fff; 
				color: #564f75; 
				text-align: center;
				padding-top: 8px;
				padding-bottom: 6px;
				font-size: 17px;
			}
			.center_it {
				text-align: center;
			}
			.chart_img {
				height: 175px;
				width: auto;
				padding-top: 5px;
			}
			.three_mentor_description {
				color: #656565; 
				font-size: 12px;
				padding: 0 15px 0 15px;
				line-height: 1.4;
			}
			.three_mentor_description_one {
				color: #656565; 
				font-size: 12px;
				padding: 1px 15px 0 15px;
				line-height: 1.4;
			}
			.single_polar_table {
				margin-top: 5px; 
				width: 100%; 
				background-color: #fff;
			}
			.description_sub_types {
				color: #656565; 
				font-size: 11px;
			}
			.img_polar_brand {
				height: 300px;
				width: auto;
			}
			.polar_chart_row {
				padding-bottom: 0;
			}
			/*.polar_chart_row_right {
				padding-top: 10px;
			}*/
			.sub_types_extra_pad {
				padding-top: 20px;
			}
			.border_botom_dotted {
				border-bottom: 2px dotted #564f75;
			}
			.full_width {
				width: 100%;
			}
			.text_right {
				text-align: right;
			}
			.img-icon-size {
				width: 26px;
				height: auto;
			}
			.img-icon-size-side {
				width: 26px;
				height: auto;
			}

			.sub_types_key_chart {
				margin-left: 20px;
			}
			.padding-top-0 {
				padding-top: 0px !important;
			}
		</style>
	</head>
	<body>
		<section class="page_four_pdf">
			<p class="purple_text heading_title">Mentor Branding Activities &amp; Opportunities</p>
			<hr class="header_hr">
			<p class="page_two_paragraph_text">Cultural shifts are creating more opportunities for brands to differentiate on the dimension of mentorship &mdash; playing the roles of counselor, resource, champion, motivator and role model. And while not all brands are mentor brands, many brands employ <strong>mentor branding activities</strong> as part of the marketing mix.</p>
			<table class="no-border single_polar_table" border="0" cellspacing="0" cellpadding="0">
				<tr>
					<td colspan="2" class="main_mentor_names">Mentor Branding Characteristics for <?= $brandname ?></td>
				</tr>
				<tr>
					<td colspan="2" class="border_botom_dotted"></td>
				</tr>
				<tr>
					<td>
						<table class="no-border full_width" border="0" cellspacing="0" cellpadding="0" style="padding-left: 20px; padding-right: 30px; padding-top: 15px;">
							<tr>
								<td style="width: 25%">
								</td>
								<td style="width: 25%">
									<img class="img-icon-size" src="/img/brand_type_icons/light_bulb-new.png">
								</td>
								<td class="text_right" style="width: 25%">
									<img class="img-icon-size" src="/img/brand_type_icons/i_book-new.png">
								</td>
								<td style="width: 25%">
								</td>
							</tr>
						</table>
					</td>
					<td></td>
				</tr>
				<tr>
					<td valign="top" class="polar_chart_row">
						<img style="margin-top: -10px;" class="img_polar_brand" src="<?= $polar_image_brand ?>">
					</td>
					<td valign="top" class="polar_chart_row polar_chart_row_right">
						<table class="sub_types_key_chart">
							<tr>
								<td valign="top">
									<img class="img-icon-size-side" src="/img/brand_type_icons/i_book-new.png">
								</td>
								<td class="description_sub_types" valign="top">
									<h3>Information</h3>
									Providing value-added information helps your customers manage the increasingly overwhelming complexity of living in an always-on, always-connected world.
								</td>
							</tr>
							<tr>
								<td valign="top" class="sub_types_extra_pad">
									<img class="img-icon-size-side" src="/img/brand_type_icons/horn-new.png">
								</td>
								<td class="description_sub_types sub_types_extra_pad" valign="top">
									<h3>Advocacy</h3>
									Advocating for your customers and championing causes important to them demonstrates that you share their values and assures them that you're working on their behalf.
								</td>
							</tr>
							<tr>
								<td valign="top" class="sub_types_extra_pad">
									<img class="img-icon-size-side" src="/img/brand_type_icons/light_bulb-new.png">
								</td>
								<td class="description_sub_types sub_types_extra_pad" valign="top">
									<h3>Inspiration</h3>
									Building your customers' confidence and offering encouragement motivates them to pursue happiness, achieve well-being and become their best and most authentic selves.
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td class="center_it">
						<img class="img-icon-size" src="/img/brand_type_icons/horn-new.png">
					</td>
					<td></td>
				</tr>
			</table>
			<table class="no-border three_mentor_table" border="0" cellspacing="1" cellpadding="0">
				<tr>
					<td class="three_mentor_names" style="border-right: 2.5px solid #fff;">
						Amazon<sup>&reg;</sup>
						<table style="width: 100%;">
							<tr>
								<td class="border_botom_dotted"></td>
							</tr>
						</table>
					</td>
					<td class="three_mentor_names">
						Toms<sup>&reg;</sup>
						<table style="width: 100%;">
							<tr>
								<td class="border_botom_dotted"></td>
							</tr>
						</table>
					</td>
					<td class="three_mentor_names" style="border-left: 2px solid #fff;">
						Nike<sup>&reg;</sup>
						<table style="width: 100%;">
							<tr>
								<td class="border_botom_dotted"></td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td class="center_it">
						<img class="chart_img" src="/img/static_charts/amazon_polar-alt-new.png">
					</td>
					<td class="center_it">
						<img class="chart_img" src="/img/static_charts/toms_polar-alt-new.png">
					</td>
					<td class="center_it">
						<img class="chart_img" src="/img/static_charts/nike_polar-alt-new.png">
					</td>
				</tr>
				<tr>
					<td class="three_mentor_description_one">
						While predominantly a functional brand, Amazon<sup>&reg;</sup> scores high for mentoring based on how it provides information that helps customers make purchase decisions.
					</td>
					<td class="three_mentor_description padding-top-0">
						Image-brand Toms<sup>&reg;</sup> shoes scores high for advocacy and inspiration, making a statement both about and on behalf of its customers through its "buy one, give one" initiative.
					</td>
					<td class="three_mentor_description padding-top-0">
						As a mentor brand, Nike<sup>&reg;</sup> shows a balance of mentor branding characteristics, but it scores highest for inspiration &mdash; reflected in how it encourages peak performance at all levels.
					</td>
				</tr>
			</table>
	
		</section><!--end #page_one -->
	</body>
</html>