<?php
require_once($_SERVER["DOCUMENT_ROOT"].'/models/Bmm_User_SessionsDataAccess.php');
use \brandmeaningmatrix\model\Bmm_User_SessionsDataAccess;
require_once($_SERVER["DOCUMENT_ROOT"].'/models/Bmm_Results.php');
use \brandmeaningmatrix\model\Bmm_Results;

$seq = (isset($_POST['id'])) ? $_POST : $_GET;
$bmmUserSessionDA = new Bmm_User_SessionsDataAccess();
$user = $bmmUserSessionDA->getByBmmSessionSeq($seq['id']);
$bmmResults = new Bmm_Results();
$user_images = $bmmResults->getResultsImages($seq['id']);
// var_dump($user_images);
// die();
//set page variables
$brandname = html_entity_decode($user->brand_name, ENT_QUOTES | ENT_XML1, 'UTF-8');
$count_brand_name = strlen($brandname);
if($count_brand_name > 20) {
	$brandname = mb_strimwidth($brandname, 0, 20, "...");
}
$main_brand_type = '';
if(!empty($user_images)) {
	foreach($user_images as $a_image) {
		if($a_image->type == 'main_brand_type') {
			$main_brand_type = $a_image->image_url;
		}
	}
}
?>
<html>
	<head>
		<style>
			.purple_text {
				color: #564f75;
			}
			.heading_title {
				font-size: 30px;
				text-align: center;
				font-family: Arial, "Helvetica Neue", Helvetica, sans-serif;
				margin-bottom: 5px;
			}
			.page_two_paragraph_text {
				font-family: Arial, "Helvetica Neue", Helvetica, sans-serif;
				color: #656565;
				font-size: 15px;
				font-weight: normal;
				line-height: 18px;
				letter-spacing: 0.5px;
				font-variant: normal;
				margin-top: 10px;
			}
			.brand_type_icon {
				height: 40px;
				width: 40px;
			}
			.spacer td {
				padding-top: 10px;
				padding-bottom: 10px
			}
			.tripple_spacer td {
				padding-top: 50px;
				padding-bottom: 50px
			}
			.page_five_main_paragraph_text {
				font-family: Arial, "Helvetica Neue", Helvetica, sans-serif;
				color: #564f75;
				font-size: 17px;
				line-height: 1.4;
			}
			.header_hr {
				height: 2px;
				background-color: #564f75;
				color: #564f75;
				border-top: solid 2px #564f75 !important;
				padding-top: 0px;
				padding-bottom: 0px;
				margin-top: 5px;
				margin-bottom: 5px;
			}
			.para_explain {
				font-family: Arial, "Helvetica Neue", Helvetica, sans-serif;
				color: #656565;
				font-size: 14px;
				font-weight: normal;
				line-height: 1.5;
				letter-spacing: 0.5px;
				font-variant: normal;
				margin-top: 10px;
				padding-top: 5px;
			}
			.small_report_text {
				color: #656565;
				font-size: 10px;
				font-family: Arial, "Helvetica Neue", Helvetica, sans-serif;
			}
			.title-middle-text {
				color: #564f75;
				font-size: 17px;
				font-weight: bold;
				padding-left: 15px;
			}
			.right_side_table {
				margin-left: 15px;
				width: 100%; 
				background-color: #edeceb; 
				padding-left: 15px;
				padding-right: 15px;
				padding-top: 15px;
				padding-bottom: 20px;
			}
			.right_side_text {
				color: #564f75;
				font-size: 14px;
				font-weight: normal;
				line-height: 1.5;
			}
			.meyocks_table {
				padding: 20px 15px 20px 15px;
				margin-top: 25px; 
				width: 100%; 
				background-color: #edeceb;
			}
			.meyocks_help_title {
				color: #564f75;
				font-size: 16px;
				font-weight: bold;
			}
			.meyocks_help_text {
				color: #656565;
				font-family: Arial, "Helvetica Neue", Helvetica, sans-serif;
				color: #656565;
				font-size: 13px;
				font-weight: normal;
				line-height: 18px;
				letter-spacing: 0.5px;
				font-variant: normal;
				margin-top: 10px;
				padding-top: 10px;
			}
			.border_botom_dotted {
				border-bottom: 2px dotted #564f75;
			}
			.the_icons {
				width: 40px;
				height: auto;
			}
		</style>
	</head>
	<body>
		<section class="page_five_pdf">
			<p class="purple_text heading_title">Making <?= $brandname ?> Mean More</p>
			<hr class="header_hr">
			<p class="page_five_main_paragraph_text">With a better sense of your brand's type and its overall marketplace meaning, you're at a good starting point from which to explore future brand strategy decisions. In general, there are two broad strategic options to consider: build on your primary brand dimension or focus on supporting dimensions including mentor branding activities to enhance your overall value proposition and help your brand mean more.</p>
			<table class="no-border" style="margin-top: 15px; width: 100%; background-color: #fff;">
				<tr>
					<td style="width: 65%;">
						<table class="no-border" style="margin-top: 15px; width: 100%; background-color: #fff;">
							<tr>
								<td>
									<table>
										<tr>
											<td>
												<img class="the_icons" src="/img/mean_more_icon-new.png">
											</td>
											<td class="title-middle-text">
												Explore Your Mean More<sup>&reg;</sup> Score
											</td>
										</tr>
									</table>
								</td>
							</tr>
							<tr>
								<td class="border_botom_dotted">
								</td>
							</tr>
							<tr>
								<td class="para_explain">
								One tool for further shaping your brand strategy is the Mean More<sup>&reg;</sup> score, which quantifies the meaningfulness of a brand by measuring the disappointment customers experience with having to go with their second choice in the category. You can <a target="_blank" style="color:#564f75;" href="http://www.meyocks.com/wp-content/uploads/2014/09/Mean_More_White_Paper.pdf">download our free thought paper</a> to learn the steps for deriving your Mean More<sup>&reg;</sup> score and its key drivers including examples of how the score applies across several industry categories.
								</td>
							</tr>
							
						</table>
					</td>
					<td valign="top" style="width: 35%;">
						<table class="no-border right_side_table">
							<tr>
								<td class="right_side_text">
									Mean More<sup>&reg;</sup> scores and mentor branding are more <strong>strongly correlated with revenue growth</strong> than other common brand measurements, including overall brand rating and willingness to recommend.
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>

			<table class="no-border" style="width: 100%; background-color: #fff;">
				<tr>
					<td>
						<table style="margin-top: 20px;">
							<tr>
								<td>
									<img class="the_icons" src="/img/twopurplepeopleicon-new.png">
								</td>
								<td class="title-middle-text">
									Mentor Branding Builds Business
								</td>
							</tr>
							
						</table>
					</td>
				</tr>
				<tr>
					<td class="border_botom_dotted">
					</td>
				</tr>
				<tr>
					<td class="para_explain">
						Mentor branding isn't just about building connections; it's about growing business. Research shows brands that rate high on mentorship characteristics also can enjoy faster revenue growth. For more background on this research and other mentor branding resources, <a target="_blank" style="color:#564f75;" href="http://www.meyocks.com/wp-content/uploads/2014/09/Meyocks_Mentor_Branding.pdf">please download our free thought paper</a> on the topic.
					</td>
				</tr>
			</table>

			<table class="no-border meyocks_table">
				<tr>
					<td class="meyocks_help_title">
						How Can Meyocks Help?
					</td>
				</tr>
				<tr>
					<td class="border_botom_dotted">
					</td>
				</tr>
				<tr>
					<td class="meyocks_help_text">
						To discuss the results of your report, mentor branding or the Mean More<sup>&reg;</sup> score in more detail, please give us a call at 515-327-3429 or send an email to <a href="mailto:dougjeske@meyocks.com" style="color:#564f75;">dougjeske@meyocks.com</a>. We would be happy to help you explore opportunities for building even more meaningful connections with your customers.
						<br>
						<br>
						<strong>Meyocks is a brand communications agency that shapes marketplace meaning for food, agriculture, health and mentor brands. Learn more at meyocks.com.</strong>
					</td>
				</tr>
			</table>
			<p class="small_report_text">Brand names featured in this report are registered trademarks of their respective owners.</p>
		</section><!--end #page_five_pdf -->
	</body>
</html>