<?php
namespace brandmeaningmatrix\model;
use DateTime;

class UserSession {
	public $signedOn;
	public $user;
	public $timeSinceLastAction; // represents time when isSignonSessionSet was called. Our session will timeout after 45 min.

	function __construct(){
		$this->signedOn = false;
		$this->timeSinceLastAction = new DateTime();
	}

	public function updateTimeSinceLastAction() {
		$this->timeSinceLastAction = new DateTime();
	}

	public function destroy() {
		$this->signedOn = false;
		$this->user = null;
		$this->timeSinceLastAction = new DateTime();
	}

}

?>