<?php
namespace brandmeaningmatrix\model;
require_once($_SERVER["DOCUMENT_ROOT"].'/models/model/UserSession.php');
use \brandmeaningmatrix\model\UserSession;
require_once($_SERVER["DOCUMENT_ROOT"].'/models/JsonUtil.php');
use \brandmeaningmatrix\model\JsonUtil;
use DateTime;
use DateInterval;

class SignonSessionHandler {
	const SESSION_TIMEOUT = 'PT2160M'; // 1 day
	private static $SESSION_KEY = 'seq';

	public function __construct() {
		// starting the session if it doesn't already exist
		$sid = session_id();
		if(!$sid) {
			session_start();
		}
	}

	public function getSession($saveTimeSinceLastAction = true) {
		$userSession = $this->_getSession();
		if ($userSession->signedOn) {
			// need to check if session has timed out
			$now = new DateTime();
			$sessionTimeoutTime = $now->sub(new DateInterval(self::SESSION_TIMEOUT));
			if ($userSession->timeSinceLastAction >= $sessionTimeoutTime) {
				// session has NOT timed out, refresh timeSinceLastAction.
				if ($saveTimeSinceLastAction) {
					$this->saveSession($userSession);
				}
			} else {
				// destroying session if session has timed out
				$this->signOut();
				$userSession = $this->_getSession();
			}
		}
		return $userSession;
	}

	/****************************************************************************************************
	 *  Note: getSession creates an empty session object if it does not exist
	 ****************************************************************************************************/
	private function _getSession() {
		$userSession = new userSession(); // default empty session has signedOn set to false
		if (isset($_SESSION[self::$SESSION_KEY])
			&& !empty($_SESSION[self::$SESSION_KEY])) {
			$userSession = unserialize($_SESSION[self::$SESSION_KEY]);
		}
		return $userSession;
	}

	public function saveSession($userSession) {
		$userSession->updateTimeSinceLastAction();
		$serializedSession = serialize($userSession);
		$_SESSION[self::$SESSION_KEY] = $serializedSession;
		session_write_close();
	}

	public function signOut() {
		$userSession = $this->_getSession();
		$userSession->destroy();
		$this->saveSession($userSession);
		//session_destroy();
	}

}

?>