<?php
namespace brandmeaningmatrix\model;
// error_reporting(E_ALL);
// ini_set('display_errors', 1);

require_once($_SERVER["DOCUMENT_ROOT"].'/models/InputFilterUtil.php');
use \brandmeaningmatrix\model\InputFilterUtil;
require_once($_SERVER["DOCUMENT_ROOT"].'/models/SendGridDataAccess.php');
use \brandmeaningmatrix\model\SendGridDataAccess;
require_once($_SERVER["DOCUMENT_ROOT"].'/models/DomainUtil.php');
use \brandmeaningmatrix\model\DomainUtil;
require_once($_SERVER["DOCUMENT_ROOT"].'/models/Bmm_User_SessionsDataAccess.php');
use \brandmeaningmatrix\model\Bmm_User_SessionsDataAccess;
require_once($_SERVER["DOCUMENT_ROOT"].'/models/Bmm_Send_NewsletterDataAccess.php');
use \brandmeaningmatrix\model\Bmm_Send_NewsletterDataAccess;
use stdClass;

class EmailHelper {

	const MESSAGE_FROM_EMAIL = 'dougjeske@meyocks.com';
	const SEND_FROM_NAME = 'Doug Jeske';
	const REPLY_TO_EMAIL = 'dougjeske@meyocks.com';

	public function __construct(){
	}

	public function emailAdminError($data) {
		//sender
		$message_from_email = 'justincateron@meyocks.com';
		$sender_name = 'Justin Cateron';
		//receiver
		$message_to = array();
		$message_to[0] = 'justincateron@meyocks.com';
		//subject
		$subject = 'Error - Meyocks Brand Typology Tool';
		//category
		$category = 'brandmeaning_matrix';
		//html
		$html = '';
		$html .= '<p>Details</p>';
		$html .= '<p>ERRORID: ' . $data->errorID . '</p>';
		$html .= '<p>There was an error the error ID is above.</p>';
		//set substitutions
		$substitutions = null;
		//set reply_to
		$reply_to = null;
		//send the message
		$sendgridDA = new SendGridDataAccess();
		$sendgridDA->eMail($message_to, $message_from_email, $subject, $category, $html, $sender_name, $substitutions, $reply_to);
	}

	public function emailKendra($url, $email) {
		//sender
		$message_from_email = 'justincateron@meyocks.com';
		$sender_name = 'Justin Cateron';
		//receiver
		$message_to = array();
		$message_to[0] = 'kendrakelly@meyocks.com';
		$message_to[1] = 'justincateron@meyocks.com';
		//subject
		$subject = 'Error - Meyocks Brand Typology Tool';
		//category
		$category = 'brandmeaning_matrix';
		//html
		$html = '';
		$html .= '<p>Details</p>';
		$html .= '<p>Potential Email Issue - Please log into SendGrid and see if the email did not send or was blocked.</p>';
		$html .= '<p>Error Email: ' . $email . '</p>';
		$html .= '<p>Error URL: ' . $url . '</p>';
		$html .= '<p>There was an error the url and email are listed above.</p>';
		//set substitutions
		$substitutions = null;
		//set reply_to
		$reply_to = null;
		//send the message
		$sendgridDA = new SendGridDataAccess();
		$sendgridDA->eMail($message_to, $message_from_email, $subject, $category, $html, $sender_name, $substitutions, $reply_to);
	}

	public function sendConfirmationEmail($users_to_email_array) {
		$preHeaderText = "Don't forget to confirm your subscription.";
		//set message html
		//$confirm_url = 'http://www.meyocks.com/confirm-email/?id='.urlencode($email);
		//%confirmurl%
		$html = $this->confirmationHtml($preHeaderText);
		//set message to
		$recipientArray = array();
		$url_substitutions = array();
		foreach ($users_to_email_array as $a_users) {
			array_push($recipientArray, $a_users->email);
			$confirm_url = 'http://www.meyocks.com/confirm-email/?id='.urlencode($a_users->email);
			array_push($url_substitutions, $confirm_url);
		}
		//set the substitutions
		$all_substitutions = new stdClass();
		$all_substitutions->sendgrid_key = '%confirmurl%';
		$all_substitutions->sendgrid_array = $url_substitutions;
		//set message from
		$message_from_email = self::MESSAGE_FROM_EMAIL;
		$send_from_name = self::SEND_FROM_NAME;
		//set message subject
		$subject = 'Please confirm your subscription to Meyocks Speaks';
		//set category
		$category = 'meyocks_email_confirmation';
		//set substitutions
		$substitutions = array($all_substitutions);
		//set reply to
		$reply_to = self::MESSAGE_FROM_EMAIL;
		//send the message
		$sendGridDA = new SendGridDataAccess();
		$sendGridDA->eMail($recipientArray, $message_from_email, $subject, $category, $html, $send_from_name, $substitutions, $reply_to);
	}

	public function sendReportEmail($email, $seq) {
		$preHeaderText = "Here's your customized Brand Typology report.";
		//get the root domain
		$domainUtil = new DomainUtil();
		$root_url = $domainUtil->getRoot();
		$url_substitutions = array();
		$email_online_substitutions = array();
		//set message html
		$html = $this->reportHtml($preHeaderText);
		//set message to
		$recipientArray = array();
		$recipientArray[0] = $email;
		//set message from
		$message_from_email = self::MESSAGE_FROM_EMAIL;
		$send_from_name = self::SEND_FROM_NAME;
		//set message subject
		$subject = 'Your Brand Typology Tool Report';
		//set category
		$category = 'brandmeaning_matrix';
		//set substitutions
		//downloadpdf
		$url_substitutions[0] = $root_url . '/report/index.php?id='.$seq;
		$all_substitutions = new stdClass();
		$all_substitutions->sendgrid_key = '%downloadpdf%';
		$all_substitutions->sendgrid_array = $url_substitutions;
		//set the online view of the email
		$email_online_substitutions[0] = $root_url . '/downloademail.html?survey='.$seq;
		$all_substitutions_online_email = new stdClass();
		$all_substitutions_online_email->sendgrid_key = '%emailViewOnline%';
		$all_substitutions_online_email->sendgrid_array = $email_online_substitutions;
		$substitutions = array($all_substitutions, $all_substitutions_online_email);
		//set reply to
		$reply_to = self::MESSAGE_FROM_EMAIL;
		
		// $sendGridDA = new SendGridDataAccess();
		// $successful_send = $sendGridDA->eMail($recipientArray, $message_from_email, $subject, $category, $html, $send_from_name, $substitutions, $reply_to);
		// if($successful_send->message != 'success') {
		// 	//email kendra
		// 	$this->emailKendra($url_substitutions[0], $email);
		// }
		//we need to send a copy to doug, josh, and kendra
		$this->sendManagementCopy($message_from_email, $category, $send_from_name, $reply_to, $seq, $url_substitutions[0]);
		
	}

	private function sendManagementCopy($message_from_email, $category, $send_from_name, $reply_to, $seq, $download_link) {
		$bmmUserSessionDA = new Bmm_User_SessionsDataAccess();
		$typlogy_tool_taker = $bmmUserSessionDA->getByBmmSessionSeq($seq);
		$typology_taker_email = $typlogy_tool_taker->email_address;
		$typology_taker_brand_name = $typlogy_tool_taker->brand_name;
		$email_management = array();
		$email_management[0] = 'dougjeske@meyocks.com';
		$email_management[1] = 'joshfleming@meyocks.com';
		$email_management[2] = 'kendrakelly@meyocks.com';
		$email_management[3] = 'justincateron@meyocks.com';
		$clean_bran_name = html_entity_decode($typology_taker_brand_name, ENT_QUOTES | ENT_XML1, 'UTF-8');
		$subject = $clean_bran_name  . ' Brand Typology Tool Report';
		//html
		$html = '';
		$html .= '<p>Details</p>';
		$html .= '<p>Brand Name: ' . $typology_taker_brand_name . '</p>';
		$html .= '<p>Email: ' . $typology_taker_email . '</p>';
		$html .= '<p>Download Link: <br>';
		$html .= $download_link . '</p>';
		$substitutions = null;
		$sendGridDA = new SendGridDataAccess();
		$sendGridDA->eMail($email_management, $message_from_email, $subject, $category, $html, $send_from_name, $substitutions, $reply_to);
	}

	public function sendInitialEmail($data) {
		$preHeaderText = "Learn what your brand's type is. Answer a few quick questions about why customers choose your brand and your input will produce a map of the dimensions that shape your brand’s marketplace meaning.";
		//get the root domain
		$domainUtil = new DomainUtil();
		$root_url = $domainUtil->getRoot();
		//set message html
		$html = $this->firstEmailHtml($preHeaderText);
		$url_substitutions = array();
		$email_online_substitutions = array();
		$recipientArray = array();
		foreach($data as $one_email) {
			array_push($recipientArray, $one_email->email_address);
			//set the take survey url
			$survey_url = $root_url . '/index.php?id='.$one_email->bmm_session_seq;
			array_push($url_substitutions, $survey_url);
			//set the online view of the email
			$email_view_line = $root_url . '/firstemail.html?survey='.$one_email->bmm_session_seq;
			array_push($email_online_substitutions, $email_view_line);
		}
		//set message from
		$message_from_email = self::MESSAGE_FROM_EMAIL;
		$send_from_name = self::SEND_FROM_NAME;
		//set message subject
		$subject = "What's Your Brand Type?";
		//set category
		$category = 'brandmeaning_matrix';
		//set substitutions
		$all_substitutions = new stdClass();
		$all_substitutions->sendgrid_key = '%takesurveyurl%';
		$all_substitutions->sendgrid_array = $url_substitutions;
		//set the online view of the email
		$all_substitutions_online_email = new stdClass();
		$all_substitutions_online_email->sendgrid_key = '%emailViewOnline%';
		$all_substitutions_online_email->sendgrid_array = $email_online_substitutions;
		$substitutions = array($all_substitutions, $all_substitutions_online_email);
		//set reply to
		$reply_to = self::MESSAGE_FROM_EMAIL;
		
		$sendGridDA = new SendGridDataAccess();
		$sendGridDA->eMail($recipientArray, $message_from_email, $subject, $category, $html, $send_from_name, $substitutions, $reply_to);
	}

	public function sendSecondEmail($data) {
		$preHeaderText = "Learn what your brand's type is. Answer a few quick questions about why customers choose your brand and your input will produce a map of the dimensions that shape your brand’s marketplace meaning.";
		//get the root domain
		$domainUtil = new DomainUtil();
		$root_url = $domainUtil->getRoot();
		//set message html
		$html = $this->secondEmailHtml($preHeaderText);
		$url_substitutions = array();
		$email_online_substitutions = array();
		$recipientArray = array();
		foreach($data as $one_email) {
			array_push($recipientArray, $one_email->email_address);
			//set the take survey url
			$survey_url = $root_url . '/index.php?id='.$one_email->bmm_session_seq;
			array_push($url_substitutions, $survey_url);
			//set the online view of the email
			$email_view_line = $root_url . '/secondemail.html?survey='.$one_email->bmm_session_seq;
			array_push($email_online_substitutions, $email_view_line);
		}
		//set message from
		$message_from_email = self::MESSAGE_FROM_EMAIL;
		$send_from_name = self::SEND_FROM_NAME;
		//set message subject
		$subject = 'Brand Typology Tool maps marketplace meaning';
		//set category
		$category = 'brandmeaning_matrix';
		//set substitutions
		$all_substitutions = new stdClass();
		$all_substitutions->sendgrid_key = '%takesurveyurl%';
		$all_substitutions->sendgrid_array = $url_substitutions;
		//set the online view of the email
		$all_substitutions_online_email = new stdClass();
		$all_substitutions_online_email->sendgrid_key = '%emailViewOnline%';
		$all_substitutions_online_email->sendgrid_array = $email_online_substitutions;
		$substitutions = array($all_substitutions, $all_substitutions_online_email);
		//set reply to
		$reply_to = self::MESSAGE_FROM_EMAIL;
		
		$sendGridDA = new SendGridDataAccess();
		$sendGridDA->eMail($recipientArray, $message_from_email, $subject, $category, $html, $send_from_name, $substitutions, $reply_to);
	}

	public function sendThirdEmail($data) {
		$preHeaderText = "Learn what your brand's type is. Answer a few quick questions about why customers choose your brand and your input will produce a map of the dimensions that shape your brand’s marketplace meaning.";
		//get the root domain
		$domainUtil = new DomainUtil();
		$root_url = $domainUtil->getRoot();
		//set message html
		$html = $this->thirdEmailHtml($preHeaderText);
		$url_substitutions = array();
		$email_online_substitutions = array();
		$recipientArray = array();
		foreach($data as $one_email) {
			array_push($recipientArray, $one_email->email_address);
			//set the take survey url
			$survey_url = $root_url . '/index.php?id='.$one_email->bmm_session_seq;
			array_push($url_substitutions, $survey_url);
			//set the online view of the email
			$email_view_line = $root_url . '/thirdemail.html?survey='.$one_email->bmm_session_seq;
			array_push($email_online_substitutions, $email_view_line);
		}
		//set message from
		$message_from_email = self::MESSAGE_FROM_EMAIL;
		$send_from_name = self::SEND_FROM_NAME;
		//set message subject
		$subject = 'Get your Brand Typology report today';
		//set category
		$category = 'brandmeaning_matrix';
		//set substitutions
		$all_substitutions = new stdClass();
		$all_substitutions->sendgrid_key = '%takesurveyurl%';
		$all_substitutions->sendgrid_array = $url_substitutions;
		//set the online view of the email
		$all_substitutions_online_email = new stdClass();
		$all_substitutions_online_email->sendgrid_key = '%emailViewOnline%';
		$all_substitutions_online_email->sendgrid_array = $email_online_substitutions;
		$substitutions = array($all_substitutions, $all_substitutions_online_email);
		//set reply to
		$reply_to = self::MESSAGE_FROM_EMAIL;
		
		$sendGridDA = new SendGridDataAccess();
		$sendGridDA->eMail($recipientArray, $message_from_email, $subject, $category, $html, $send_from_name, $substitutions, $reply_to);
	}

	public function firstEmailHtml($preHeaderText) {
		$html = <<<HTML
			<!-- content -->
            <table class="content" width="100%" border="0" cellspacing="0" cellpadding="0" style="border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;">
			    <tbody>
			        <tr>
			            <td class="content_cell product_row" align="left" valign="top" style="padding: 0 0 16px;text-align: center;background-color: #ffffff;border: none; font-size: 0 !important;">
			                <!--[if (gte mso 9)|(IE)]>
					                <table width="580" border="0" cellspacing="0" cellpadding="0" align="center" style="vertical-align: top;">
					                  <tbody>
					                    <tr>
					                      <td width="580" align="left" valign="top">
					                <![endif]-->
			                <div class="row" style="display: inline-block;width: 100%;vertical-align: top;text-align: left;max-width: 580px;margin: 0 auto;">
			                    <!--[if (gte mso 9)|(IE)]>
					                  <table width="580" border="0" cellspacing="0" cellpadding="0" align="center" style="vertical-align: top;">
					                    <tbody>
					                      <tr>
					                      <td width="580" align="center" valign="top">
					                  <![endif]-->
			                    <div class="col-13" style="display: inline-block;width: 100%;vertical-align: top;text-align: center;max-width: 580px;">
			                        <table class="column" width="100%" border="0" cellspacing="0" cellpadding="0" style="border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;vertical-align: top; max-width: 580px;">
			                            <tbody>
			                            	<tr>
                                                <td class="column_cell font_default" align="center" valign="top" style="font-family: Arial, sans-serif;font-size: 20px;text-align: center;vertical-align: top;color: #ffffff;font-weight: bold;padding-bottom: 0;padding-top: 16px;">
                                                    <img width="290" class="header_image_top" src="http://brandtypologytool.com/img/email_extras/four_icons_re_sized.png" alt="Meyocks" style="line-height: 1; outline: none; border: 0;text-decoration: none; -ms-interpolation-mode: bicubic; mso-line-height-rule: exactly; width: 290px; height: auto;" />
                                                </td>
                                                <!-- /.column_cell -->
                                            </tr>
                                            <tr height="10" style="height: 10px;">
                                            	<td>
                                            	</td>
                                            </tr>
			                                <tr>
			                                    <td class="column_cell font_default" align="center" valign="top" style="padding: 0;font-family: Arial, sans-serif;font-size: 14px;text-align: left;vertical-align: top;color: #777779;">
			                                    	<p style="font-family: Arial, sans-serif;font-size: 20px;line-height: 150%;margin-top: 8px;margin-bottom: 8px; color: #361E36;">Are you a functional brand? An experience brand? An image brand? A mentor brand?</p>
			                                    </td>
			                                    <!-- /.column_cell -->
			                                </tr>
			                                <tr>
			                                	<td class="column_cell font_default" align="center" valign="top" style="padding: 0;font-family: Arial, sans-serif;font-size: 14px;text-align: left;vertical-align: top;color: #777779;">
			                                			<p style="font-family: Arial, sans-serif;font-size: 14px;line-height: 150%;margin-top: 8px;margin-bottom: 8px;"><a style="color: #361E36;" href="%takesurveyurl%">Take your free Brand Typology assessment</a> to find out.</p>
			                                	</td>
			                                </tr>
			                                <tr>
			                                	<td class="column_cell font_default" align="center" valign="top" style="padding: 0;font-family: Arial, sans-serif;font-size: 14px;text-align: left;vertical-align: top;color: #777779;">
			                                			<p style="font-family: Arial, sans-serif;font-size: 14px;line-height: 150%;margin-top: 8px;margin-bottom: 8px;">Answer a <span style="font-weight: bold;">few quick questions</span> about why customers choose your brand. Your input will produce a map of the dimensions that shape your brand's marketplace meaning &mdash; and you'll receive a free customized Brand Typology report with your results.</p>
			                                	</td>
			                                </tr>
			                                <tr>
			                                	<td class="column_cell font_default" align="center" valign="top" style="padding: 0;font-family: Arial, sans-serif;font-size: 14px;text-align: left;vertical-align: top;color: #777779;">
			                                			<p style="font-family: Arial, sans-serif;font-size: 14px;line-height: 150%;margin-top: 8px;margin-bottom: 8px;">Meyocks invites you to gain useful insight into your brand's meaning in the marketplace.</p>
			                                	</td>
			                                </tr>
			                                <tr>
                                                <td class="column_cell font_default" align="center" valign="top" style="font-family: Arial, sans-serif;font-size: 20px;text-align: center;vertical-align: top;color: #ffffff;font-weight: bold;padding-bottom: 0;padding-top: 16px;">
                                                	<a href="%takesurveyurl%">
                                                    	<img width="435" class="header_image_top" src="http://brandtypologytool.com/img/email_button/try_tool_today_resized.png" alt="Try Meyocks Brand Typology Tool" style="line-height: 1;outline: none;border: 0;text-decoration: none;-ms-interpolation-mode: bicubic;mso-line-height-rule: exactly; width: 435px;height: auto;" />
                                                   	</a>
                                                </td>
                                                <!-- /.column_cell -->
                                            </tr>
			                            </tbody>
			                        </table>
			                        <!-- /.column -->
			                    </div>
			                    <!-- /.col-13 -->
			                    <!--[if (gte mso 9)|(IE)]>
					                        </td>
					                      </tr>
					                    </tbody>
					                  </table>
					                  <![endif]-->
			                </div>
			                <!-- /.row -->
			                <!--[if (gte mso 9)|(IE)]>
					                      </td>
					                    </tr>
					                  </tbody>
					                </table>
					                <![endif]-->
			            </td>
			            <!-- /.content_cell:product_row -->
			        </tr>
			    </tbody>
			</table>
            <!-- end content -->
HTML;

		//get header and footer html and content html
		$header_html = $this->headerHtml($preHeaderText);
		$footer_html = $this->footerHtml();
		$full_html = $header_html . $html . $footer_html;

		return $full_html;
	}

	public function secondEmailHtml($preHeaderText) {
		$html = <<<HTML

		<!-- content -->
        <table class="content" width="100%" border="0" cellspacing="0" cellpadding="0" style="border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;">
		    <tbody>
		        <tr>
		            <td class="content_cell product_row" align="left" valign="top" style="padding: 0 0 16px;text-align: center;background-color: #ffffff;border: none; font-size: 0 !important;">
		                <!--[if (gte mso 9)|(IE)]>
				                <table width="580" border="0" cellspacing="0" cellpadding="0" align="center" style="vertical-align: top;">
				                  <tbody>
				                    <tr>
				                      <td width="580" align="left" valign="top">
				                <![endif]-->
		                <div class="row" style="display: inline-block;width: 100%;vertical-align: top;text-align: left;max-width: 580px;margin: 0 auto;">
		                    <!--[if (gte mso 9)|(IE)]>
				                  <table width="580" border="0" cellspacing="0" cellpadding="0" align="center" style="vertical-align: top;">
				                    <tbody>
				                      <tr>
				                      <td width="580" align="center" valign="top">
				                  <![endif]-->
		                    <div class="col-13" style="display: inline-block;width: 100%;vertical-align: top;text-align: center;max-width: 580px;">
		                        <table class="column" width="100%" border="0" cellspacing="0" cellpadding="0" style="border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;vertical-align: top;">
		                            <tbody>
		                                <tr>
		                                    <td class="column_cell font_default" align="center" valign="top" style="padding: 0;font-family: Arial, sans-serif;font-size: 14px;text-align: left;vertical-align: top;color: #777779;">
		                                    	<p style="font-family: Arial, sans-serif;font-size: 20px;line-height: 150%;margin-top: 8px;margin-bottom: 8px; color: #361E36;">At Meyocks, we help our clients' brands mean more.</p>
		                                        <p style="font-family: Arial, sans-serif;font-size: 14px;line-height: 150%;margin-top: 8px;margin-bottom: 8px;">That's why we developed the Brand Typology Tool &mdash; an assessment that helps marketers like you establish a framework for making brand strategy decisions that will enhance your brand's value proposition.</p>
                                                <p style="font-family: Arial, sans-serif;font-size: 14px;line-height: 150%;margin-top: 8px;margin-bottom: 8px;">We invite you to <a style="color: #361E36;" href="%takesurveyurl%">try the Meyocks Brand Typology Tool</a> for free today.</p>
		                                        <p style="font-family: Arial, sans-serif;font-size: 14px;line-height: 150%;margin-top: 8px;margin-bottom: 8px;">Answer a <span style="font-weight: bold;">few quick questions</span> about why customers choose your brand. Your input will produce a map of the dimensions that shape your brand's marketplace meaning &mdash; and you'll receive a free customized Brand Typology report with your results.</p>
		                                    </td>
		                                    <!-- /.column_cell -->
		                                </tr>
		                                <tr>
                                            <td class="column_cell font_default" align="center" valign="top" style="font-family: Arial, sans-serif;font-size: 20px;text-align: center;vertical-align: top;color: #ffffff;font-weight: bold;padding-bottom: 0;padding-top: 16px;">
                                                <a href="%takesurveyurl%">
                                                    <img width="435" class="header_image_top" src="http://brandtypologytool.com/img/email_button/take_tool_today_resized.png" alt="Take Meyocks Brand Typology Tool" style="line-height: 1;outline: none;border: 0;text-decoration: none;-ms-interpolation-mode: bicubic;mso-line-height-rule: exactly;max-width: 435px;height: auto;" />
                                                </a>
                                            </td>
                                            <!-- /.column_cell -->
                                        </tr>
		                            </tbody>
		                        </table>
		                        <!-- /.column -->
		                    </div>
		                    <!-- /.col-13 -->
		                    <!--[if (gte mso 9)|(IE)]>
				                        </td>
				                      </tr>
				                    </tbody>
				                  </table>
				                  <![endif]-->
		                </div>
		                <!-- /.row -->
		                <!--[if (gte mso 9)|(IE)]>
				                      </td>
				                    </tr>
				                  </tbody>
				                </table>
				                <![endif]-->
		            </td>
		            <!-- /.content_cell:product_row -->
		        </tr>
		    </tbody>
		</table>
        <!-- end content -->
HTML;
		
		//get header and footer html and content html
		$header_html = $this->headerHtml($preHeaderText);
		$footer_html = $this->footerHtml();
		$full_html = $header_html . $html . $footer_html;

		return $full_html;
	}

	public function thirdEmailHtml($preHeaderText) {
		$html = <<<HTML
		<!-- content -->
        <table class="content" width="100%" border="0" cellspacing="0" cellpadding="0" style="border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;">
            <tbody>
                <tr>
                    <td class="content_cell product_row" align="left" valign="top" style="padding: 0 0 16px;text-align: center;background-color: #ffffff;font-size: 0 !important;">
                        <!--[if (gte mso 9)|(IE)]>
                                <table width="580" border="0" cellspacing="0" cellpadding="0" align="center" style="vertical-align: top;">
                                  <tbody>
                                    <tr>
                                      <td width="580" align="left" valign="top">
                                <![endif]-->
                        <div class="row" style="display: inline-block;width: 100%;vertical-align: top;text-align: left;max-width: 580px;margin: 0 auto;">
                            <!--[if (gte mso 9)|(IE)]>
                                  <table width="580" border="0" cellspacing="0" cellpadding="0" align="center" style="vertical-align: top;">
                                    <tbody>
                                      <tr>
                                        <td width="380" align="left" valign="top">
                                  <![endif]-->
                            <div class="col-1" style="display: inline-block;width: 100%;vertical-align: top;text-align: left;max-width: 380px;">
                                <table align="left" class="column" width="100%" border="0" cellspacing="0" cellpadding="0" style="border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;vertical-align: top;">
                                    <tbody>
                                        <tr>
                                            <td class="column_cell font_default" align="center" valign="top" style="padding: 0;font-family: Arial, sans-serif;font-size: 14px;text-align: left;vertical-align: top;color: #777779;">
                                                <p style="font-family: Arial, sans-serif;font-size: 20px;line-height: 150%;margin-top: 8px;margin-bottom: 8px; color: #361E36;">Meyocks invites you to <a style="color: #361E36;" href="%takesurveyurl%">take your free Brand Typology assessment</a> today.</p>
                                                <p style="font-family: Arial, sans-serif;font-size: 14px;line-height: 150%;margin-top: 8px;margin-bottom: 8px;">When finished, you can request a free customized Brand Typology report. Inside you'll find your complete results, comparisons to iconic brands, a breakdown of your brand’s mentorship activities and more.</p>
                                                <p style="font-family: Arial, sans-serif;font-size: 14px;line-height: 150%;margin-top: 8px;margin-bottom: 8px;">Answer a <span style="font-weight: bold;">few quick questions</span> about why customers choose your brand &mdash; and your input will produce a map of the dimensions that shape your brand’s marketplace meaning.</p>
                                            </td>
                                            <!-- /.column_cell -->
                                        </tr>
                                    </tbody>
                                </table>
                                <!-- /.column -->
                            </div>
                            <!-- /.col-1 -->
                            <!--[if (gte mso 9)|(IE)]>
                                      </td>
                                      <td width="200" align="center" valign="top">
                                  <![endif]-->
                            <div class="col-13" style="display: inline-block;width: 100%;vertical-align: top;text-align: center;max-width: 200px;">
                                <table class="column" width="100%" border="0" cellspacing="0" cellpadding="0" style="border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;vertical-align: top;">
                                    <tbody>
                                        <tr>
                                            <img width="200" class="header_image_top" src="http://brandtypologytool.com/img/email_extras/pdf_book_cropped_1.png" alt="Receive Your Report" style="line-height: 1;outline: none;border: 0;text-decoration: none;-ms-interpolation-mode: bicubic;mso-line-height-rule: exactly;max-width: 200px;height: auto;" />
                                            <!-- /.column_cell -->
                                        </tr>
                                    </tbody>
                                </table>
                                <!-- /.column -->
                            </div>
                            <!-- /.col-13 -->
                            <!--[if (gte mso 9)|(IE)]>
                                        </td>
                                      </tr>
                                    </tbody>
                                  </table>
                                  <![endif]-->
                        </div>
                        <!-- /.row -->
                        <!--[if (gte mso 9)|(IE)]>
                                      </td>
                                    </tr>
                                  </tbody>
                                </table>
                                <![endif]-->
                    </td>
                    <!-- /.content_cell:product_row -->
                </tr>
            </tbody>
        </table>

        <table class="content" width="100%" border="0" cellspacing="0" cellpadding="0" style="border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;">
            <tbody>
                <tr>
                    <td class="content_cell product_row" align="left" valign="top" style="padding: 0 0 16px;text-align: center;background-color: #ffffff;border: none; font-size: 0 !important;">
                        <!--[if (gte mso 9)|(IE)]>
                                <table width="580" border="0" cellspacing="0" cellpadding="0" align="center" style="vertical-align: top;">
                                  <tbody>
                                    <tr>
                                      <td width="580" align="left" valign="top">
                                <![endif]-->
                        <div class="row" style="display: inline-block;width: 100%;vertical-align: top;text-align: left;max-width: 580px;margin: 0 auto;">
                            <!--[if (gte mso 9)|(IE)]>
                                  <table width="580" border="0" cellspacing="0" cellpadding="0" align="center" style="vertical-align: top;">
                                    <tbody>
                                      <tr>
                                      <td width="580" align="center" valign="top">
                                  <![endif]-->
                            <div class="col-13" style="display: inline-block;width: 100%;vertical-align: top;text-align: center;max-width: 580px;">
                                <table class="column" width="100%" border="0" cellspacing="0" cellpadding="0" style="border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;vertical-align: top;">
                                    <tbody>
                                        <tr>
                                            <td class="column_cell font_default" align="center" valign="top" style="font-family: Arial, sans-serif;font-size: 20px;text-align: center;vertical-align: top;color: #ffffff;font-weight: bold;padding-bottom: 0;padding-top: 16px;">
                                                <a href="%takesurveyurl%">
                                                     <img width="435" class="header_image_top" src="http://brandtypologytool.com/img/email_button/try_tool_today_resized.png" alt="Try Meyocks Brand Typology Tool" style="line-height: 1;outline: none;border: 0;text-decoration: none;-ms-interpolation-mode: bicubic;mso-line-height-rule: exactly;max-width: 435px;height: auto;" />
                                                </a>
                                            </td>
                                            <!-- /.column_cell -->
                                        </tr>
                                    </tbody>
                                </table>
                                <!-- /.column -->
                            </div>
                            <!-- /.col-13 -->
                            <!--[if (gte mso 9)|(IE)]>
                                        </td>
                                      </tr>
                                    </tbody>
                                  </table>
                                  <![endif]-->
                        </div>
                        <!-- /.row -->
                        <!--[if (gte mso 9)|(IE)]>
                                      </td>
                                    </tr>
                                  </tbody>
                                </table>
                                <![endif]-->
                    </td>
                    <!-- /.content_cell:product_row -->
                </tr>
            </tbody>
        </table>
        <!-- /.content -->
HTML;
		
		//get header and footer html and content html
		$header_html = $this->headerHtml($preHeaderText);
		$footer_html = $this->footerHtml();
		$full_html = $header_html . $html . $footer_html;

		return $full_html;
	}

	public function reportHtml($preHeaderText) {
		// //get the root domain
		// $domainUtil = new DomainUtil();
		// $root_url = $domainUtil->getRoot();
		// //set the report url
		// $report_url = $root_url . '/report/index.php?id='.$seq;
		$html = <<<HTML
			<!-- content -->
            <table class="content" width="100%" border="0" cellspacing="0" cellpadding="0" style="border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;">
			    <tbody>
			        <tr>
			            <td class="content_cell product_row" align="left" valign="top" style="padding: 0 0 16px;text-align: center;background-color: #ffffff;border: none; font-size: 0 !important;">
			                <!--[if (gte mso 9)|(IE)]>
					                <table width="580" border="0" cellspacing="0" cellpadding="0" align="center" style="vertical-align: top;">
					                  <tbody>
					                    <tr>
					                      <td width="580" align="left" valign="top">
					                <![endif]-->
			                <div class="row" style="display: inline-block;width: 100%;vertical-align: top;text-align: left;max-width: 580px;margin: 0 auto;">
			                    <!--[if (gte mso 9)|(IE)]>
					                  <table width="580" border="0" cellspacing="0" cellpadding="0" align="center" style="vertical-align: top;">
					                    <tbody>
					                      <tr>
					                      <td width="580" align="center" valign="top">
					                  <![endif]-->
			                    <div class="col-13" style="display: inline-block;width: 100%;vertical-align: top;text-align: center;max-width: 580px;">
			                        <table class="column" width="100%" border="0" cellspacing="0" cellpadding="0" style="border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;vertical-align: top;">
			                            <tbody>
			                                <tr>
			                                    <td class="column_cell font_default" align="center" valign="top" style="padding: 0;font-family: Arial, sans-serif;font-size: 14px;text-align: left;vertical-align: top;color: #777779;">
			                                    	<p style="font-family: Arial, sans-serif;font-size: 20px;line-height: 150%;margin-top: 8px;margin-bottom: 8px; color: #361E36;">Thank you for completing your Brand Typology assessment.</p>
			                                        <p style="font-family: Arial, sans-serif;font-size: 14px;line-height: 150%;margin-top: 8px;margin-bottom: 8px;">Please use the link below to download your customized report. Inside you'll find your complete results, comparisons to iconic brands, a breakdown of your brand's mentorship characteristics and more.</p>
			                                    </td>
			                                    <!-- /.column_cell -->
			                                </tr>
			                                <tr>
                                                <td class="column_cell font_default" align="center" valign="top" style="font-family: Arial, sans-serif;font-size: 20px;text-align: center;vertical-align: top;color: #ffffff;font-weight: bold;padding-bottom: 0;padding-top: 16px;">
                                                    <a href="%downloadpdf%">
                                                        <img width="349" class="header_image_top" src="http://brandtypologytool.com/img/email_extras/download_button.png" alt="Download Your Customized Report" style="line-height: 1;outline: none;border: 0;text-decoration: none;-ms-interpolation-mode: bicubic;mso-line-height-rule: exactly;max-width: 349px;height: auto;" />
                                                    </a>
                                                </td>
                                                <!-- /.column_cell -->
                                            </tr>
                                            <tr>
                                                <td class="column_cell font_default" align="center" valign="top" style="padding: 0;font-family: Arial, sans-serif;font-size: 14px;text-align: left;vertical-align: top;color: #777779;">
                                                    <p style="font-family: Arial, sans-serif;font-size: 14px;line-height: 150%;margin-top: 8px;margin-bottom: 8px;">We hope this information provides useful insight into your brand's meaning in the marketplace. If you'd like to discuss the results, please give us a call at <a style="color:#361e36" href="tel:5153273429">515-327-3429</a> or send an email to <a style="color:#361e36" href="mailto:dougjeske@meyocks.com">dougjeske@meyocks.com</a>.</p>
                                                    <p style="font-family: Arial, sans-serif;font-size: 14px;line-height: 150%;margin-top: 8px;margin-bottom: 8px; color: #361E36; font-weight: bold;">We would be happy to help you explore opportunities for building even more meaningful connections with your customers.</p>
                                                    
                                                </td>
                                                <!-- /.column_cell -->
                                            </tr>
			                            </tbody>
			                        </table>
			                        <!-- /.column -->
			                    </div>
			                    <!-- /.col-13 -->
			                    <!--[if (gte mso 9)|(IE)]>
					                        </td>
					                      </tr>
					                    </tbody>
					                  </table>
					                  <![endif]-->
			                </div>
			                <!-- /.row -->
			                <!--[if (gte mso 9)|(IE)]>
					                      </td>
					                    </tr>
					                  </tbody>
					                </table>
					                <![endif]-->
			            </td>
			            <!-- /.content_cell:product_row -->
			        </tr>
			    </tbody>
			</table>
            <!-- end content -->
HTML;

		$header_html = $this->headerHtml($preHeaderText);
		$footer_html = $this->footerHtml();
		$full_html = $header_html . $html . $footer_html;

		return $full_html;
	}

	public function headerHtml($preHeaderText) {
		$html = <<<HTML

			<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
			<html>

			<head>
			    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
			    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
			    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
			    <meta name="format-detection" content="telephone=no" />
			    <meta name="format-detection" content="date=no" />
			    <meta name="format-detection" content="address=no" />
			    <meta name="format-detection" content="email=no" />
			    <meta name="robots" content="noindex" />
			    <meta name="googlebot" content="noindex" />
			    <title>Meyocks – Brand Typology Tool</title>
			    <style type="text/css">
			    /* Responsive */
			    
			    @media screen {
			        h1,
			        h2,
			        h3,
			        h4,
			        h5,
			        h6,
			        p,
			        a,
			        .font_default {
			            font-family: Arial, sans-serif !important;
			            /* web font */
			        }
			        .primary_btn td,
			        .secondary_btn td {
			            padding: 0 !important;
			        }
			        .primary_btn a,
			        .secondary_btn a {
			            padding: 12px 24px !important;
			        }
			    }
			    
			    @media screen and (max-width: 600px) {
			        .col-1,
			        .col-2,
			        .col-3,
			        .col-13 {
			            float: left !important;
			        }
			        .jumbotron_cell {
			            background-size: cover !important;
			        }
			        .row,
			        .col-1,
			        .col-13,
			        .col-2,
			        .col-3 {
			            max-width: 100% !important;
			        }
			        .column {
			            border: none !important;
			        }
			        .header_image_top {
			            max-width: 100% !important;
			        }
			        .cell_images_four {
			            width: 50% !important;
			        }
			        .div_footer_responsive {
			            max-width: 50% !important;
			        }
			        .product_row {
			            border: none !important;
			        }
			        .image_thumb {
			            text-align: center !important;
			        }
			    }
			    </style>
			</head>

			<body leftmargin="0" marginwidth="0" topmargin="0" marginheight="0" offset="0" style="margin: 0;padding: 0;min-width: 100%;background-color: #fff;">
				<span class="preheader" style="display:none !important; font-size:1px; color:#ffffff;">Meyocks – Brand Typology Tool</span>
			    <div class="email_body" style="padding: 32px 10px;text-align: center;background-color: #fff;">
			        <!--[if (gte mso 9)|(IE)]>
						  <table width="580" border="0" cellspacing="0" cellpadding="0" align="center" style="vertical-align: top;">
						    <tbody>
						      <tr>
						        <td width="580" align="center" valign="top">
						  <![endif]-->
			        <div class="email_container" style="display: inline-block;width: 100%;vertical-align: top;text-align: center;margin: 0 auto;max-width: 580px;font-size: 0 !important;">
			            <table class="header" width="100%" border="0" cellspacing="0" cellpadding="0" style="border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;">
			                <tbody>
			                	<tr>
			                		<td style="display:none !important; visibility:hidden; mso-hide:all; font-size:1px; color:#ffffff; line-height:1px; max-height:0px; max-width:0px; opacity:0; overflow:hidden;">
										$preHeaderText            
									</td>
			                	</tr>
			                	<tr>
		                            <td align="center" valign="top" style="-webkit-text-size-adjust: 100%;-ms-text-size-adjust: 100%;mso-table-lspace: 0pt;mso-table-rspace: 0pt;">
		                                <table border="0" cellpadding="0" cellspacing="0" width="100%" id="templatePreheader" style="-webkit-text-size-adjust: 100%;-ms-text-size-adjust: 100%;mso-table-lspace: 0pt;mso-table-rspace: 0pt;background-color: #fff;border-bottom: none;margin-bottom: 10px;border-collapse: collapse !important;">
		                                    <tbody>
		                                        <tr>
		                                            <td valign="top" class="preheaderContent" style="padding-top: 10px;padding-right: 20px;padding-bottom: 10px;padding-left: 20px;-webkit-text-size-adjust: 100%;-ms-text-size-adjust: 100%;mso-table-lspace: 0pt;mso-table-rspace: 0pt;color: #bbbbbb;font-family: Arial;font-size: 10px;line-height: 100%;text-align: center;">
		                                                Meyocks – Brand Typology Tool - Can't see this email? <a href="%emailViewOnline%" target="_blank" style="-webkit-text-size-adjust: 100%;-ms-text-size-adjust: 100%;color: #bbbbbb;font-weight: normal;text-decoration: underline;">View it online.</a>
		                                            </td>
		                                        </tr>
		                                    </tbody>
		                                </table>
		                            </td>
		                        </tr>
			                    <tr>
			                        <td class="header_cell col-bottom-0" align="center" valign="top" style="padding: 0;text-align: center;padding-bottom: 16px;-webkit-border-radius: 4px 4px 0 0;border-radius: 4px 4px 0 0;background-color: #fff;font-size: 0 !important;">
			                            <!--[if (gte mso 9)|(IE)]>
						                <table width="580" border="0" cellspacing="0" cellpadding="0" align="center" style="vertical-align: top;">
						                  <tbody>
						                    <tr>
						                      <td width="580" align="center" valign="top">
						                <![endif]-->
			                            <div class="row" style="display: inline-block;width: 100%;vertical-align: top;text-align: center;max-width: 580px;margin: 0 auto;">
			                                <!--[if (gte mso 9)|(IE)]>
						                  <table width="580" border="0" cellspacing="0" cellpadding="0" align="center" style="vertical-align: top;">
						                    <tbody>
						                      <tr>
						                        <td width="580" align="center" valign="top">
						                  <![endif]-->
			                                <div class="col-3" style="display: inline-block;width: 100%;vertical-align: top;text-align: center;max-width: 580px;">
			                                    <table class="column" width="100%" border="0" cellspacing="0" cellpadding="0" style="border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;vertical-align: top;">
			                                        <tbody>
			                                            <tr>
			                                                <td class="column_cell font_default" align="center" valign="top" style="font-family: Arial, sans-serif;font-size: 20px;text-align: left;vertical-align: top;color: #ffffff;font-weight: bold;padding-bottom: 0;padding-top: 16px;">
			                                                    <img class="header_image_top" src="http://brandtypologytool.com/img/email_extras/header.png" alt="Meyocks" style="line-height: 1;outline: none;border: 0;text-decoration: none;-ms-interpolation-mode: bicubic;mso-line-height-rule: exactly;max-width: 580px;height: auto;" />
			                                                </td>
			                                                <!-- /.column_cell -->
			                                            </tr>
			                                        </tbody>
			                                    </table>
			                                    <!-- /.column -->
			                                </div>
			                                <!-- /.col-3 -->
			                                <!--[if (gte mso 9)|(IE)]>
						                        </td>
						                      </tr>
						                    </tbody>
						                  </table>
						                  <![endif]-->
			                            </div>
			                            <!-- /.row -->
			                            <!--[if (gte mso 9)|(IE)]>
						                      </td>
						                    </tr>
						                  </tbody>
						                </table>
						                <![endif]-->
			                        </td>
			                        <!-- /.header_cell -->
			                    </tr>
			                </tbody>
			            </table>
			            <!-- /.header -->
HTML;

		return $html;
	}

	public function footerHtml() {
		$html = <<<HTML
			<!-- start footer -->
            <table class="footer" width="580" border="0" cellspacing="0" cellpadding="0" style="border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;">
                <tbody>
                    <tr>
                        <td class="footer_cell" align="center" valign="top" style="padding: 0;text-align: center;padding-bottom: 16px;-webkit-border-radius: 0 0 4px 4px;border-radius: 0 0 4px 4px;background-color: #e9eaea; border:none; font-size: 0 !important;">
                            <!--[if (gte mso 9)|(IE)]>
	                <table width="580" border="0" cellspacing="0" cellpadding="0" align="center" style="vertical-align: top;">
	                  <tbody>
	                    <tr>
	                      <td width="580" align="center" valign="top">
	                <![endif]-->
                            <div class="row" style="display: inline-block;width: 100%;vertical-align: top;text-align: center;max-width: 580px;margin: 0 auto;">
                                <!--[if (gte mso 9)|(IE)]>
	                  <table width="580" border="0" cellspacing="0" cellpadding="0" align="center" style="vertical-align: top;">
	                    <tbody>
	                      <tr>
	                        <td width="390" align="center" valign="top">
	                  <![endif]-->
                                <div class="col-13 col-bottom-0" style="display: inline-block;width: 100%;vertical-align: top;text-align: center;max-width: 390px;">
                                    <table class="column" width="100%" border="0" cellspacing="0" cellpadding="0" style="border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;vertical-align: top;">
                                        <tbody>
                                            <tr>
                                                <td class="column_cell font_default" align="center" valign="top" style="padding: 16px;font-family: Arial, sans-serif;font-size: 12px;text-align: left;vertical-align: top; padding-bottom: 0;padding-top: 16px; line-height:150%">
                                                    <span style="color:#777779;"><a target="_blank" href="http://www.meyocks.com/about/contact/" style="-webkit-text-size-adjust: 100%;-ms-text-size-adjust: 100%;color: #361E36;font-weight: bold;text-decoration: underline;">Contact Us</a> or visit us at </span>
                                                    <a target="_blank" href="http://www.meyocks.com" style="-webkit-text-size-adjust: 100%;-ms-text-size-adjust: 100%;color: #361E36;font-weight: bold;text-decoration: underline;">meyocks.com</a>.
                                                    <br/>
                                                    <br/>
                                                    <span style="color:#777779; font-weight:bold;">
														Copyright ©2016 Meyocks. All Rights Reserved. 
														<br/>
														6800 Lake Drive Suite 150, West Des Moines, IA 50266
					                                </span>
                                                </td>
                                                <!-- /.column_cell -->
                                            </tr>
                                        </tbody>
                                    </table>
                                    <!-- /.column -->
                                </div>
                                <!-- /.col-13 -->
                                <!--[if (gte mso 9)|(IE)]>
	                      </td>
	                      <td width="190" align="center" valign="top">
	                  <![endif]-->
                                <div class="col-1 col-bottom-0" style="display: inline-block;width: 100%;vertical-align: top;text-align: center;max-width: 190px;">
                                    <table class="column" width="100%" border="0" cellspacing="0" cellpadding="0" style="border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;vertical-align: top;">
                                        <tbody>
                                            <tr style="height:10px;">
                                                <td>
                                                </td>
                                            </tr>
                                            <tr>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <table class="column" width="100%" border="0" cellspacing="0" cellpadding="0" style="border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;vertical-align: top; border-left: 1px solid #361e36;">
                                        <tbody>
                                            <tr>
                                                <td class="column_cell font_default" align="center" valign="top" style="font-family: Arial, sans-serif;font-size: 12px;text-align: left;vertical-align: top;color: #361E36;padding-bottom: 0;padding-top: 0; padding-left:16px; padding-right:16px;">
                                                    <a href="https://www.facebook.com/meyocks" target="_blank" style="display: inline-block;text-decoration: none;font-family: Arial, sans-serif;color: #7a7a7a;"><img src="http://brandtypologytool.com/img/social_icons/facebook.png" width="22" height="22" alt="" style="line-height: 1;outline: none;border: 0;text-decoration: none;-ms-interpolation-mode: bicubic;mso-line-height-rule: exactly;" /></a>
                                                    <a href="https://plus.google.com/111097870100904129574/posts" target="_blank" style="display: inline-block;text-decoration: none;font-family: Arial, sans-serif;color: #7a7a7a;"><img src="http://brandtypologytool.com/img/social_icons/googleplus.png" width="22" height="22" alt="" style="line-height: 1;outline: none;border: 0;text-decoration: none;-ms-interpolation-mode: bicubic;mso-line-height-rule: exactly;" /></a>
                                                    <a href="https://www.youtube.com/user/themeyocksgroup" target="_blank" style="display: inline-block;text-decoration: none;font-family: Arial, sans-serif;color: #7a7a7a;"><img src="http://brandtypologytool.com/img/social_icons/youtube.png" width="22" height="22" alt="" style="line-height: 1;outline: none;border: 0;text-decoration: none;-ms-interpolation-mode: bicubic;mso-line-height-rule: exactly;" /></a>
                                                    <a href="https://twitter.com/meyocks" target="_blank" style="display: inline-block;text-decoration: none;font-family: Arial, sans-serif;color: #7a7a7a;"><img src="http://brandtypologytool.com/img/social_icons/twitter.png" width="22" height="22" alt="" style="line-height: 1;outline: none;border: 0;text-decoration: none;-ms-interpolation-mode: bicubic;mso-line-height-rule: exactly;" /></a>
                                                    <a href="https://www.linkedin.com/company/the-meyocks-group" target="_blank" style="display: inline-block;text-decoration: none;font-family: Arial, sans-serif;color: #7a7a7a;"><img src="http://brandtypologytool.com/img/social_icons/linkedin.png" width="22" height="22" alt="" style="line-height: 1;outline: none;border: 0;text-decoration: none;-ms-interpolation-mode: bicubic;mso-line-height-rule: exactly;" /></a>
                                                    <a href="http://feeds.feedburner.com/meyocks" target="_blank" style="display: inline-block;text-decoration: none;font-family: Arial, sans-serif;color: #7a7a7a;"><img src="http://brandtypologytool.com/img/social_icons/blog.png" width="22" height="22" alt="" style="line-height: 1;outline: none;border: 0;text-decoration: none;-ms-interpolation-mode: bicubic;mso-line-height-rule: exactly;" /></a>
                                                </td>
                                                <!-- /.column_cell -->
                                            </tr>
                                            <tr>
                                                <td valign="top" class="rightColumnContentFooter" style="-webkit-text-size-adjust: 100%;-ms-text-size-adjust: 100%;mso-table-lspace: 0pt;mso-table-rspace: 0pt;color: #777779;font-family: Arial;font-size: 12px;padding-top: 16px;padding-right: 16px;padding-bottom: 10px;padding-left: 16px;text-align: left; font-weight:bold;">
                                                    <a href="http://reportmatrix.meyocksdev.com/unsubscribe.html" style="-webkit-text-size-adjust: 100%;-ms-text-size-adjust: 100%;color: #361E36;font-weight: bold;text-decoration: underline;">Unsubscribe</a> <span style="color:#777779;">me from this list.</span>
                                                    <br/>
                                                    <br/>
                                                    <a href="mailto:?subject=Invitation%20to%20Measure%20Your%20Brand%20Typology&body=I%20recently%20completed%20my%20Brand%20Typology%20Tool%20assessment.%20This%20free%20online%20tool%20developed%20by%20Meyocks%20creates%20a%20visual%20matrix%20of%20the%20factors%20that%20shape%20your%20brand%E2%80%99s%20marketplace%20meaning%20%E2%80%93%20and%20generates%20a%20customized%20report%20when%20you%27re%20finished.%0A%0AI%20invite%20you%20to%20try%20it%20for%20your%20brand.%0A%0Ahttp%3A%2F%2Fbrandtypologytool.com%0A" style="-webkit-text-size-adjust: 100%;-ms-text-size-adjust: 100%;color: #361E36;font-weight: bold;text-decoration: underline;">Forward</a> <span style="color:#777779;">to a friend</span>.
                                                </td>
                                            </tr>
                                            <tr style="height:25px;">
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
            <!-- /.column -->
        </div>
        <!-- /.col-1 -->
        <!--[if (gte mso 9)|(IE)]>
	                        </td>
	                      </tr>
	                    </tbody>
	                  </table>
	                  <![endif]-->
    </div>
    <!-- /.row -->
    <!--[if (gte mso 9)|(IE)]>
	                      </td>
	                    </tr>
	                  </tbody>
	                </table>
	                <![endif]-->
    <!-- /.footer_cell -->
    <!-- /.footer -->
    <!-- /.email_container -->
    <!--[if (gte mso 9)|(IE)]>
	        </td>
	      </tr>
	    </tbody>
	  </table>
	  <![endif]-->
    <!-- /.email_body -->
</body>
</html>
HTML;

		return $html;
	}

	public function confirmationHtml($preHeaderText) {
		//$confirm_url = 'http://www.meyocks.com/confirm-email/?id='.urlencode($email);
		$html = <<<HTML
			<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
				<html>
				<head>
				    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
				    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
				    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
				    <meta name="format-detection" content="telephone=no" />
				    <meta name="format-detection" content="date=no" />
				    <meta name="format-detection" content="address=no" />
				    <meta name="format-detection" content="email=no" />
				    <meta name="robots" content="noindex" />
				    <meta name="googlebot" content="noindex" />
				    <title>Meyocks Speaks</title>
				    <style type="text/css">
				    /* Responsive */
				    @media screen {
				        h1,
				        h2,
				        h3,
				        h4,
				        h5,
				        h6,
				        p,
				        a,
				        .font_default {
				            font-family: Arial, sans-serif !important;
				            /* web font */
				        }
				        .primary_btn td,
				        .secondary_btn td {
				            padding: 0 !important;
				        }
				        .primary_btn a,
				        .secondary_btn a {
				            padding: 12px 24px !important;
				        }
				    }
				    
				    @media screen and (max-width: 630px) {
				        .col-1,
				        .col-2,
				        .col-3,
				        .col-13 {
				            float: left !important;
				        }
				        .col-1 {
				            width: 200px !important;
				        }
				        .col-2 {
				            width: 300px !important;
				        }
				        .jumbotron_cell {
				            background-size: cover !important;
				        }
				        .row,
				        .col-1,
				        .col-13,
				        .col-2,
				        .col-3 {
				            max-width: 100% !important;
				        }
				        .column {
				            border: none !important;
				        }
				        .header_image_top {
				            max-width: 100% !important;
				        }
				        .cell_images_four {
				            width: 50% !important;
				        }
				        .div_footer_responsive {
				            max-width: 50% !important;
				        }
				    }
				    </style>
				</head>

				<body leftmargin="0" marginwidth="0" topmargin="0" marginheight="0" offset="0" style="margin: 0;padding: 0;min-width: 100%;background-color: #fff;">
				    <div class="email_body" style="padding: 32px 10px;text-align: center;background-color: #fff;">
				        <!--[if (gte mso 9)|(IE)]>
				  <table width="580" border="0" cellspacing="0" cellpadding="0" align="center" style="vertical-align: top;">
				    <tbody>
				      <tr>
				        <td width="580" align="center" valign="top">
				  <![endif]-->
				        <div class="email_container" style="display: inline-block;width: 100%;vertical-align: top;text-align: center;margin: 0 auto;max-width: 580px;font-size: 0 !important;">
				            <table class="header" width="100%" border="0" cellspacing="0" cellpadding="0" style="border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;">
				                <tbody>
				                	<tr>
				                		<td style="display:none !important; visibility:hidden; mso-hide:all; font-size:1px; color:#ffffff; line-height:1px; max-height:0px; max-width:0px; opacity:0; overflow:hidden;">
											$preHeaderText            
										</td>
				                	</tr>
				                    <tr>
				                        <td class="header_cell col-bottom-0" align="center" valign="top" style="padding: 0;text-align: center;padding-bottom: 16px;-webkit-border-radius: 4px 4px 0 0;border-radius: 4px 4px 0 0;background-color: #fff;font-size: 0 !important;">
				                            <!--[if (gte mso 9)|(IE)]>
				                <table width="580" border="0" cellspacing="0" cellpadding="0" align="center" style="vertical-align: top;">
				                  <tbody>
				                    <tr>
				                      <td width="580" align="center" valign="top">
				                <![endif]-->
				                            <div class="row" style="display: inline-block;width: 100%;vertical-align: top;text-align: center;max-width: 580px;margin: 0 auto;">
				                                <!--[if (gte mso 9)|(IE)]>
				                  <table width="580" border="0" cellspacing="0" cellpadding="0" align="center" style="vertical-align: top;">
				                    <tbody>
				                      <tr>
				                        <td width="580" align="center" valign="top">
				                  <![endif]-->
				                                <div class="col-13" style="display: inline-block;width: 100%;vertical-align: top;text-align: center;max-width: 580px;">
				                                    <table class="column" width="100%" border="0" cellspacing="0" cellpadding="0" style="border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;vertical-align: top;">
				                                        <tbody>
				                                            <tr>
				                                                <td class="column_cell font_default" align="center" valign="top" style="font-family: Arial, sans-serif;font-size: 20px;text-align: left;vertical-align: top;color: #ffffff;font-weight: bold;padding-bottom: 0;padding-top: 16px;">
				                                                    <img width="580" class="header_image_top" src="http://www.meyocks.com/wp-content/themes/meyocks/images/email-confirmation-header.png" alt="Meyocks" style="line-height: 1;outline: none;border: 0;text-decoration: none;-ms-interpolation-mode: bicubic;mso-line-height-rule: exactly;max-width: 580px;height: auto;" />
				                                                </td>
				                                                <!-- /.column_cell -->
				                                            </tr>
				                                        </tbody>
				                                    </table>
				                                    <!-- /.column -->
				                                </div>
				                                <!-- /.col-3 -->
				                                <!--[if (gte mso 9)|(IE)]>
				                        </td>
				                      </tr>
				                    </tbody>
				                  </table>
				                  <![endif]-->
				                            </div>
				                            <!-- /.row -->
				                            <!--[if (gte mso 9)|(IE)]>
				                      </td>
				                    </tr>
				                  </tbody>
				                </table>
				                <![endif]-->
				                        </td>
				                        <!-- /.header_cell -->
				                    </tr>
				                </tbody>
				            </table>
				            <!-- /.header -->
				            <table class="content" width="100%" border="0" cellspacing="0" cellpadding="0" style="border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt; margin-bottom:40px">
				                <tbody>
				                    <tr>
				                        <td class="content_cell product_row" align="left" valign="top" style="padding: 0 0 16px;text-align: center;background-color: #ffffff;border-top: 6px solid;border-color: #361e36;font-size: 0 !important;">
				                            <!--[if (gte mso 9)|(IE)]>
				                <table width="580" border="0" cellspacing="0" cellpadding="0" align="center" style="vertical-align: top;">
				                  <tbody>
				                    <tr>
				                      <td width="580" align="left" valign="top">
				                <![endif]-->
				                            <div class="row" style="display: inline-block;width: 100%;vertical-align: top;text-align: left;max-width: 580px;margin: 0 auto;">
				                                <!--[if (gte mso 9)|(IE)]>
				                  <table width="580" border="0" cellspacing="0" cellpadding="0" align="center" style="vertical-align: top;">
				                    <tbody>
				                      <tr>
				                      <td width="580" align="center" valign="top">
				                  <![endif]-->
				                                <div class="col-13" style="display: inline-block;width: 100%;vertical-align: top;text-align: center;max-width: 580px;">
				                                    <table class="column" width="100%" border="0" cellspacing="0" cellpadding="0" style="border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;vertical-align: top;">
				                                        <tbody>
				                                            <tr>
				                                                <td class="column_cell font_default" align="center" valign="top" style="padding: 0;font-family: Arial, sans-serif;font-size: 14px;text-align: left;vertical-align: top;color: #777779;">
				                                                    <p style="font-family: Arial, sans-serif;font-size: 14px;line-height: 150%;margin-top: 8px;margin-bottom: 8px;">Please confirm your email address - and we'll keep up our end of the deal from there: tagging your inbox at appropriate-but-not-annoying intervals with marketing news, thought leadership, client case studies and other surprises.</p>
				                                                    <p style="font-family: Arial, sans-serif;font-size: 14px;line-height: 150%;margin-top: 8px;margin-bottom: 8px;">If you changed your mind (or feel you've just been the victim of what might possibly be the world's lamest prank), don't worry about it. We only send to confirmed subscribers. Enjoy the rest of your day.</p>
				                                                    
				                                                </td>
				                                                <!-- /.column_cell -->
				                                            </tr>
				                                            <tr>
				                                                <td class="outlook" valign="top" align="center">
				                                                    <a href="%confirmurl%" target="_blank">
				                                                        <img src="http://www.meyocks.com/wp-content/themes/meyocks/images/confirmation-button.png" alt="Confirmation Button"/>
				                                                    </a>
				                                                </td>
				                                            </tr>
				                                        </tbody>
				                                    </table>
				                                    <!-- /.column -->
				                                </div>
				                                <!-- /.col-13 -->
				                                <!--[if (gte mso 9)|(IE)]>
				                        </td>
				                      </tr>
				                    </tbody>
				                  </table>
				                  <![endif]-->
				                            </div>
				                            <!-- /.row -->
				                            <!--[if (gte mso 9)|(IE)]>
				                      </td>
				                    </tr>
				                  </tbody>
				                </table>
				                <![endif]-->
				                        </td>
				                        <!-- /.content_cell:product_row -->
				                    </tr>
				                </tbody>
				            </table>
				            <!-- /.content -->
				           
				            <table class="footer" width="100%" border="0" cellspacing="0" cellpadding="0" style="border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;">
				                <tbody>
				                    <tr>
				                        <td class="footer_cell" align="center" valign="top" style="padding: 0;text-align: center;padding-bottom: 16px;-webkit-border-radius: 0 0 4px 4px;border-radius: 0 0 4px 4px;background-color: #e9eaea; border:none; font-size: 0 !important;">
				                            <!--[if (gte mso 9)|(IE)]>
				                <table width="580" border="0" cellspacing="0" cellpadding="0" align="center" style="vertical-align: top;">
				                  <tbody>
				                    <tr>
				                      <td width="580" align="center" valign="top">
				                <![endif]-->
				                            <div class="row" style="display: inline-block;width: 100%;vertical-align: top;text-align: center;max-width: 580px;margin: 0 auto;">
				                                <!--[if (gte mso 9)|(IE)]>
				                  <table width="580" border="0" cellspacing="0" cellpadding="0" align="center" style="vertical-align: top;">
				                    <tbody>
				                      <tr>
				                        <td width="390" align="center" valign="top">
				                  <![endif]-->
				                                <div class="col-13 col-bottom-0" style="display: inline-block;width: 100%;vertical-align: top;text-align: center;max-width: 390px;">
				                                    <table class="column" width="100%" border="0" cellspacing="0" cellpadding="0" style="border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;vertical-align: top;">
				                                        <tbody>
				                                            <tr>
				                                                <td class="column_cell font_default" align="center" valign="top" style="padding: 16px;font-family: Arial, sans-serif;font-size: 12px;text-align: left;vertical-align: top;color: #777779;padding-bottom: 0;padding-top: 16px; line-height:150%">
				                                                    <span style="color:#777779;"><a target="_blank" href="http://www.meyocks.com/about/contact/" style="-webkit-text-size-adjust: 100%;-ms-text-size-adjust: 100%;color: #361E36;font-weight: bold;text-decoration: underline;">Contact Us</a> or visit us at </span>
                                               	 					<a target="_blank" href="http://www.meyocks.com" style="-webkit-text-size-adjust: 100%;-ms-text-size-adjust: 100%;color: #361E36;font-weight: bold;text-decoration: underline;">meyocks.com</a>.
				                                                    <br/>
				                                                    <br/>
				                                                    <span style="color:#777779; font-weight:bold;">
																		Copyright ©2016 Meyocks. All Rights Reserved. 
																		<br/>
																		6800 Lake Drive Suite 150, West Des Moines, IA 50266
									                                </span>
				                                                </td>
				                                                <!-- /.column_cell -->
				                                            </tr>
				                                        </tbody>
				                                    </table>
				                                    <!-- /.column -->
				                                </div>
				                                <!-- /.col-13 -->
				                                <!--[if (gte mso 9)|(IE)]>
				                      </td>
				                      <td width="190" align="center" valign="top">
				                  <![endif]-->
				                                <div class="col-1 col-bottom-0" style="display: inline-block;width: 100%;vertical-align: top;text-align: center;max-width: 190px;">
				                                    <table class="column" width="100%" border="0" cellspacing="0" cellpadding="0" style="border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;vertical-align: top;">
				                                        <tbody>
				                                            <tr style="height:10px;">
				                                                <td>
				                                                </td>
				                                            </tr>
				                                            <tr>
				                                            </tr>
				                                        </tbody>
				                                    </table>
				                                    <table class="column" width="100%" border="0" cellspacing="0" cellpadding="0" style="border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;vertical-align: top; border-left: 1px solid #361e36;">
				                                        <tbody>
				                                            <tr>
				                                                <td class="column_cell font_default" align="center" valign="top" style="font-family: Arial, sans-serif;font-size: 12px;text-align: left;vertical-align: top;color: #361E36;padding-bottom: 0;padding-top: 0; padding-left:16px; padding-right:16px;">
				                                                    <a href="https://www.facebook.com/meyocks" target="_blank" style="display: inline-block;text-decoration: none;font-family: Arial, sans-serif;color: #7a7a7a;"><img src="http://www.meyocks.com/meyocks-speaks/spring-2016/images/facebook.gif" width="22" height="22" alt="" style="line-height: 1;outline: none;border: 0;text-decoration: none;-ms-interpolation-mode: bicubic;mso-line-height-rule: exactly;" /></a>
				                                                    <a href="https://plus.google.com/111097870100904129574/posts" target="_blank" style="display: inline-block;text-decoration: none;font-family: Arial, sans-serif;color: #7a7a7a;"><img src="http://www.meyocks.com/meyocks-speaks/spring-2016/images/googleplus.gif" width="22" height="22" alt="" style="line-height: 1;outline: none;border: 0;text-decoration: none;-ms-interpolation-mode: bicubic;mso-line-height-rule: exactly;" /></a>
				                                                    <a href="https://www.youtube.com/user/themeyocksgroup" target="_blank" style="display: inline-block;text-decoration: none;font-family: Arial, sans-serif;color: #7a7a7a;"><img src="http://www.meyocks.com/meyocks-speaks/spring-2016/images/youtube.gif" width="22" height="22" alt="" style="line-height: 1;outline: none;border: 0;text-decoration: none;-ms-interpolation-mode: bicubic;mso-line-height-rule: exactly;" /></a>
				                                                    <a href="https://twitter.com/meyocks" target="_blank" style="display: inline-block;text-decoration: none;font-family: Arial, sans-serif;color: #7a7a7a;"><img src="http://www.meyocks.com/meyocks-speaks/spring-2016/images/twitter.gif" width="22" height="22" alt="" style="line-height: 1;outline: none;border: 0;text-decoration: none;-ms-interpolation-mode: bicubic;mso-line-height-rule: exactly;" /></a>
				                                                    <a href="https://www.linkedin.com/company/the-meyocks-group" target="_blank" style="display: inline-block;text-decoration: none;font-family: Arial, sans-serif;color: #7a7a7a;"><img src="http://www.meyocks.com/meyocks-speaks/spring-2016/images/linkedin.gif" width="22" height="22" alt="" style="line-height: 1;outline: none;border: 0;text-decoration: none;-ms-interpolation-mode: bicubic;mso-line-height-rule: exactly;" /></a>
				                                                    <a href="http://feeds.feedburner.com/meyocks" target="_blank" style="display: inline-block;text-decoration: none;font-family: Arial, sans-serif;color: #7a7a7a;"><img src="http://www.meyocks.com/meyocks-speaks/spring-2016/images/rss.gif" width="22" height="22" alt="" style="line-height: 1;outline: none;border: 0;text-decoration: none;-ms-interpolation-mode: bicubic;mso-line-height-rule: exactly;" /></a>
				                                                </td>
				                                                <!-- /.column_cell -->
				                                            </tr>
				                                            <tr>
				                                                <td valign="top" class="rightColumnContentFooter" style="-webkit-text-size-adjust: 100%;-ms-text-size-adjust: 100%;mso-table-lspace: 0pt;mso-table-rspace: 0pt;color: #777779;font-family: Arial;font-size: 12px;padding-top: 16px;padding-right: 16px;padding-bottom: 10px;padding-left: 16px;text-align: left; font-weight:bold;">
				                                                    <a href="http://reportmatrix.meyocksdev.com/unsubscribe.html" style="-webkit-text-size-adjust: 100%;-ms-text-size-adjust: 100%;color: #361E36;font-weight: bold;text-decoration: underline;">Unsubscribe</a> <span style="color:#777779;">me from this list.</span>
				                                                    <br/>
				                                                    <br/>
				                                                    <a href="mailto:?subject=Invitation%20to%20Measure%20Your%20Brand%20Typology&body=I%20recently%20completed%20my%20Brand%20Typology%20Tool%20assessment.%20This%20free%20online%20tool%20developed%20by%20Meyocks%20creates%20a%20visual%20matrix%20of%20the%20factors%20that%20shape%20your%20brand%E2%80%99s%20marketplace%20meaning%20%E2%80%93%20and%20generates%20a%20customized%20report%20when%20you%27re%20finished.%0A%0AI%20invite%20you%20to%20try%20it%20for%20your%20brand.%0A%0Ahttp%3A%2F%2Fbrandtypologytool.com%0A" style="-webkit-text-size-adjust: 100%;-ms-text-size-adjust: 100%;color: #361E36;font-weight: bold;text-decoration: underline;">Forward</a> <span style="color:#777779;">to a friend</span>.
				                                                </td>
				                                            </tr>
				                                            <tr style="height:25px;">
				                                            </tr>
				                                        </tbody>
				                                    </table>
				                                </div>
				                            </div>
				                        </td>
				                    </tr>
				                </tbody>
				            </table>
				            <!-- /.column -->
				        </div>
				        <!-- /.col-1 -->
				        <!--[if (gte mso 9)|(IE)]>
				                        </td>
				                      </tr>
				                    </tbody>
				                  </table>
				                  <![endif]-->
				    </div>
				    <!-- /.row -->
				    <!--[if (gte mso 9)|(IE)]>
				                      </td>
				                    </tr>
				                  </tbody>
				                </table>
				                <![endif]-->
				    <!-- /.footer_cell -->
				    <!-- /.footer -->
				    <!-- /.email_container -->
				    <!--[if (gte mso 9)|(IE)]>
				        </td>
				      </tr>
				    </tbody>
				  </table>
				  <![endif]-->
				    <!-- /.email_body -->
				</body>

			</html>
HTML;

		return $html;
	}

}

?>