<?php
namespace brandmeaningmatrix\model;
// error_reporting(E_ALL);
// ini_set('display_errors', 1);

require_once($_SERVER["DOCUMENT_ROOT"].'/models/DataAccess.php');
use \brandmeaningmatrix\model\DataAccess;
require_once($_SERVER["DOCUMENT_ROOT"].'/models/InputFilterUtil.php');
use \brandmeaningmatrix\model\InputFilterUtil;
require_once($_SERVER["DOCUMENT_ROOT"].'/models/model/Bmm_User_Sessions.php');
use \brandmeaningmatrix\model\Bmm_User_Sessions;
require_once($_SERVER["DOCUMENT_ROOT"] .'/models/Util.php');
use \brandmeaningmatrix\model\Util;
require_once($_SERVER["DOCUMENT_ROOT"].'/models/EmailHelper.php');
use \brandmeaningmatrix\model\EmailHelper;
use stdClass;

class Bmm_User_SessionsDataAccess extends DataAccess {

	public function __construct(){
	}

	public function getForFirstEmail() {
		//filter to clean
		$filterUtil = new InputFilterUtil();
		$params = array();
		//sql
		$sql = 'select * from bmm_user_sessions ';
		$sql .= 'where send_email = :send_email ';
		//params
		$params['send_email'] = 1;
		//excute the statement
		$pdo = $this->getPDO();
		$stmt = $pdo->prepare($sql);
		$stmt->execute($params);
		//rows from db
		$rows = $stmt->fetchALL(\PDO::FETCH_CLASS);
		$users = $this->mapResponseRows(new Bmm_User_Sessions(), $rows);

		if(!empty($users)) {
			//send email
			$emailHelp = new EmailHelper();
			$emailHelp->sendInitialEmail($users);
		} else {
			return false;
		}

	}

	public function getForSecondEmail() {
		//filter to clean
		$filterUtil = new InputFilterUtil();
		$params = array();
		//sql
		$sql = 'select * from bmm_user_sessions ';
		$sql .= 'where send_email = :send_email and ';
		$sql .= 'send_email = :send_email and visited = :visited ';
		//params
		$params['send_email'] = 1;
		$params['visited'] = 0;
		//excute the statement
		$pdo = $this->getPDO();
		$stmt = $pdo->prepare($sql);
		$stmt->execute($params);
		//rows from db
		$rows = $stmt->fetchALL(\PDO::FETCH_CLASS);
		$users = $this->mapResponseRows(new Bmm_User_Sessions(), $rows);

		if(!empty($users)) {
			//send email
			$emailHelp = new EmailHelper();
			$emailHelp->sendSecondEmail($users);
		} else {
			return false;
		}
	}

	public function getForThirdEmail() {
		//filter to clean
		$filterUtil = new InputFilterUtil();
		$params = array();
		//sql
		$sql = 'select * from bmm_user_sessions ';
		$sql .= 'where send_email = :send_email and ';
		$sql .= 'send_email = :send_email and visited = :visited ';
		//params
		$params['send_email'] = 1;
		$params['visited'] = 0;
		//excute the statement
		$pdo = $this->getPDO();
		$stmt = $pdo->prepare($sql);
		$stmt->execute($params);
		//rows from db
		$rows = $stmt->fetchALL(\PDO::FETCH_CLASS);
		$users = $this->mapResponseRows(new Bmm_User_Sessions(), $rows);

		if(!empty($users)) {
			//send email
			$emailHelp = new EmailHelper();
			$emailHelp->sendThirdEmail($users);
		} else {
			return false;
		}
	}

	public function getByBmmSessionSeq($seq) {
		//filter to clean
		$filterUtil = new InputFilterUtil();
		$params = array();
		//sql
		$sql = 'select * ';
		$sql .= 'from bmm_user_sessions ';
		$sql .= 'where bmm_session_seq = :bmm_session_seq ';
		//params
		$params['bmm_session_seq'] = $filterUtil->sanitizeString($seq);
		//excute the statement
		$pdo = $this->getPDO();
		$stmt = $pdo->prepare($sql);
		$stmt->execute($params);
		//rows from db
		$rows = $stmt->fetchALL(\PDO::FETCH_CLASS);
		$user = $this->mapResponseRows(new Bmm_User_Sessions(), $rows);

		if(!empty($user)) {
			return $user[0];
		} else {
			return array();
		}
	}

	private function generateSeqKey() {
		$util = new Util();
		$no_match = true;
		$getSeqKey = '';

		do {
		    $getSeqKey = $util->randStrGen(15);
		    $no_match = $this->checkIfExists($getSeqKey);
		} while($no_match === true);

		return $getSeqKey;
	}

	public function add($data) {
		$seq = '';
		$new_user_added = '';
		if($data['bmm_session_seq'] == '') {
			//need to generate a unique sequence
			$new_user_added = true;
			$seq = $this->generateSeqKey();
		} else {
			$seq = $data['bmm_session_seq'];
			$new_user_added = false;
		}
		$ip = $_SERVER['REMOTE_ADDR'];
		//filter to clean
		$filterUtil = new InputFilterUtil();
		$params = array();
		if($new_user_added == true) {
			$sql = 'insert into bmm_user_sessions ';
			$sql .= '(brand_name, bmm_session_seq, source_ip_address) ';
			$sql .= 'values (';
			$sql .= ':brand_name, ';
			$sql .= ':bmm_session_seq, ';
			$sql .= ':source_ip_address ';
			$sql .= ') ';
		} else {
			//sql
			$sql = 'update bmm_user_sessions set ';
			$sql .= 'brand_name = :brand_name, ';
			$sql .= 'source_ip_address = :source_ip_address ';
			$sql .= 'where bmm_session_seq = :bmm_session_seq ';
		}

		$params["brand_name"] = $filterUtil->sanitizeString($data['brand_name']);
		$params["source_ip_address"] = $filterUtil->sanitizeString($ip);
		$params['bmm_session_seq'] = $filterUtil->sanitizeString($seq);

		$pdo = $this->getPDO();
		$stmt = $pdo->prepare($sql);
		$stmt->execute($params);
		
		return $seq;

	}

	public function updateFinalQuestion($data) {
		if($data['bmm_session_seq'] == '') {
			return false;
			die();
		}
		//filter to clean
		$filterUtil = new InputFilterUtil();
		$params = array();
		//sql
		$sql = 'update bmm_user_sessions set ';
		$sql .= 'top_attribute_code = :top_attribute_code ';
		$sql .= 'where bmm_session_seq = :bmm_session_seq ';
		//params
		$params['bmm_session_seq'] = $filterUtil->sanitizeString($data['bmm_session_seq']);
		$params['top_attribute_code'] = $filterUtil->sanitizeString($data['top_attribute_code']);
		//excute the statement
		$pdo = $this->getPDO();
		$stmt = $pdo->prepare($sql);
		$stmt->execute($params);
		if($stmt->rowCount()){
			//updated
		    return true;
		} else {
			//did not update
		    return false;
		}
	}

	public function updateEmailAddress($email, $seq) {
		if($seq == '') {
			return false;
			die();
		}
		//filter to clean
		$filterUtil = new InputFilterUtil();
		$params = array();
		//sql
		$sql = 'update bmm_user_sessions set ';
		$sql .= 'email_address = :email_address ';
		$sql .= 'where bmm_session_seq = :bmm_session_seq ';
		//params
		$params['email_address'] = $filterUtil->sanitizeEmail($email);
		$params['bmm_session_seq'] = $filterUtil->sanitizeString($seq);
		//excute the statement
		$pdo = $this->getPDO();
		$stmt = $pdo->prepare($sql);
		$stmt->execute($params);
		if($stmt->rowCount()){
			//updated
		    return true;
		} else {
			//did not update
		    return false;
		}
	}

	public function updateVisited($data) {
		if($data['bmm_session_seq'] == '') {
			return false;
			die();
		}
		//filter to clean
		$filterUtil = new InputFilterUtil();
		$params = array();
		//sql
		$sql = 'update bmm_user_sessions set ';
		$sql .= 'visited = 1 ';
		$sql .= 'where bmm_session_seq = :bmm_session_seq ';
		//params
		$params['bmm_session_seq'] = $filterUtil->sanitizeString($data['bmm_session_seq']);
		//excute the statement
		$pdo = $this->getPDO();
		$stmt = $pdo->prepare($sql);
		$stmt->execute($params);
	}

	public function updateCompleted($data) {
		if($data['bmm_session_seq'] == '') {
			return false;
			die();
		}
		//filter to clean
		$filterUtil = new InputFilterUtil();
		$params = array();
		//sql
		$sql = 'update bmm_user_sessions set ';
		$sql .= 'completed = 1 ';
		$sql .= 'where bmm_session_seq = :bmm_session_seq ';
		//params
		$params['bmm_session_seq'] = $filterUtil->sanitizeString($data['bmm_session_seq']);
		//excute the statement
		$pdo = $this->getPDO();
		$stmt = $pdo->prepare($sql);
		$stmt->execute($params);
	}

	public function checkIfComplete($seq) {
		$user_completed = false;
		//filter to clean
		$filterUtil = new InputFilterUtil();
		$params = array();
		//sql
		$sql = 'select * ';
		$sql .= 'from bmm_user_sessions ';
		$sql .= 'where bmm_session_seq = :bmm_session_seq ';
		//params
		$params['bmm_session_seq'] = $filterUtil->sanitizeString($seq);
		//excute the statement
		$pdo = $this->getPDO();
		$stmt = $pdo->prepare($sql);
		$stmt->execute($params);
		//rows from db
		$rows = $stmt->fetchALL(\PDO::FETCH_CLASS);
		$user = $this->mapResponseRows(new Bmm_User_Sessions(), $rows);

		if(!empty($user)) {
			if($user[0]->completed == 1) {
				$user_completed = true;
			}
		}

		return $user_completed;
	}

	public function checkIfExists($seq) {
		$user_exists = false;
		//filter to clean
		$filterUtil = new InputFilterUtil();
		$params = array();
		//sql
		$sql = 'select * ';
		$sql .= 'from bmm_user_sessions ';
		$sql .= 'where bmm_session_seq = :bmm_session_seq ';
		//params
		$params['bmm_session_seq'] = $filterUtil->sanitizeString($seq);
		//excute the statement
		$pdo = $this->getPDO();
		$stmt = $pdo->prepare($sql);
		$stmt->execute($params);
		//rows from db
		$rows = $stmt->fetchALL(\PDO::FETCH_CLASS);
		$user = $this->mapResponseRows(new Bmm_User_Sessions(), $rows);

		if(!empty($user)) {
			$user_exists = true;
		}

		return $user_exists;
	}

	public function updateSubScore($seq, $mentor_subscore_info, $mentor_subscore_advo, $mentor_subscore_insp) {
		//filter to clean
		$filterUtil = new InputFilterUtil();
		$params = array();
		//sql
		$sql = 'update bmm_user_sessions set ';
		$sql .= 'mentor_subscore_info = :mentor_subscore_info, ';
		$sql .= 'mentor_subscore_advo = :mentor_subscore_advo, ';
		$sql .= 'mentor_subscore_insp = :mentor_subscore_insp ';
		$sql .= 'where bmm_session_seq = :bmm_session_seq ';
		//params
		$params['mentor_subscore_info'] = $filterUtil->sanitizeInt($mentor_subscore_info);
		$params['mentor_subscore_advo'] = $filterUtil->sanitizeInt($mentor_subscore_advo);
		$params['mentor_subscore_insp'] = $filterUtil->sanitizeInt($mentor_subscore_insp);
		$params['bmm_session_seq'] = $filterUtil->sanitizeString($seq);
		//excute the statement
		$pdo = $this->getPDO();
		$stmt = $pdo->prepare($sql);
		$stmt->execute($params);
	}

	public function updatePrimaryType($seq, $primary_type) {
		//filter to clean
		$filterUtil = new InputFilterUtil();
		$params = array();
		//sql
		$sql = 'update bmm_user_sessions set ';
		$sql .= 'primary_type = :primary_type ';
		$sql .= 'where bmm_session_seq = :bmm_session_seq ';
		//params
		$params['primary_type'] = $filterUtil->sanitizeString($primary_type);
		$params['bmm_session_seq'] = $filterUtil->sanitizeString($seq);
		//excute the statement
		$pdo = $this->getPDO();
		$stmt = $pdo->prepare($sql);
		$stmt->execute($params);
	}

	// public function initalStarters() {
	// 	//filter to clean
	// 	$filterUtil = new InputFilterUtil();
	// 	$params = array();
	// 	//sql
	// 	$sql = 'select bmm_session_seq, email_address from bmm_user_sessions ';
	// 	$sql .= 'where send_email = :send_email and completed = 0 and bmm_user_session_id > 5480 ';
	// 	//params
	// 	$params['send_email'] = 1;
	// 	//excute the statement
	// 	$pdo = $this->getPDO();
	// 	$stmt = $pdo->prepare($sql);
	// 	$stmt->execute($params);
	// 	//rows from db
	// 	$rows = $stmt->fetchALL(\PDO::FETCH_CLASS);
	// 	$users = $this->mapResponseRows(new Bmm_User_Sessions(), $rows);

	// 	return $users;
		
	// }

	// public function initalStarters() {
	// 	//filter to clean
	// 	$filterUtil = new InputFilterUtil();
	// 	$params = array();
	// 	//sql
	// 	$sql = 'select * from bmm_user_sessions ';
	// 	$sql .= 'where data_source = :data_source and bmm_session_seq is NULL';
	// 	//params
	// 	$params['data_source'] = 'web tool';
	// 	//excute the statement
	// 	$pdo = $this->getPDO();
	// 	$stmt = $pdo->prepare($sql);
	// 	$stmt->execute($params);
	// 	//rows from db
	// 	$rows = $stmt->fetchALL(\PDO::FETCH_CLASS);
	// 	$users = $this->mapResponseRows(new Bmm_User_Sessions(), $rows);

	// 	foreach($users as $a_user) {
	// 		$params = array();
	// 		$seq = $this->generateSeqKey();
	// 		//sql
	// 		$sql = 'update bmm_user_sessions set ';
	// 		$sql .= 'bmm_session_seq = :bmm_session_seq ';
	// 		$sql .= 'where bmm_user_session_id = :bmm_user_session_id ';
	// 		//params
	// 		$params['bmm_session_seq'] = $seq;
	// 		$params['bmm_user_session_id'] = $a_user->bmm_user_session_id;
	// 		//excute the statement
	// 		$pdo = $this->getPDO();
	// 		$stmt = $pdo->prepare($sql);
	// 		$stmt->execute($params);
	// 	}

		
	//}

}

?>