<?php
namespace brandmeaningmatrix\model;
// error_reporting(E_ALL);
// ini_set('display_errors', 1);

require_once($_SERVER["DOCUMENT_ROOT"].'/models/DataAccess.php');
use \brandmeaningmatrix\model\DataAccess;
require_once($_SERVER["DOCUMENT_ROOT"].'/models/InputFilterUtil.php');
use \brandmeaningmatrix\model\InputFilterUtil;
require_once($_SERVER["DOCUMENT_ROOT"].'/models/model/Bmm_Send_Newsletter.php');
use \brandmeaningmatrix\model\Bmm_Send_Newsletter;
require_once($_SERVER["DOCUMENT_ROOT"].'/models/EmailHelper.php');
use \brandmeaningmatrix\model\EmailHelper;
use stdClass;
use DateTime;

class Bmm_Send_NewsletterDataAccess extends DataAccess {

	public function __construct(){
	}

	public function add($email) {
		//filter to clean
		$filterUtil = new InputFilterUtil();
		$params = array();
		//sql stmt
		$sql = "insert into bmm_send_newsletter ";
		$sql .= "(email, send_at, sent) ";
		$sql .= "values (";
		$sql .= ":email, ";
		$sql .= ":send_at, ";
		$sql .= ":sent ";
		$sql .= ") ";
		
		$params['email'] = $filterUtil->sanitizeEmail($email);
		$params['send_at'] = date('Y-m-d H:i:s', strtotime('+1 hours'));
		$params['sent'] = 0;

		$pdo = $this->getPDO();
		$stmt = $pdo->prepare($sql);
		$stmt->execute($params);
	}

	public function get() {
		$date_time_match = date('Y-m-d H:i:s', strtotime('+2 hours'));
		//filter to clean
		$filterUtil = new InputFilterUtil();
		$params = array();
		//sql
		$sql = 'select * ';
		$sql .= 'from bmm_send_newsletter ';
		$sql .= 'where send_at <= :send_at ';
		$sql .= 'and sent = :sent ';
		
		//params
		$params['send_at'] = $date_time_match;
		$params['sent'] = 0;
		//excute the statement
		$pdo = $this->getPDO();
		$stmt = $pdo->prepare($sql);
		$stmt->execute($params);
		$rows = $stmt->fetchALL(\PDO::FETCH_CLASS);
		$users_to_email = array();
		if(!empty($rows)) {
			$users_to_email = $this->mapResponseRows(new Bmm_Send_Newsletter(), $rows);
			//lets send to these users
			$this->sendEmail($users_to_email);
		}

		return $users_to_email;
	}

	public function updateSent($data) {
		if(!empty($data)) {
			foreach($data as $one_email) {
				//update sent
				//filter to clean
				$filterUtil = new InputFilterUtil();
				$params = array();
				//sql
				$sql = 'update bmm_send_newsletter set ';
				$sql .= 'sent = :sent ';
				$sql .= 'where id = :id ';
				//params
				$params['id'] = $filterUtil->sanitizeInt($one_email->id);
				$params['sent'] = 1;
				//excute the statement
				$pdo = $this->getPDO();
				$stmt = $pdo->prepare($sql);
				$stmt->execute($params);
			}
		}
	}

	private function sendEmail($users_to_email) {
		$array_emails = array();
		foreach($users_to_email as $a_user) {
			array_push($array_emails, $a_user->email);
		}
		$emailHelp = new EmailHelper();
		$emailHelp->sendConfirmationEmail($users_to_email);
		$this->updateSent($users_to_email);
	}

}

?>