<?php
namespace brandmeaningmatrix\model;
// error_reporting(E_ALL);
// ini_set('display_errors', 1);

require_once($_SERVER["DOCUMENT_ROOT"].'/models/DataAccess.php');
use \brandmeaningmatrix\model\DataAccess;
require_once($_SERVER["DOCUMENT_ROOT"].'/models/InputFilterUtil.php');
use \brandmeaningmatrix\model\InputFilterUtil;
require_once($_SERVER["DOCUMENT_ROOT"].'/models/Util.php');
use \brandmeaningmatrix\model\Util;
require_once($_SERVER["DOCUMENT_ROOT"].'/models/DomainUtil.php');
use \brandmeaningmatrix\model\DomainUtil;
require_once($_SERVER["DOCUMENT_ROOT"].'/models/EmailHelper.php');
use \brandmeaningmatrix\model\EmailHelper;
require_once($_SERVER["DOCUMENT_ROOT"].'/models/Bmm_User_SessionsDataAccess.php');
use \brandmeaningmatrix\model\Bmm_User_SessionsDataAccess;
require_once($_SERVER["DOCUMENT_ROOT"].'/models/model/Bmm_User_Image.php');
use \brandmeaningmatrix\model\Bmm_User_Image;
require_once($_SERVER["DOCUMENT_ROOT"].'/models/Bmm_AttributesDataAccess.php');
use \brandmeaningmatrix\model\Bmm_AttributesDataAccess;
require_once($_SERVER["DOCUMENT_ROOT"].'/models/All_BrandsDataAccess.php');
use \brandmeaningmatrix\model\All_BrandsDataAccess;
require_once($_SERVER["DOCUMENT_ROOT"].'/models/Bmm_Send_NewsletterDataAccess.php');
use \brandmeaningmatrix\model\Bmm_Send_NewsletterDataAccess;
use stdClass;
use \Imagick;

class Bmm_Results extends DataAccess {

	public $checkHostName;
	private $db_password;
	private $db_host;
	private $db_user;
	private $db_database;

	public function __construct(){
		$this->checkHostName = $_SERVER['SERVER_NAME'];
		if ((strpos($this->checkHostName,'local') !== false) || (strpos($this->checkHostName,'loc') !== false)) {
			//settings for local database
			$this->db_password = 'keC2CafRuPeqsaAEo2';
		} else {
			//settings for production database
			$this->db_password = 'keC2CafRuPeq';
		}
		$this->db_host = 'localhost';
		$this->db_user = 'meyocksprodo';
		$this->db_database = 'meyocksprod';
	}

	public function generateResults($data) {
		$seq = '';
		if($data['bmm_session_seq'] == '') {
			return false;
			die();
		}
		$seq = $data['bmm_session_seq'];
		//filter to clean
		$filterUtil = new InputFilterUtil();
		//sql
		// $link = mysqli_connect('localhost', 'meyocksprodo', 'keC2CafRuPeq', 'meyocksprod');
		$link = mysqli_connect($this->db_host, $this->db_user, $this->db_password, $this->db_database);
		if (!$link) {
			die('Could not connect: ' . mysqli_error($link));
		}
		//results
		$getResults = mysqli_query($link, "CALL bmm_generate_results('$seq')") or die("Query fail: " . mysqli_error($link));
		//$getResults = mysqli_query($link, "call bmm_generate_results(" . $seq . ");") or die("Query fail: " . mysqli_error($link));

		$getResults = mysqli_fetch_array($getResults);

		$scoreFunctional = $getResults['score_functional'];
		$scoreExperience = $getResults['score_experience'];
		$scoreImage = $getResults['score_image'];
		$scoreMentor = $getResults['score_mentor'];
		$primary = $getResults['primary_type'];

		$allBrandsDA = new All_BrandsDataAccess();
		$primary_html = '';
		$radar_charts = '';
		if($primary == 'Functional') {
		    $primary_html = 'a<span class="green strong"> functional brand.</span>';
		    $radar_charts = $allBrandsDA->getFunctional();
		}
		if($primary == 'Experience') {
		    $primary_html = 'an<span class="orange strong"> experience brand.</span>';
		    $radar_charts = $allBrandsDA->getExperience();
		}
		if($primary == 'Image') {
		    $primary_html = 'an <span class="blue strong"> image brand.</span>';
		    $radar_charts = $allBrandsDA->getImage();
		}
		if($primary == 'Mentor') {
		    $primary_html = 'a <span class="purple strong"> mentor brand.</span>';
		    $radar_charts = $allBrandsDA->getMentor();
		}

		$obj = new stdClass();
		$obj->score_functional = $getResults['score_functional'];
		$obj->score_experience = $getResults['score_experience'];
		$obj->score_image = $getResults['score_image'];
		$obj->score_mentor = $getResults['score_mentor'];
		$obj->primary_type = $getResults['primary_type'];
		$obj->primary_html = $primary_html;
		$obj->mentor_subscore_info = $getResults['mentor_subscore_info'];
		$obj->mentor_subscore_advo = $getResults['mentor_subscore_advo'];
		$obj->mentor_subscore_insp = $getResults['mentor_subscore_insp'];
		$obj->compare_radar_charts = $radar_charts;
		//update the users scores
		$bmmUserSessionsDA = new Bmm_User_SessionsDataAccess();
		$bmmUserSessionsDA->updateSubScore($seq, $obj->mentor_subscore_info, $obj->mentor_subscore_advo, $obj->mentor_subscore_insp);
		$bmmUserSessionsDA->updatePrimaryType($seq, $primary);
		return $obj;
	}

	public function reportRequest($data) {
		if($data['bmm_session_seq'] == '') {
			return false;
			die();
		}
		$seq = $data['bmm_session_seq'];
		//filter to clean
		$filterUtil = new InputFilterUtil();
		//sql
		// $link = mysqli_connect('localhost', 'meyocksprodo', 'keC2CafRuPeq', 'meyocksprod');
		$link = mysqli_connect($this->db_host, $this->db_user, $this->db_password, $this->db_database);
		if (!$link) {
			die('Could not connect: ' . mysqli_error());
		}
		$seq = $filterUtil->sanitizeString($seq);
		$email = $filterUtil->sanitizeEmail($data['email']);
		$optin = $filterUtil->sanitizeString($data['optin']);
		//add email
		$bmmUserSessionsDA = new Bmm_User_SessionsDataAccess();
		$email_updated = $bmmUserSessionsDA->updateEmailAddress($email, $seq);
		$emailHelper = new EmailHelper();
		//send report email 
		$emailHelper->sendReportEmail($email, $seq);

		//add confirmation email
		// if($optin == 'Yes') {
		// 	//$emailHelper->sendConfirmationEmail($email);
		// 	$bmmSendNewsLetterDA = new Bmm_Send_NewsletterDataAccess();
		// 	$bmmSendNewsLetterDA->add($email);
		// }

		return $email_updated;
	}

	public function addResultsImage($data) {
		if($data['bmm_session_seq'] == '') {
			return false;
			die();
		}
		$seq = $data['bmm_session_seq'];
		//save the image
		$image_url_save = $this->convertSaveImage($data, $seq);
		//filter to clean
		$filterUtil = new InputFilterUtil();
		$params = array();
		//sql
		$sql = 'insert into bmm_user_image ';
		$sql .= '(bmm_session_seq, image_url, type) ';
		$sql .= 'values (';
		$sql .= ':bmm_session_seq, ';
		$sql .= ':image_url, ';
		$sql .= ':type ';
		$sql .= ') ';
		//params
		$params["bmm_session_seq"] = $filterUtil->sanitizeString($seq);
		$params["image_url"] = $filterUtil->sanitizeString($image_url_save);
		$params["type"] = $filterUtil->sanitizeString($data['type']);
		//excute the statement
		$pdo = $this->getPDO();
		$stmt = $pdo->prepare($sql);
		$stmt->execute($params);
	}

	private function convertSaveImage($data, $seq) {
		$data_uri = $data['image_url'];
		$data_pieces = explode(",", $data_uri);
		$encoded_image = $data_pieces[1];
		$decoded_image = base64_decode($encoded_image);
		$util = new Util();
		$random_name = $util->randStrGen(7);
		$name_file = $random_name . $seq;
		$location_file = $_SERVER["DOCUMENT_ROOT"] . "/img/brandmeaning/".$name_file.".png";
		$resized_location_file = $_SERVER["DOCUMENT_ROOT"] . "/img/brandmeaning/resized_".$name_file.".png";
		$cropped_location_file = $_SERVER["DOCUMENT_ROOT"] . "/img/brandmeaning/cropped_".$name_file.".png";
		file_put_contents($location_file, $decoded_image);

		$resizeInFile = $location_file;
		$resizeOutFile = $resized_location_file;
		$resize_image = new \Imagick($resizeInFile);
		$resize_image->resizeImage(900,450,$resize_image::FILTER_LANCZOS,1);
		$resize_image->writeImage($resizeOutFile);

		$inFile = $resized_location_file;
		$outFile = $cropped_location_file;
		$image = new \Imagick($inFile);
		//$image->cropImage(425, 440, 240, 5);
		if($data['type'] == 'polar_brand_type') {
			$image->cropImage(425, 440, 240, 27);
		} else {
			$image->cropImage(425, 440, 240, 5);
		}
		$image->writeImage($outFile);

		$domainUtil = new DomainUtil();
		$root_url = $domainUtil->getRoot();
		$return_url = $root_url."/img/brandmeaning/cropped_".$name_file.".png";
		//remove the image becauses its on the cdn
		return $return_url;
	}

	public function getResultsImages($seq) {
		//filter to clean
		$filterUtil = new InputFilterUtil();
		$params = array();
		//sql
		$sql = 'select * ';
		$sql .= 'from bmm_user_image ';
		$sql .= 'where bmm_session_seq = :bmm_session_seq ';
		//params
		$params['bmm_session_seq'] = $filterUtil->sanitizeString($seq);
		//excute the statement
		$pdo = $this->getPDO();
		$stmt = $pdo->prepare($sql);
		$stmt->execute($params);
		//rows from db
		$rows = $stmt->fetchALL(\PDO::FETCH_CLASS);
		$all_images = $this->mapResponseRows(new Bmm_User_Image(), $rows);

		return $all_images;
	}

	public function getBenchmarkRadar($attribute_category) {
		$allBrandsDA = new All_BrandsDataAccess();
		$radar_charts = '';
		if($attribute_category == 'Mentor') {
			$radar_charts = $allBrandsDA->getMentor();
		} elseif($attribute_category == 'Functional') {
			$radar_charts = $allBrandsDA->getFunctional();
		} elseif($attribute_category == 'Experience') {
			$radar_charts = $allBrandsDA->getExperience();
		} elseif($attribute_category == 'Image') {
			$radar_charts = $allBrandsDA->getImage();
		} else {
			$radar_charts = $allBrandsDA->getMentor();
		}

		return $radar_charts;
	}

	public function getBenchmarkPolar() {
		$allBrandsDA = new All_BrandsDataAccess();
		$polar_charts = $allBrandsDA->getPolarCharts();

		return $polar_charts;
	}

}

?>