<?php
namespace brandmeaningmatrix\model;
// error_reporting(E_ALL);
// ini_set('display_errors', 1);

require_once($_SERVER["DOCUMENT_ROOT"].'/models/DataAccess.php');
use \brandmeaningmatrix\model\DataAccess;
require_once($_SERVER["DOCUMENT_ROOT"].'/models/InputFilterUtil.php');
use \brandmeaningmatrix\model\InputFilterUtil;
require_once($_SERVER["DOCUMENT_ROOT"].'/models/model/Bmm_Attributes.php');
use \brandmeaningmatrix\model\Bmm_Attributes;

class Bmm_AttributesDataAccess extends DataAccess {

	public function __construct(){
	}

	//$data will be an object here
	public function getByAttrCode($data) {
		//filter to clean
		$filterUtil = new InputFilterUtil();
		$params = array();
		//sql
		$sql = 'select * ';
		$sql .= 'from bmm_attributes ';
		$sql .= 'where attribute_code = :attribute_code ';
		
		//params
		$params['attribute_code'] = $filterUtil->sanitizeString($data->attribute_code);
		//excute the statement
		$pdo = $this->getPDO();
		$stmt = $pdo->prepare($sql);
		$stmt->execute($params);
		
		$rows = $stmt->fetchALL(\PDO::FETCH_CLASS);
		$bmm_attributes = $this->mapResponseRows(new Bmm_Attributes(), $rows);

		return $bmm_attributes[0];
	}

}

?>