<?php
namespace brandmeaningmatrix\model;
// error_reporting(E_ALL);
// ini_set('display_errors', 1);

require_once($_SERVER["DOCUMENT_ROOT"].'/models/DataAccess.php');
use \brandmeaningmatrix\model\DataAccess;
require_once($_SERVER["DOCUMENT_ROOT"].'/models/InputFilterUtil.php');
use \brandmeaningmatrix\model\InputFilterUtil;
require_once($_SERVER["DOCUMENT_ROOT"].'/models/model/Bmm_Attribute_Scores.php');
use \brandmeaningmatrix\model\Bmm_Attribute_Scores;
require_once($_SERVER["DOCUMENT_ROOT"].'/models/Bmm_AttributesDataAccess.php');
use \brandmeaningmatrix\model\Bmm_AttributesDataAccess;
use stdClass;

class Bmm_Attribute_ScoresDataAccess extends DataAccess {

	public function __construct(){
	}

	public function updateOrAdd($data) {
		//true means exists so update
		//false means does not exists so insert
		$exists = $this->checkIfExists($data);
		if($exists == true) {
			$this->update($data);
		} else {
			$this->add($data);
		}
		
	}

	public function getTopThree($data) {
		if($data['bmm_session_seq'] == '') {
			return false;
		}
		//filter to clean
		$filterUtil = new InputFilterUtil();
		$params = array();
		//sql
		$sql = 'select * ';
		$sql .= 'from bmm_attribute_scores ';
		$sql .= 'where bmm_session_seq = :bmm_session_seq ';
		$sql .= 'order by attribute_score DESC LIMIT 3 ';
		//params
		$params['bmm_session_seq'] = $filterUtil->sanitizeString($data['bmm_session_seq']);
		//excute the statement
		$pdo = $this->getPDO();
		$stmt = $pdo->prepare($sql);
		$stmt->execute($params);
		//rows from db
		$rows = $stmt->fetchAll(\PDO::FETCH_CLASS);
		//object to return
		$results = new stdClass();
		$returnArray = array();
		if(!empty($rows)) {
			foreach($rows as $a_row) {
				$a_row->attributes_obj = $this->getAttributes($a_row);
				array_push($returnArray, $a_row);
			}
		}

		return $returnArray;
	}

	private function getAttributes($a_row) {
		$bmmAttributesDA = new Bmm_AttributesDataAccess();
		$attr_obj = $bmmAttributesDA->getByAttrCode($a_row);
		//return the whote Bmm_AttributesDataAccess object
		return $attr_obj;
	}

	private function add($data) {
		if($data['bmm_session_seq'] == '') {
			return false;
		}
		//filter to clean
		$filterUtil = new InputFilterUtil();
		$params = array();
		//sql
		$sql = 'insert into bmm_attribute_scores ';
		$sql .= '(bmm_session_seq, attribute_code, attribute_score) ';
		$sql .= 'values (';
		$sql .= ':bmm_session_seq, ';
		$sql .= ':attribute_code, ';
		$sql .= ':attribute_score ';
		$sql .= ') ';
		//params
		$params['bmm_session_seq'] = $filterUtil->sanitizeString($data['bmm_session_seq']);
		$params['attribute_code'] = $filterUtil->sanitizeString($data['attribute_code']);
		$params['attribute_score'] = $filterUtil->sanitizeInt($data['attribute_score']);
		//excute the statement
		$pdo = $this->getPDO();
		$stmt = $pdo->prepare($sql);
		$stmt->execute($params);
	}
///////////////////////////////////////LOOK AT!!!!!//////////////////////////
	private function update($data) {
		if($data['bmm_session_seq'] == '') {
			return false;
		}
		//filter to clean
		$filterUtil = new InputFilterUtil();
		$params = array();
		//sql
		$sql = 'update bmm_attribute_scores set ';
		$sql .= 'attribute_score = :attribute_score ';
		$sql .= 'where bmm_session_seq = :bmm_session_seq ';
		$sql .= 'and attribute_code = :attribute_code ';
		//params
		$params['bmm_session_seq'] = $filterUtil->sanitizeString($data['bmm_session_seq']);
		$params['attribute_code'] = $filterUtil->sanitizeString($data['attribute_code']);
		$params['attribute_score'] = $filterUtil->sanitizeInt($data['attribute_score']);
		//excute the statement
		$pdo = $this->getPDO();
		$stmt = $pdo->prepare($sql);
		$stmt->execute($params);

	}

	private function checkIfExists($data) {
		$exits = false;
		if($data['bmm_session_seq'] == '') {
			return $exits;
		}
		//filter to clean
		$filterUtil = new InputFilterUtil();
		$params = array();
		//sql
		$sql = 'select * ';
		$sql .= 'from bmm_attribute_scores ';
		$sql .= 'where bmm_session_seq = :bmm_session_seq ';
		$sql .= 'and attribute_code = :attribute_code ';
		//params
		$params['bmm_session_seq'] = $filterUtil->sanitizeString($data['bmm_session_seq']);
		$params['attribute_code'] = $filterUtil->sanitizeString($data['attribute_code']);
		//excute the statement
		$pdo = $this->getPDO();
		$stmt = $pdo->prepare($sql);
		$stmt->execute($params);
		//get the count
		$row_count = $stmt->rowCount();
		//if greater than 0 it exists
		if($row_count > 0) {
			$exits = true;
		}
		return $exits;
	}

}

?>