<?php
namespace brandmeaningmatrix\model;
require_once($_SERVER["DOCUMENT_ROOT"] . '/libs/log4php-2.3.0/Logger.php');
use \Logger;

/****************************************************************************************************
 *  Note: Coding AppLogger as a singleton so that the logging properties are only
 *        parsed once per request, which is the lifetime of all static variables.
 ****************************************************************************************************/
class AppLogger {
	//const GENERIC_USER_ERROR = "A system error occurred. The error ID for this error is ";
	private static $__instance = NULL;
	private $logger = null;

	private function __construct() {
		# log4php configure should only be called once during application initialization
		Logger::configure($_SERVER["DOCUMENT_ROOT"] . '/models/log4php.xml');
		$this->logger = Logger::getLogger("brandmeaningmatrixLogger");
		$this->logger->info('Configuring log4php...');
	}

	static public function getInstance() {
		if (self::$__instance == NULL) {
			self::$__instance = new AppLogger();
		}
		return self::$__instance;
    }

	public function debug($msg) {
		$this->logger->debug($this->getMessage($msg));
	}

	public function info($msg) {
		$this->logger->info($this->getMessage($msg));
	}

	public function error($msg, $exception = null) {
		$errID = $this->getErrorID();
		$logMsg = $this->getErrorMessage($msg, $errID, $exception);
		$this->logger->error($logMsg);
		return $errID;
	}

	public function jsError($pageURL, $reqData, $msg) {
		$errID = $this->getErrorID();
		$this->logger->error($this->getJSMessage($msg, $pageURL, $reqData, $errID));
		return $errID;
	}

	private function getErrorID() {
		$id = 'ER'.mt_rand();
		return $id;
	}

	private function getMessage($msg, $id=null) {
		$bmm_session_seq = null;

		$backtrace = debug_backtrace();
		$logMsg = $backtrace[1]['file'];
		$logMsg .= ':';
		$logMsg .= $backtrace[1]['line'];
		$logMsg .= ' -';
		if ($id != null) {
			$logMsg .= ' ErrorID('.$id.')';
		}
		if ($bmm_session_seq != null) {
			$logMsg .= 'bmm_session_seq('.$bmm_session_seq.')';
		}
		$logMsg .= ' Message('.$msg.')';
		if (!empty($traceStr)) {
			$logMsg .= "\nCall Trace:\n";
			$logMsg .= $traceStr;
		}
		return $logMsg;
	}

	private function getErrorMessage($msg, $id, $exception=null) {
		$bmm_session_seq = null;

		$backtrace = debug_backtrace();
		$traceStr = '';
		foreach ($backtrace as $i => $call) {
			if (array_key_exists('file', $call)) {
				$traceStr .= $i.') '.$call['file'].'('.$call['line'].'): ';
				if (array_key_exists('class',$call)) {
					$traceStr .= $call['class'].'->';
				}
				$traceStr .= $call['function']."\n";
			}
		}
		$i = 1;
		$logMsg = $backtrace[$i]['file'];
		$logMsg .= ':';
		$logMsg .= $backtrace[$i]['line'];
		$logMsg .= ' -';
		if ($id != null) {
			$logMsg .= ' ErrorID('.$id.')';
		}
		if ($bmm_session_seq != null) {
			$logMsg .= 'bmm_session_seq('.$bmm_session_seq.')';
		}
		$logMsg .= ' Message('.$msg.')';
		if ($exception != null) {
			$logMsg .= "\nException: ";
			$logMsg .= $exception;
		}
		if (!empty($traceStr)) {
			$logMsg .= "\nCall trace:\n";
			$logMsg .= $traceStr;
		}
		return $logMsg;
	}

	private function getJSMessage($msg, $pageURL, $reqData, $errID) {
		$bmm_session_seq = null;
		if(array_key_exists('bmm_session_seq', $reqData)) {
			$bmm_session_seq = $reqData['bmm_session_seq'];
		}

		$backtrace = debug_backtrace();
		$i = 1;
		$logMsg = 'JAVASCRIPT ERROR:';
		$logMsg .= ' ErrorID('.$errID.')';
		$logMsg .= ' pageURL('.$pageURL.')';
		if ($bmm_session_seq != null) {
			$logMsg .= 'bmm_session_seq('.$bmm_session_seq.')';
		}
		$logMsg .= ' Message('.$msg.')';
		if ($reqData != null) {
			$logMsg .= "\nInput:\n";
			$logMsg .= print_r($reqData, true);			
		}
		return $logMsg;
	}
}

?>