<?php
namespace brandmeaningmatrix\model;
// error_reporting(E_ALL);
// ini_set('display_errors', 1);

require_once($_SERVER["DOCUMENT_ROOT"].'/models/DataAccess.php');
use \brandmeaningmatrix\model\DataAccess;
require_once($_SERVER["DOCUMENT_ROOT"].'/models/InputFilterUtil.php');
use \brandmeaningmatrix\model\InputFilterUtil;
require_once($_SERVER["DOCUMENT_ROOT"].'/models/model/All_Brands.php');
use \brandmeaningmatrix\model\All_Brands;

class All_BrandsDataAccess extends DataAccess {

	public function __construct(){
	}

	public function getMentor() {
		//filter to clean
		$filterUtil = new InputFilterUtil();
		$params = array();
		//sql
		$sql = 'select * ';
		$sql .= 'from all_brands ';
		$sql .= 'where is_mentor = :is_mentor ';
		
		//params
		$params['is_mentor'] = 1;
		//excute the statement
		$pdo = $this->getPDO();
		$stmt = $pdo->prepare($sql);
		$stmt->execute($params);
		
		$rows = $stmt->fetchALL(\PDO::FETCH_CLASS);
		$all_brands = $this->mapResponseRows(new All_Brands(), $rows);

		return $all_brands;
	}

	public function getImage() {
		//filter to clean
		$filterUtil = new InputFilterUtil();
		$params = array();
		//sql
		$sql = 'select * ';
		$sql .= 'from all_brands ';
		$sql .= 'where is_image = :is_image ';
		
		//params
		$params['is_image'] = 1;
		//excute the statement
		$pdo = $this->getPDO();
		$stmt = $pdo->prepare($sql);
		$stmt->execute($params);
		
		$rows = $stmt->fetchALL(\PDO::FETCH_CLASS);
		$all_brands = $this->mapResponseRows(new All_Brands(), $rows);

		return $all_brands;
	}

	public function getFunctional() {
		//filter to clean
		$filterUtil = new InputFilterUtil();
		$params = array();
		//sql
		$sql = 'select * ';
		$sql .= 'from all_brands ';
		$sql .= 'where is_functional = :is_functional ';
		
		//params
		$params['is_functional'] = 1;
		//excute the statement
		$pdo = $this->getPDO();
		$stmt = $pdo->prepare($sql);
		$stmt->execute($params);
		
		$rows = $stmt->fetchALL(\PDO::FETCH_CLASS);
		$all_brands = $this->mapResponseRows(new All_Brands(), $rows);

		return $all_brands;
	}

	public function getExperience() {
		//filter to clean
		$filterUtil = new InputFilterUtil();
		$params = array();
		//sql
		$sql = 'select * ';
		$sql .= 'from all_brands ';
		$sql .= 'where is_experience = :is_experience ';
		
		//params
		$params['is_experience'] = 1;
		//excute the statement
		$pdo = $this->getPDO();
		$stmt = $pdo->prepare($sql);
		$stmt->execute($params);
		
		$rows = $stmt->fetchALL(\PDO::FETCH_CLASS);
		$all_brands = $this->mapResponseRows(new All_Brands(), $rows);

		return $all_brands;
	}

	public function getPolarCharts() {
		//filter to clean
		$filterUtil = new InputFilterUtil();
		$params = array();
		//sql
		$sql = 'select * ';
		$sql .= 'from all_brands ';
		$sql .= 'where is_brading_analysis = :is_brading_analysis ';
		
		//params
		$params['is_brading_analysis'] = 1;
		//excute the statement
		$pdo = $this->getPDO();
		$stmt = $pdo->prepare($sql);
		$stmt->execute($params);
		
		$rows = $stmt->fetchALL(\PDO::FETCH_CLASS);
		$all_brands = $this->mapResponseRows(new All_Brands(), $rows);

		return $all_brands;
	}

}

?>