<?php
namespace brandmeaningmatrix\model;
require_once($_SERVER["DOCUMENT_ROOT"].'/models/DataAccess.php');
use \brandmeaningmatrix\model\DataAccess;
require_once($_SERVER["DOCUMENT_ROOT"].'/models/InputFilterUtil.php');
use \brandmeaningmatrix\model\InputFilterUtil;
require_once($_SERVER["DOCUMENT_ROOT"].'/models/Util.php');
use \brandmeaningmatrix\model\Util;
require_once($_SERVER["DOCUMENT_ROOT"].'/models/model/Bmm_User_Sessions.php');
use \brandmeaningmatrix\model\Bmm_User_Sessions;
use stdClass;

class AdminUserDataAccess extends DataAccess {

	const DOUG_USER = 'dougjeske@meyocks.com';
	const DOUG_PASSWORD = 'sdfoiTPQ$werQ';
	const JOSH_USER = 'joshfleming@meyocks.com';
	const JOSH_PASSWORD = 'qdefoiTPQ%wezQ';
	const JUSTIN_USER = 'justincateron@meyocks.com';
	const JUSTIN_PASSWORD = 'fjsdf23lla#00QQ';
	const KENDRA_USER = 'kendrakelly@meyocks.com';
	const KENDRA_PASSWORD = '98$%aqzrts8EWQ';

	public $users_array = array();

	public function __construct() {
		$user_a = new stdClass();
		$user_a->email = self::DOUG_USER;
		$user_a->username = 'doug';
		$user_a->password = self::DOUG_PASSWORD;
		array_push($this->users_array, $user_a);
		$user_b = new stdClass();
		$user_b->email = self::JOSH_USER;
		$user_b->username = 'josh';
		$user_b->password = self::JOSH_PASSWORD;
		array_push($this->users_array, $user_b);
		$user_c = new stdClass();
		$user_c->email = self::JUSTIN_USER;
		$user_c->username = 'justin';
		$user_c->password = self::JUSTIN_PASSWORD;
		array_push($this->users_array, $user_c);
		$user_d = new stdClass();
		$user_d->email = self::KENDRA_USER;
		$user_d->username = 'kendra';
		$user_d->password = self::KENDRA_PASSWORD;
		array_push($this->users_array, $user_d);

	}

	//logs admin in
	public function login($data) {
		//filter to clean
		$filterUtil = new InputFilterUtil();
		$user = false;
		$check_email = $filterUtil->sanitizeEmail($data['email']);
		$check_password = $filterUtil->sanitizeString($data['password']);
		$can_log_in = false;
		$set_username = '';
		$set_key = '';
		foreach($this->users_array as $a_valid_user) {
			if($check_email == $a_valid_user->email) {
				//check password
				if($check_password == $a_valid_user->password) {
					$can_log_in = true;
					$set_username = $a_valid_user->username;
					$set_key = $a_valid_user->username;
				}
			}
		}

		if($can_log_in === true) {
			$utils = new Util();
			$user = new stdClass();
			$user->username = $set_username;
			$user->key = $utils->randStrGen(10);
		}
 
		return $user;
	}

	public function getAll() {
		//filter to clean
		$filterUtil = new InputFilterUtil();
		$params = array();
		//sql
		$sql = 'select * ';
		$sql .= 'from bmm_user_sessions where ';
		$sql .= 'data_source = :data_source ';
		//params
		$params['data_source'] = 'web tool';
		//excute the statement
		$pdo = $this->getPDO();
		$stmt = $pdo->prepare($sql);
		$stmt->execute($params);
		//rows from db
		$rows = $stmt->fetchALL(\PDO::FETCH_CLASS);
		$users = $this->mapResponseRows(new Bmm_User_Sessions(), $rows);

		if(!empty($users)) {
			return $users;
		} else {
			return array();
		}
	}

	private function createCSV($users) {
		$file_location = '/meyocks-viewz/aszsevifqwmmc/current_btt_stats.csv';
		// open the file "demosaved.csv" for writing
		$file = fopen($_SERVER["DOCUMENT_ROOT"].$file_location, 'w');
		// save the column headers
		fputcsv($file, array('Brand Name', 'Top Attribute Score', 'Score Functional', 'Score Experience', 'Score Image', 'Score Mentor', 'Mentor Subscore Info', 'Mentor Subscore Advo', 'Mentor Subscore Insp', 'Primary Type', 'Email Address', 'Completed', 'Date Started'));

		$btt_users_array = array();
		foreach($users as $users_row) {
			//$temp_array = array('Brand Name', 'Top Attribute Score', 'Score Functional', 'Score Experience', 'Score Image', 'Score Mentor', 'Mentor Subscore Info', 'Mentor Subscore Advo', 'Mentor Subscore Insp', 'Primary Type', 'Email Address', 'Completed', 'Date Started');
			$temp_array = array($users_row->brand_name, $users_row->top_attribute_code, $users_row->score_functional, $users_row->score_experience, $users_row->score_image, $users_row->score_mentor, $users_row->mentor_subscore_info, $users_row->mentor_subscore_advo, $users_row->mentor_subscore_insp, $users_row->primary_type, $users_row->email_address, $users_row->completed, $users_row->rec_update_ts);
			array_push($btt_users_array, $temp_array);
		}

		// save each row of the data
		foreach ($btt_users_array as $row) {
			fputcsv($file, $row);
		}
		
		// Close the file
		fclose($file);

		return '/meyocks-viewz/aszsevifqwmmc/current_btt_stats.csv';
	}

	public function downloadCSV($data) {
		//filter to clean
		$filterUtil = new InputFilterUtil();
		$params = array();
		//sql
		$sql = 'select * ';
		$sql .= 'from bmm_user_sessions where ';
		$sql .= 'data_source = :data_source and ';
		$sql .= 'rec_update_ts >= :any_time_stamp ';
		//params
		$params['data_source'] = 'web tool';
		$params['any_time_stamp'] = $filterUtil->sanitizeString($data['min_date'] . ' 00:00:00');
		//excute the statement
		$pdo = $this->getPDO();
		$stmt = $pdo->prepare($sql);
		$stmt->execute($params);
		//rows from db
		$rows = $stmt->fetchALL(\PDO::FETCH_CLASS);
		$users = $this->mapResponseRows(new Bmm_User_Sessions(), $rows);

		if(!empty($users)) {
			return $this->createCSV($users);
		} else {
			return array();
		}
	}

	public function removeFile($filename) {
		unlink($_SERVER["DOCUMENT_ROOT"].$filename);
	}

	
	
}

?>