<?php
	ini_set('display_errors',1);
	require_once($_SERVER["DOCUMENT_ROOT"].'/models/JsonUtil.php');
	use \brandmeaningmatrix\model\JsonUtil;
	require_once($_SERVER["DOCUMENT_ROOT"].'/models/SignonSessionHandler.php');
	use \brandmeaningmatrix\model\SignonSessionHandler;

	$jsonUtil = new brandmeaningmatrix\model\JsonUtil();
	$sessionHdlr = new brandmeaningmatrix\model\SignonSessionHandler();
	$data = (isset($_POST['action'])) ? $_POST : $_GET;
	if(empty($data['action']) || empty($data['svc'])) {
		echo "invalid service specified.";
		exit();
	}
	// defining safe list of all service that do not require authentication or membership
	// Note: You can either specify the service and method, or just the service.
	//       But not both. Specifying the service name will allow all operations
	//       in that service to bypass authentication.
	$safeList = array(
		'authenticateservice'
	);
	if (!in_array($data['action'], $safeList)) {
		$session = $sessionHdlr->getSession(false);
		if (!$session->signedOn) {
			$jsonUtil->writeJsonFail('invalidSignonSession');
			exit();
		}
	}
	// getting the class name and method from the URI
	$getClass = preg_replace('/[^a-zA-Z0-9_-]/','',$data['action']);
	$getMethod = preg_replace('/[^a-zA-Z0-9_-]/','',$data['svc']);
	$svc = preg_replace('/[^a-zA-Z0-9_-]/','',$data['action']);
	$methodName = $getMethod;

	$classFileName = $_SERVER["DOCUMENT_ROOT"].'/meyocks-viewz/svc/'.$svc.'.php';
	if (file_exists($classFileName)) {
		require_once($classFileName);
	} else {
		$msg = "File ".$classFileName." not found.";
		$jsonUtil->writeJsonFail($msg);
		exit();
	}
	$className = ucfirst($svc);
	$className = "\\brandmeaningmatrix\\svc\\".$className;
	try {
		$svcClass = new ReflectionClass($className);
		$method = new ReflectionMethod($className, $methodName);
	} catch (ReflectionException $e) {
		$msg = $e->getMessage();
		$jsonUtil->writeJsonFail($msg);
		exit();
	}

	// post and invoke the mehtod with those args
	$svcObj = $svcClass->newInstance();
	
	$method->invoke($svcObj, $data);

	exit();
	
?>