<?php
namespace brandmeaningmatrix\svc;
/***********************************************************************************
 * Restful service for all things session related.
 ***********************************************************************************/
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once($_SERVER["DOCUMENT_ROOT"].'/models/JsonUtil.php');
use \brandmeaningmatrix\model\JsonUtil;
require_once($_SERVER["DOCUMENT_ROOT"].'/models/AdminUserDataAccess.php');
use \brandmeaningmatrix\model\AdminUserDataAccess;
require_once($_SERVER["DOCUMENT_ROOT"].'/models/SignonSessionHandler.php');
use \brandmeaningmatrix\model\SignonSessionHandler;
use stdClass;

class AuthenticateService {

	public function __construct() {
	}

	public function authenticateUser($data) {
		$res = new stdClass();
		$jsonUtil = new JsonUtil();
		$sessionHdlr = new SignonSessionHandler();
		$session = $sessionHdlr->getSession(false);
		$authenticated = false;
		if($session->signedOn === true) {
			$authenticated = true;
		}
		$res->results = $authenticated;
		$jsonUtil->writeJsonSuccess($res);
	}

	public function login($data) {
		$res = new stdClass();
		$jsonUtil = new JsonUtil();
		//make sure the recaptcha isset
		if(!isset($data['myRecaptchaResponse'])) {
			$res->login = false;
			$jsonUtil->writeJsonSuccess($res);
			die();
		}
		//lets check with google
		$captcha = $data['myRecaptchaResponse'];
		$response = json_decode(file_get_contents("https://www.google.com/recaptcha/api/siteverify?secret=6LfhDhEUAAAAAJ3V9ZDJ2d9bTjWhQmjzlrN4SMId&response=".$captcha."&remoteip=".$_SERVER['REMOTE_ADDR']), true);
        if($response['success'] == false) {
        	$res->login = false;
			$jsonUtil->writeJsonSuccess($res);
			die();
        }
        //now lets check the password and user
		$adminUserDA = new AdminUserDataAccess();
		$user = $adminUserDA->login($data);
		if($user === false) {
			$res->login = false;
			$jsonUtil->writeJsonSuccess($res);
			die();
		}
		//user validated lets create a session
		$sessionHdlr = new SignonSessionHandler();
		$session = $sessionHdlr->getSession(false);
		$session->signedOn = true;
		$session->username = $user->username;
		$session->key = $user->key;
		$sessionHdlr->saveSession($session);
        $res->login = true;
        $res->page = '/meyocks-viewz/#/dashboard';
		$jsonUtil->writeJsonSuccess($res);
	}

	public function signout($data) {
		$jsonUtil = new JsonUtil();
		$response = new stdClass();
		$sessionHdlr = new SignonSessionHandler();
		$sessionHdlr->signOut();
		$response->results = true;
		$response->url = '/meyocks-viewz/';
		$jsonUtil->writeJsonSuccess($response);
	}

}