(function() {
	var LoginController = function($scope, $log, $window, $rootScope, usersFactory) {
		
		function init() {
			$scope.user = {};
			$scope.user.email = '';
			$scope.user.password = '';
			$rootScope.$broadcast('updateLoadingRow', false);
		}
		
		init();

		$scope.submitLoginData = function(isValid) {
			if(isValid) {
				$rootScope.$broadcast('updateLoadingRow', true);
				usersFactory.logUserIn($scope.user).success(function(res_user) {
					if(res_user.login === false) {
						$rootScope.$broadcast('updateLoadingRow', false);
						var error_obj = {};
						error_obj.type = 'error';
						error_obj.message = 'Wrong username or password!';
						error_obj.data = $scope.user;
						error_obj.service = 'login service';
						$rootScope.$broadcast('updateAlertMessage', error_obj);
						$scope.user = {};
					} else {
						$window.location = res_user.page;
					}
				}).error(function(data, status, headers, config) {
					$rootScope.$broadcast('updateLoadingRow', false);
					$log.log(data.error + ' ' + status);
					var error_obj = {};
					error_obj.type = 'error';
					error_obj.message = 'Wrong username or password!';
					error_obj.data = $scope.user;
					error_obj.service = 'login service';
					$rootScope.$broadcast('updateAlertMessage', error_obj);
				});
			}
		};

	};
	//the line 12 is used when minifying code
	LoginController.$inject = ['$scope', '$log', '$window', '$rootScope', 'usersFactory'];

	angular.module('brandTypologyApp').controller('LoginController', LoginController);
}());