(function() {
    var DashBoardController = function($scope, $log, $window, $filter, $rootScope, usersFactory, uiGridConstants, adminFactory, $timeout) {

        function init() {
            $scope.show_captcha = false;
            $scope.user = {};
            $scope.myData = [];
            $scope.myDate = '';
            $scope.todaysDate = new Date();
            $scope.gridOptions = {
                enableSorting: true,
                columnDefs: [],
                data: []
            };
            adminFactory.get().success(function(res) {
                $rootScope.$broadcast('updateLoadingRow', false);
                if (res.success === false) {
                    $window.location = '/meyocks-viewz/#/';
                } else {
                    filterData(res.results);
                }
            }).error(function(data, status, headers, config) {
                $rootScope.$broadcast('updateLoadingRow', false);
                $log.log(data.error + ' ' + status);
                var error_obj = {};
                error_obj.type = 'error';
                error_obj.message = 'Error getting all users!';
                error_obj.data = $scope.user;
                error_obj.service = 'login service';
                $rootScope.$broadcast('updateAlertMessage', error_obj);
            });


        }

        init();

        $scope.checkDate = function(the_selected_date) {
            var new_date = $filter('date')(the_selected_date, "yyyy-MM-dd");
            // console.log(new_date);
            adminFactory.downloadCSV(new_date).success(function(res) {
                $rootScope.$broadcast('updateLoadingRow', false);
                if (angular.isUndefined(res.results)) {
                    $log.log(data.error + ' ' + status);
                    var error_obj = {};
                    error_obj.type = 'error';
                    error_obj.message = 'Error getting CSV!';
                    error_obj.data = $scope.user;
                    error_obj.service = 'admin service';
                    $rootScope.$broadcast('updateAlertMessage', error_obj);
                } else {
                    $window.open(res.results, '_blank');
                    $timeout(function() {
                        $scope.removeFileNow(res.results);
                    }, 5000);
                }
                // console.log(res);
            }).error(function(data, status, headers, config) {
                $rootScope.$broadcast('updateLoadingRow', false);
                $log.log(data.error + ' ' + status);
                var error_obj = {};
                error_obj.type = 'error';
                error_obj.message = 'Error getting CSV!';
                error_obj.data = $scope.user;
                error_obj.service = 'admin service';
                $rootScope.$broadcast('updateAlertMessage', error_obj);
            });
        };

        $scope.removeFileNow = function(filename) {
            adminFactory.removeFileNow(filename).success(function(res) {
                // console.log(res);
            });
        };

        function filterData(array_of_objects) {
            var data_array = [];
            var count_takers = array_of_objects.length;
            if (count_takers > 0) {
                angular.forEach(array_of_objects, function(value, key) {
                    var new_data_obj = {};
                    new_data_obj.brand_name = value.brand_name;
                    var completed = 'no';
                    if (value.completed == 1) {
                        completed = 'yes';
                    }
                    new_data_obj.completed = completed;
                    new_data_obj.email = value.email_address;
                    new_data_obj.primary_type = value.primary_type;
                    var url = 'http://' + window.location.host + '/report/index.php?id=' + value.bmm_session_seq;
                    // console.log(url);
                    new_data_obj.url = url;
                    new_data_obj.anchor_tag = '<a href="' + url + '">Download</a>';
                    data_array.push(new_data_obj);
                });
            }
            $scope.myData = data_array;
            $scope.data = data_array;
            setGridOptions();
        }

        function setGridOptions() {
            $scope.gridOptions = {
                enableSorting: true,
                columnDefs: [
                    { field: 'brand_name', displayName: 'Brand Name', cellTemplate: '<div ng-bind-html="row.entity[col.field]"></div>' },
                    { field: 'completed', displayName: 'Completed' },
                    { field: 'email', displayName: 'Email' },
                    { field: 'primary_type', displayName: 'Primary Type' },
                    { field: 'url', displayName: 'PDF', cellTemplate: '<div>' + '<a ng-click="grid.appScope.downloadPDF(row)">Click me</a>' + '</div>' }
                ],
                data: $scope.myData
            };
        }

        $scope.downloadPDF = function(row_obj) {
            var url = row_obj.entity.url;
            $window.open(url, '_blank');
        };


    };
    //the line 12 is used when minifying code
    DashBoardController.$inject = ['$scope', '$log', '$window', '$filter', '$rootScope', 'usersFactory', 'uiGridConstants', 'adminFactory', '$timeout'];

    angular.module('brandTypologyApp').controller('DashBoardController', DashBoardController);
}());