(function() {
    var app = angular.module('brandTypologyApp', ['ngRoute', 'ui.router', 'ngSanitize', 'ui.grid', 'vcRecaptcha', 'ngMaterial', 'ngMessages']);

    app.config(function($routeProvider, $urlRouterProvider) {

            $routeProvider
                .when('/', {
                    controller: 'LoginController',
                    templateUrl: '/meyocks-viewz/views/login.html'
                })
                .when('/dashboard', {
                    controller: 'DashBoardController',
                    templateUrl: '/meyocks-viewz/views/dashboard.html'
                })
                .when('/find', {
                    //controller: 'FindController',
                    templateUrl: '/meyocks-viewz/views/find.html'
                })
                .when('/viewall', {
                    //controller: 'ViewAllController',
                    templateUrl: '/meyocks-viewz/views/viewquotes.html'
                })
                .otherwise({
                    redirectTo: '/'
                });

        })
        .run(function($rootScope, $location, $http, $window) {
            $rootScope.$on("$routeChangeStart", function(event, next, current) {
                $rootScope.authenticated = false;
                var params = {};
                params.action = 'authenticateservice';
                params.svc = 'authenticateuser';
                $http.get('/meyocks-viewz/svc/index.php', { params: params }).then(function(res) {
                    if (res.data.results === true) {
                        $rootScope.authenticated = true;
                    } else {
                        var nextUrl = next.$$route.originalPath;
                        if (nextUrl !== '/') {
                            $window.location = '/meyocks-viewz/#/';
                        }
                    }
                });
            });
        });

}());