var webservices = {data:{}}; // all webservices
webservices.app = {}; // app contains webservices

(function($){

webservices.getTimestamp = function(str) {
  var d = str.match(/\d+/g); // check date
  return +new Date(d[0], d[1] - 1, d[2], d[3], d[4], d[5]); // make date
};

webservices.SvcHandler = function(){
	var self = this;

	// construct
	this.init = function() {
	};

	this.ajaxGet = function(args) {
		var type = 'GET';
		if (args.type !== null) {
			type = args.type;
		}
		var async = true;
		if (args.async !== null) {
			async = args.async;
		}

		// handle error
		var errorObj = {};
		errorObj.url = args.url;
		errorObj.data = args.data;
		errorObj.error = args.error;

		var jqReq = $.ajax({
			"type": type,
			"dataType": "json",
			"url": args.url,
			"async": async,
			"cache": false,
			"data": args.data,
			"success": function(res) {
				if (!res.success) {
					console.log(args);
					errorObj.msg = res.msg;
					self.logError(errorObj);
				} else {
					if (_.isFunction(args.success)) {
						args.success(res);
					}
				}
			},
			"error": function(jqXHR, textStatus, errorThrown) {
				errorObj.msg = jqXHR.status + " (" + jqXHR.statusText + ")";
				console.log(args);
				self.logError(errorObj);
			}
		});
		return jqReq;
	};

	this.logError = function(errorObj) {
		$.ajax({
			"type": 'POST',
			"dataType": "json",
			"url": "/svc/index.php",
			"async": true,
			"cache": false,
			"data": {
				"action": 'loggingservice',
				"svc": 'logJSError',
				"pageURL": errorObj.url,
				"msg": errorObj.msg,
				"reqData": errorObj.data
			},
			"success": function(res) {
				errorObj.errorID = res.errorID;
				if (errorObj.error != null) {
					errorObj.error(errorObj);
				} else {
					if (window.console && console.dir ){
						console.log('call to ' + errorObj.url + ' failed with the following message.', errorObj.url);
						console.dir("error message", errorObj.msg);
					}
				}
			},
			"error": function(jqXHR, textStatus, errorThrown) {
				if (window.console && console.dir ){
					console.log('call to ' + errorObj.url + ' failed with the following message.', errorObj.url);
					console.dir("error message", errorObj.msg);
				}
			}
		});

	};

	self.init();
};
webservices.app.SvcHandler = new webservices.SvcHandler();

})(jQuery);