reportmatrix.app.UnsubscribePage = function() {
    var self = this;

    //call template to refresh
	this.pageTemplate = function() {
        var settings = {
            template: ".unsubscribe_template",
            target: ".unsubscribe_target"
        };
        reportmatrix.util.template(settings);
        reportmatrix.util.hideloadingrow();
        reportmatrix.activate_unsubscribepage.activateTips();
        reportmatrix.activate_unsubscribepage.unsubscribeBtnClick();
	};

};
reportmatrix.unsubscribepage = new reportmatrix.app.UnsubscribePage();

reportmatrix.app.Activate_UnsubscribePage = function() {
    var self = this;

    this.unsubscribeBtnClick = function() {
        $('.unsubscribe_button').unbind('click').click(function(e) {
            var check_val = $('#email_address').val();
            var email_valid = self.validateEntry(check_val);
            if(email_valid === true) {
                self.serviceCall(check_val);
            } else {
                return false;
            }
        });
    };

    this.serviceCall = function(check_val) {
        reportmatrix.util.showloadingrow();
        var data = {};
        data.email = check_val;
        data.action = 'bmmuser';
        data.svc = 'unsubscribeemail';
        webservices.app.SvcHandler.ajaxGet({
            "url": "/svc/index.php",
            "type": "POST",
            "data": data,
            "success": function(res) {
                reportmatrix.util.hideloadingrow();
                if(res.results.message === 'success') {
                    $('.unsubscribe_init_message').hide();
                    $('.email_unsubscribed_fail').hide();
                    $('.email_unsubscribed').show();
                    $('.alert_message_area').show();
                } else {
                    $('.email_unsubscribed').hide();
                    $('.email_unsubscribed_fail').show();
                    $('.alert_message_area').show();
                }
            },
            "error": function(errorObj) {
                reportmatrix.util.hideloadingrow();
                $('.email_unsubscribed').hide();
                $('.email_unsubscribed_fail').show();
                $('.alert_message_area').show();
                //alertHandler.app.AlertHandler.showErrorAlert('There was an error submitting your quote. Here is a reference ID ' + errorObj.errorID + ' our support has been notified. We will contact your soon.');
                //console.log(errorObj);
            }
        });
    };

    this.validateEmail = function(email) { 
        var re = /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
        return re.test(email);
    };

    this.validateEntry = function() {
        var valid_email = true;
        var email = $('#email_address').val();
        if(email === '') {
            $('#email_address').qtip('show');
            valid_email = false;   
        } 
        else if (!self.validateEmail(email)) {
            $('#email_address').qtip('show');
            valid_email = false;
        }
        return valid_email;
    };

    this.activateTips = function() {
        var data_tips = {};
        data_tips.selector = '#email_address';
        data_tips.text = "Please enter your email address.";
        data_tips.my = 'bottom center';
        data_tips.at = 'top center';
        data_tips.target = '#email_address';
        data_tips.class = 'qtip-orange';
        data_tips.corner = true;
        data_tips.width = 26;
        data_tips.height = 23;
        data_tips.full_width = 280;
        reportmatrix.util.activatetips(data_tips);
    };
    
};
reportmatrix.activate_unsubscribepage = new reportmatrix.app.Activate_UnsubscribePage();

$(document).ready(function() {
	reportmatrix.unsubscribepage.pageTemplate();
});