reportmatrix.app.ThankyouPage = function() {
    var self = this;

    this.validateSurvey = function() {
        var data = {};
        data.action = 'bmmuser';
        data.svc = 'authenticate';
        data.bmm_session_seq = reportmatrix.data.bmm_session_seq;
        webservices.app.SvcHandler.ajaxGet({
            "url": "/svc/index.php",
            "type": "POST",
            "data": data,
            "success": function(res) {
                if(res.exists === false) {
                    window.location.replace("/");
                } else {
                    self.pageTemplate();
                }
            },
            "error": function(errorObj) {
                //alertHandler.app.AlertHandler.showErrorAlert('There was an error submitting your quote. Here is a reference ID ' + errorObj.errorID + ' our support has been notified. We will contact your soon.');
                // console.log(errorObj);
            }
        });
    };

    //call template to refresh
	this.pageTemplate = function() {
        var settings = {
            template: ".thankyou_template",
            target: ".thankyou_target"
        };
        reportmatrix.util.template(settings);
        reportmatrix.util.hideloadingrow();
        reportmatrix.activate_thankyoupage.socialShareClick();
        reportmatrix.activate_thankyoupage.activateFacebookClick();
	};

};
reportmatrix.thankyoupage = new reportmatrix.app.ThankyouPage();

reportmatrix.app.Activate_ThankyouPage = function() {
    var self = this;

    this.socialShareClick = function() {
        $('.social-share-click').unbind('click').click(function(e) {
            e.preventDefault();
            var $e = $(this);
            var social_network = $e.data('social');
            self.getHTMLInfo(social_network);
        });
    };

    this.activateFacebookClick = function() {
        ga('send', 'event', 'share', 'click', 'facebook', 1);
        document.getElementById('facebook_btn').onclick = function() {
            FB.ui({
                method: 'share',
                display: 'popup',
                href: 'http://brandtypologytool.com',
            }, function(response){
                console.log(response);
            });
        };
    };

    //gets the correct html attributes based on social network
    this.getHTMLInfo = function(social_network) {
        var data = {};
        if (social_network === 'twitter') {
            data.title = $('meta[property="twitter:title"]').attr('content');
            data.description = $('meta[property="twitter:description"]').attr('content');
            data.site_url = $('meta[property="twitter:site"]').attr('content');
            data.image = $('meta[property="twitter:image"]').attr('content');
            data.creator = $('meta[property="twitter:creator"]').attr('content');
            self.shareTwitter(data);
        } else if (social_network === 'linkedin') {
            data.title = $('meta[property="og:title"]').attr('content');
            data.description = $('meta[property="og:description"]').attr('content');
            data.site_url = $('meta[property="og:url"]').attr('content');
            data.image = $('meta[property="og:image"]').attr('content');
            self.shareLinkedIn(data);
        }
    };

    //encode the url
    this.encodeURL = function(text) {
        return encodeURI(text);
    };

    //share via twitter
    this.shareTwitter = function(data) {
        ga('send', 'event', 'share', 'click', 'twitter', 1);
        var share_url = 'https://twitter.com/intent/tweet?url='+encodeURIComponent(data.site_url)+'&text='+encodeURIComponent(data.description);
        var twitter = window.open(share_url);
        twitter.focus();
    };

    //share via linkedin
    this.shareLinkedIn = function(data) {
        ga('send', 'event', 'share', 'click', 'linkedin', 1);
        var share_url = 'https://www.linkedin.com/shareArticle?mini=true&url='+encodeURIComponent(data.site_url)+'&title='+encodeURIComponent(data.title)+'&summary='+encodeURIComponent(data.description)+'&source='+encodeURIComponent(data.site_url);
        var linkedIn = window.open(share_url);
        linkedIn.focus();
        // Use the API call wrapper to share content on LinkedIn
        // IN.User.authorize(shareContent, shareContent);
        // function shareContent() {

        //     // Build the JSON payload containing the content to be shared
        //     var payload = { 
        //         "content": {
        //             "title": data.title,
        //             "description": data.description,
        //             "submitted-url": 'http://brandtypologytool.com',
        //             "submitted-image-url": data.image
        //         },
        //         "comment": "Check out developer.linkedin.com! http://linkd.in/1FC2PyG", 
        //         "visibility": { 
        //             "code": "anyone"
        //         } 
        //     };

        //     var postcontent = [];
        //     postcontent = {"comment": data.title, "content": {"title": data.title,"description": data.description,"submitted-url": 'http://brandtypologytool.com',"submitted-image-url": data.image},"visibility": {"code": "anyone"} };
        //     postcontent = JSON.stringify(postcontent);

        //     IN.API.Raw("/people/~/shares?format=json").method("POST").body(postcontent).result(onSuccess).error(onError);
        // }
    };
    
};
reportmatrix.activate_thankyoupage = new reportmatrix.app.Activate_ThankyouPage();

$(document).ready(function() {
    reportmatrix.data.bmm_session_seq = reportmatrix.util.queryParam('survey');
     if(_.isEmpty(reportmatrix.data.bmm_session_seq)) {
       window.location.replace("/");
    }
	reportmatrix.thankyoupage.validateSurvey();
});