reportmatrix.app.SurveyPage = function() {
    var self = this;

    this.validateSurvey = function() {
        var data = {};
        data.action = 'bmmuser';
        data.svc = 'walkthru';
        data.bmm_session_seq = reportmatrix.data.bmm_session_seq;
        webservices.app.SvcHandler.ajaxGet({
            "url": "/svc/index.php",
            "type": "POST",
            "data": data,
            "success": function(res) {
                reportmatrix.data.survey = res;
                if (res.exists === false || res.completed === true) {
                    window.location.replace("/");
                } else {
                    self.pageTemplate();
                }
            },
            "error": function(errorObj) {
                //alertHandler.app.AlertHandler.showErrorAlert('There was an error submitting your quote. Here is a reference ID ' + errorObj.errorID + ' our support has been notified. We will contact your soon.');
                // console.log(errorObj);
            }
        });
    };

    //call template to refresh
    this.pageTemplate = function() {
        var settings = {
            template: ".survey_template",
            target: ".survey_target"
        };
        reportmatrix.util.template(settings);
        reportmatrix.util.hideloadingrow();
        reportmatrix.activate_surveypage.generateQuestionHtml();
        reportmatrix.activate_surveypage.activateDownQtip();
        reportmatrix.activate_surveypage.upButtonClick();
        reportmatrix.activate_surveypage.downButtonClick();
        reportmatrix.activate_surveypage.walkThru();
        //shows the first question
        reportmatrix.activate_surveypage.showFirstQuestion();
        reportmatrix.activate_surveypage.activateRangeSlider();
        reportmatrix.activate_surveypage.windowResizedFooter();
        reportmatrix.activate_surveypage.checkHeight();
        reportmatrix.activate_surveypage.checkBrowser();
        $('#up').addClass('disabled');
        $('#down').addClass('disabled');
    };

};
reportmatrix.surveypage = new reportmatrix.app.SurveyPage();

reportmatrix.app.Activate_SurveyPage = function() {
    var self = this;

    this.checkForMobile = function() {
        var check = false;
        (function(a) { if (/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino|android|ipad|playbook|silk/i.test(a) || /1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(a.substr(0, 4))) check = true; })(navigator.userAgent || navigator.vendor || window.opera);
        return check;
    };

    this.checkBrowser = function() {
        var portrait = '';
        var isMobile = self.checkForMobile();
        if (window.innerHeight > window.innerWidth) {
            portrait = true;
            $('#footer').css({ 'position': 'absolute', 'margin-top': '0' });
        } else {
            portrait = false;
            if (isMobile === true) {
                $('#footer').css({ 'position': 'static', 'margin-top': '60px' });
            }
        }
    };

    this.checkHeight = function() {
        var win_height = $(window).height();
        var isMobile = self.checkForMobile();
        if (isMobile === false) {
            if (win_height <= 600) {
                $('#footer').css({ 'position': 'static', 'margin-top': '90px' });
            }
        } else {
            self.checkBrowser();
        }
    };

    this.windowResizedFooter = function() {
        window.addEventListener("resize", function() {
            self.checkHeight();
        }, false);
    };

    this.walkThru = function() {
        if (reportmatrix.data.survey.already_visited === 'No') {
            $(".veil").fadeIn();
            setTimeout(function() {
                self.activateQtipObjs('#q1 .slider');
                $('#q1 .slider').qtip('show');
            }, 2000);
            setTimeout(function() {
                $('#q1 .slider').qtip('hide');
            }, 6000);
            setTimeout(function() {
                $('#down').qtip('show');
            }, 6000);
            setTimeout(function() {
                $('#down').qtip('hide');
                $('.veil').fadeOut();
            }, 10000);
        }
    };

    this.serviceCall = function(data, button_clicked) {
        data.bmm_session_seq = reportmatrix.data.bmm_session_seq;
        webservices.app.SvcHandler.ajaxGet({
            "url": "/svc/index.php",
            "type": "POST",
            "data": data,
            "success": function(res) {
                self.adjustQuestions(button_clicked);
            },
            "error": function(errorObj) {
                //alertHandler.app.AlertHandler.showErrorAlert('There was an error submitting your quote. Here is a reference ID ' + errorObj.errorID + ' our support has been notified. We will contact your soon.');
                //console.log(errorObj);
            }
        });
    };

    self.adjustQuestions = function(button_clicked) {
        var amount_duration = 1200;
        if (button_clicked === 'up') {
            $('.question-wrap').removeClass('current');
            $(reportmatrix.data.previous).addClass('current');
            $(reportmatrix.data.next).velocity({ 'opacity': '0', marginTop: '10%' }, 300);
            setTimeout(function() {
                $(reportmatrix.data.next).css({ 'display': 'none' });
                $(reportmatrix.data.previous).css({ 'display': 'block' });
                $(reportmatrix.data.previous).animate({ 'opacity': 1 }, { duration: amount_duration, queue: false });
                $(reportmatrix.data.previous).animate({ "margin-top": "0%" }, { duration: amount_duration, queue: false });
                $(reportmatrix.data.previous + ' .slider').animate({ 'opacity': 1 }, { duration: amount_duration, queue: false });
                $(reportmatrix.data.previous + ' .slider').animate({ "margin-top": "5%" }, { duration: amount_duration, queue: false });
                reportmatrix.activate_surveypage.updateProgress();
                self.enableQuestionUpDownBtns(amount_duration);
            }, 300);
        } else {
            if (reportmatrix.data.currentQuestion > reportmatrix.data.totalQuestions) {
                window.location.replace('/lastquestion.html?survey=' + reportmatrix.data.bmm_session_seq);
                return false;
            }
            $('.question-wrap').removeClass('current');
            $(reportmatrix.data.next).addClass('current');
            $(reportmatrix.data.previous).velocity({ 'opacity': '0', marginTop: '-10%' }, 300);
            setTimeout(function() {
                $(reportmatrix.data.previous).css({ 'display': 'none' });
                $(reportmatrix.data.next).css({ 'display': 'block' });
                $(reportmatrix.data.next).animate({ 'opacity': 1 }, { duration: amount_duration, queue: false });
                $(reportmatrix.data.next).animate({ "margin-top": "0%" }, { duration: amount_duration, queue: false });
                $(reportmatrix.data.next + ' .slider').animate({ 'opacity': 1 }, { duration: amount_duration, queue: false });
                $(reportmatrix.data.next + ' .slider').animate({ "margin-top": "5%" }, { duration: amount_duration, queue: false });
                reportmatrix.activate_surveypage.updateProgress();
                self.enableQuestionUpDownBtns(amount_duration);
            }, 300);
        }
    };

    this.enableQuestionUpDownBtns = function(amount_duration) {
        setTimeout(function() {
            //enables buttons for up down click after everything has been moved and adjusted
            if ($('#up').hasClass('disabled')) {
                var current_question = $("#q1").hasClass('current');
                if (current_question === false) {
                    $('#up').removeClass('disabled');
                }
            }
            if ($('#q' + reportmatrix.data.totalQuestions).hasClass('current')) {
                $("#down").removeClass('disabled');
            }
            if ($('#down').hasClass('disabled')) {
                $('#down').removeClass('disabled');
            }
        }, amount_duration);
    };

    this.showFirstQuestion = function() {
        $("#q1").addClass('current');
        var current_duration = 1200;
        reportmatrix.data.currentQuestion = 1;
        reportmatrix.data.next = '#q' + (reportmatrix.data.currentQuestion + 1);
        reportmatrix.data.previous = '#q' + (reportmatrix.data.currentQuestion);
        var selector = "#q" + reportmatrix.data.currentQuestion;
        setTimeout(function() {
            $(selector).css({ 'display': 'block' });
            $(selector).animate({ 'opacity': 1 }, { duration: current_duration, queue: false });
            $(selector).animate({ "margin-top": "0%" }, { duration: current_duration, queue: false });
            $(selector + ' .slider').animate({ 'opacity': 1 }, { duration: current_duration, queue: false });
            $(selector + ' .slider').animate({ "margin-top": "5%" }, { duration: current_duration, queue: false });
            self.enableQuestionUpDownBtns(current_duration);
        }, 1000);
    };

    //activate click of up button
    this.upButtonClick = function() {
        $('#up').click(function() {
            //prevent the double click
            var $e = $(this);
            if (!$(this).hasClass('disabled')) {
                $e.addClass('disabled');
                $('#down').addClass('disabled');
                reportmatrix.data.previous = '#q' + (reportmatrix.data.currentQuestion - 1);
                reportmatrix.data.currentQuestion--;
                reportmatrix.data.next = '#q' + (reportmatrix.data.currentQuestion + 1);
                //Record score
                var code = $('.current .attribute').val();
                var score = $('.current input[type="range"]').val();
                var tally_the_data = {};
                tally_the_data.attribute_code = code;
                tally_the_data.attribute_score = score;
                tally_the_data.action = 'bmmuserscores';
                tally_the_data.svc = 'update';
                tally_the_data.bmm_session_seq = reportmatrix.data.bmm_session_seq;
                //submit to service
                self.serviceCall(tally_the_data, 'up');
            }
        });
    };

    //activate click of down button
    this.downButtonClick = function() {
        $('#down').click(function(e) {
            //prevent the double click
            var $e = $(this);
            if (!$(this).hasClass('disabled')) {
                if (!$('.current').hasClass('already-answered')) {
                    self.activateQtipObjs('#q' + reportmatrix.data.currentQuestion + ' .slider');
                    $('#q' + reportmatrix.data.currentQuestion + ' .slider').qtip('show');
                } else {
                    $e.addClass('disabled');
                    $('#up').addClass('disabled');
                    sliderBeenMoved = 0;
                    reportmatrix.data.next = '#q' + (reportmatrix.data.currentQuestion + 1);
                    reportmatrix.data.currentQuestion++;
                    reportmatrix.data.previous = '#q' + (reportmatrix.data.currentQuestion - 1);
                    //Record score in database
                    var code = $('.current .attribute').val();
                    var score = $('.current input[type="range"]').val();
                    var tally_the_data_down = {};
                    tally_the_data_down.attribute_code = code;
                    tally_the_data_down.attribute_score = score;
                    tally_the_data_down.action = 'bmmuserscores';
                    tally_the_data_down.svc = 'update';
                    tally_the_data_down.bmm_session_seq = reportmatrix.data.bmm_session_seq;
                    //submit to service
                    self.serviceCall(tally_the_data_down, 'down');
                }
            } else {
                return false;
            }
        });
    };

    this.updateProgress = function() {
        reportmatrix.data.progressVal = (reportmatrix.data.currentQuestion / reportmatrix.data.totalQuestions) * 100;
        reportmatrix.activate_surveypage.progress(reportmatrix.data.progressVal, $('#progressBar'));
        var sliderTimeout;
        if ($('#q1').hasClass('current') && reportmatrix.data.alreadyBeenHere === 0) {
            sliderTimeout = 0;
        } else {
            sliderTimeout = 2000;
        }
    };

    this.progress = function(percent, $element) {
        var progressBarWidth = percent * $element.width() / 100;
        $element.find('div').velocity({ width: progressBarWidth }, 500).html(percent + "% ");
    };

    //activate the Range Slider
    this.activateRangeSlider = function() {
        $('input[type="range"]').rangeslider({
            polyfill: false,
            // Callback function
            onInit: function() {},
            // Callback function
            onSlide: function(position, value) {
                $('.current').addClass('already-answered');
                $('.current .selecting_value').html('<strong>' + value + '</strong>');
            },
            // Callback function
            onSlideEnd: function(position, value) {}
        });
        // $('input[type="range"]').val(50).change();
    };

    //gets the color scheme
    this.figureColorScheme = function() {
        var count_all_questions = reportmatrix.all_questions.length;
        var random_color_scheme = _.shuffle(reportmatrix.data.color_scheme);
        var color_array = [];
        var counter = 0;
        var second_counter = 0;
        for (i = 0; i < count_all_questions; i++) {
            //starting at 0
            if (i < 3) {
                color_array.push(random_color_scheme[i]);
            } else {
                color_array.push(random_color_scheme[second_counter]);
                if (second_counter === 2) {
                    second_counter = 0;
                } else {
                    second_counter += 1;
                }
            }
        }
        return color_array;
    };

    //first generate all html
    this.generateQuestionHtml = function() {
        var picked_colors = self.figureColorScheme();
        var html = '';
        var count = 1;
        var color_choice_counter = 0;
        //count all questions
        reportmatrix.data.totalQuestions = reportmatrix.all_questions.length;
        var count_all_questions = reportmatrix.all_questions.length;
        //lets save to all_questions
        var all_questions = reportmatrix.all_questions;
        //shuffle the questions
        var suffled_questions = _.shuffle(all_questions);
        //loop through and generate the html
        $.each(suffled_questions, function(index, value) {
            html += '<section id="q' + count + '" class="question-wrap">';
            html += '<div class="container center-text">';
            html += '<div class="row row-centered">';
            html += '<div class="col-sm-8 col-md-6 col-centered">';
            html += '<div class="section-header text-center">';
            html += '<div class="badge ' + picked_colors[color_choice_counter] + '">';

            html += '<div class="icon">';
            var image_url = 'img/new_question_icons/' + value.icon + picked_colors[color_choice_counter] + '.png';
            html += '<img class="img-responsive" src="' + image_url + '" alt="' + value.description + '">';
            color_choice_counter += 1;
            html += '</div>';
            html += '</div>';
            html += '</div><!--end section-header -->';

            html += '<div class="row">';
            html += '<div class="col-xs-12">';
            html += '<div class="question">';
            html += value.html;
            html += '</div><!--end question -->';
            html += '</div>';
            html += '</div>';

            html += '<div class="row">';
            html += '<div class="col-xs-12 text-center selecting_val_col">';
            html += '<span class="selecting_value"><strong>50</strong></span>';
            html += '</div>';
            html += '</div>';

            html += '<div class="row">';
            html += '<div class="col-xs-12">';

            html += '<div class="slider">';
            html += '<a class="thumb thumbs-down"><span class="icon-thumbs-down"></span></a>';
            html += '<a class="thumb thumbs-up"><span class="icon-thumbs-up"></span></a>';
            html += '<input type="range" name="q' + count + '-val" id="q' + count + '-val" min="0" max="100" step="1" value="50" data-rangeslider>';
            html += '<label class="range-label left">Disagree</label>';
            html += '<label class="range-label right">Agree</label>';
            html += '</div><!--end slider -->';
            html += '<input type="hidden" class="attribute" value="' + value.attribute + '">';

            html += '</div>';
            html += '</div>';


            html += '</div><!--end col-sm-6 -->';
            html += '</div><!--end row -->';
            html += '</div><!--end container -->';
            html += '</section><!--end Q1-->';
            //increment the count
            count += 1;
        });
        //set all questions html
        $('.all_questions_container').html(html);

    };

    this.activateQtipObjs = function(id_class_selector) {
        $(id_class_selector).qtip({ // Grab some elements to apply the tooltip to
            content: {
                text: 'Please drag the purple dot to indicate<br>how much you agree or disagree with the statement.',
                button: true
            },
            show: {
                effect: function(offset) {
                    $(this).fadeIn(); // "this" refers to the tooltip
                },
                event: ''
            },
            hide: {
                effect: function(offset) {
                    $(this).fadeOut(); // "this" refers to the tooltip
                }
            },
            position: {
                my: 'bottom center',
                at: 'top center',
                target: $(id_class_selector)
            },
            style: {
                classes: 'qtip-orange',
                tip: {
                    corner: true,
                    width: 26,
                    height: 23
                },
                width: 300
            }
        });
    };

    this.activateDownQtip = function() {
        $('#down').qtip({ // Grab some elements to apply the tooltip to
            content: {
                text: 'Click the down arrow to advance to the next question.',
                button: true
            },
            show: {
                effect: function(offset) {
                    $(this).fadeIn(); // "this" refers to the tooltip
                },
                event: ''
            },
            hide: {
                effect: function(offset) {
                    $(this).fadeOut(); // "this" refers to the tooltip
                }
            },
            position: {
                my: 'bottom center',
                at: 'top center',
                target: $('#down')
            },
            style: {
                classes: 'qtip-orange',
                tip: {
                    corner: true,
                    width: 26,
                    height: 23
                },
                width: 280
            }
        });
    };
};
reportmatrix.activate_surveypage = new reportmatrix.app.Activate_SurveyPage();

$(document).ready(function() {
    reportmatrix.data.bmm_session_seq = reportmatrix.util.queryParam('survey');
    if (_.isEmpty(reportmatrix.data.bmm_session_seq)) {
        window.location.replace("/");
    }
    reportmatrix.data.color_scheme = ['green', 'blue', 'orange'];
    reportmatrix.data.begin = 0;
    reportmatrix.data.alreadyBeenHere = 0;
    reportmatrix.data.currentQuestion = 1;
    reportmatrix.data.totalQuestions = 0;
    reportmatrix.data.cq = '#q' + reportmatrix.data.currentQuestion;
    reportmatrix.data.thumbsup = '';
    reportmatrix.data.thumbsdown = '';
    reportmatrix.data.next = '';
    reportmatrix.data.previous = '';
    reportmatrix.data.progressVal = '';
    reportmatrix.surveypage.validateSurvey();
});