//sharpspring vars
var __ss_noform = __ss_noform || [];

reportmatrix.app.ResultsPage = function() {
    var self = this;

    this.getCustomReport = function() {
        var data = {};
        data.action = 'bmmresults';
        data.svc = 'generateresults';
        data.bmm_session_seq = reportmatrix.data.bmm_session_seq;
        webservices.app.SvcHandler.ajaxGet({
            "url": "/svc/index.php",
            "type": "POST",
            "data": data,
            "success": function(res) {
                reportmatrix.data.scores = res.results;
                if (res.exists === false || res.completed === true) {
                    window.location.replace("/");
                } else {
                    reportmatrix.activate_resultspage.setPrimaryColor();
                    self.pageTemplate();
                }
            },
            "error": function(errorObj) {
                //alertHandler.app.AlertHandler.showErrorAlert('');
                //console.log(errorObj);
            }
        });
    };

    //call template to refresh
    this.pageTemplate = function() {
        var settings = {
            template: ".results_template",
            target: ".results_target"
        };
        reportmatrix.util.template(settings);
        //active the get full report button click
        // reportmatrix.activate_resultspage.getItClick();

        //set color of icheckbox
        reportmatrix.activate_resultspage.icheckCheckBoxColor();
        //icheck unchecked
        reportmatrix.activate_resultspage.icheckUncheckedReport();
        //icheck checked 
        reportmatrix.activate_resultspage.icheckCheckedReport();
        //icheck input
        reportmatrix.activate_resultspage.icheckInput();
        //active qtip
        reportmatrix.activate_resultspage.activateSendReportQtip();
        //build the chart
        reportmatrix.activate_resultspage.buildTheChart();
        //set primary span
        reportmatrix.activate_resultspage.placeChartTitles();
        //build the other 2 charts
        reportmatrix.activate_resultspage.buildPolarChart();
        reportmatrix.activate_resultspage.buildRadarChartCompare();
        //contact submit
        reportmatrix.activate_resultspage.contactSubmit();
        //popovers
        reportmatrix.activate_resultspage.mentorPopOver();
        reportmatrix.activate_resultspage.imagePopOver();
        reportmatrix.activate_resultspage.experiencePopOver();
        reportmatrix.activate_resultspage.functionalPopOver();
        //if browser resized refresh the text around the canvas
        reportmatrix.activate_resultspage.browserResized();
        reportmatrix.activate_resultspage.setPrimarySpan();
        reportmatrix.activate_resultspage.setPrimarySentence();
        reportmatrix.activate_resultspage.setMatrixTitleOrder();
        reportmatrix.activate_resultspage.removePulse();
        reportmatrix.activate_resultspage.hidepopOver();
        reportmatrix.activate_resultspage.closePopOverX();

        //set the
        setTimeout(function() {
            reportmatrix.util.hideloadingrow();
        }, 2000);
        window.addEventListener("orientationchange", function() {
            // Announce the new orientation number
            reportmatrix.resultspage.pageTemplate();
        }, false);
        $.getScript('https://koi-3QN90P50HI.marketingautomation.services/client/noform.js?ver=1.24', function(data, textStatus, jqxhr) {
            //console.log(data); // Data returned
            //console.log(textStatus); // Success
            //console.log(jqxhr.status); // 200
            //console.log("Load was performed.");
            __ss_noform.push(['baseURI', 'https://app-3QN90P50HI.marketingautomation.services/webforms/receivePostback/MzawMDG1MDQwBAA/']);
            __ss_noform.push(['form', 'report-request', '2308ea44-d5c2-4139-a928-1285cc3d06cf']);
            __ss_noform.push(['submitType', 'manual']);
        });

    };

};
reportmatrix.resultspage = new reportmatrix.app.ResultsPage();

reportmatrix.app.Activate_ResultsPage = function() {
    var self = this;

    this.setPrimaryColor = function() {
        if (reportmatrix.data.scores.primary_type === 'Experience') {
            reportmatrix.data.scores.primary_type_color = 'orange';
        }
    };

    this.hidepopOver = function() {
        $(document).on('click', function(e) {
            $('[data-toggle="popover"],[data-original-title]').each(function() {
                //the 'is' for buttons that trigger popups
                //the 'has' for icons within a button that triggers a popup
                if (!$(this).is(e.target) && $(this).has(e.target).length === 0 && $('.popover').has(e.target).length === 0) {
                    (($(this).popover('hide').data('bs.popover') || {}).inState || {}).click = false; // fix for BS 3.3.6
                }

            });
        });
    };

    this.removePulse = function() {
        $(document).on('click', '.pulsate', function() {
            $(this).removeClass('pulsate');
        });
    };

    this.setPrimarySpan = function() {
        $('.primary_selection_here').html(reportmatrix.data.scores.primary_html);
    };

    this.setPrimarySentence = function() {
        var sentence = '';
        if (reportmatrix.data.scores.primary_type === 'Functional') {
            sentence = 'The primary benefit of your brand is its ability to offer your customer superior performance, greater efficiency or better economy.';
        }
        if (reportmatrix.data.scores.primary_type === 'Experience') {
            sentence = 'The primary benefit of your brand is its ability to deliver a unique and engaging experience for your customer.';
        }
        if (reportmatrix.data.scores.primary_type === 'Image') {
            sentence = 'The primary benefit of your brand is its ability to convey a desirable impression of your customer to other people.';
        }
        if (reportmatrix.data.scores.primary_type === 'Mentor') {
            sentence = 'The primary benefit of your brand is its ability to provide value-added information, inspiration or customer advocacy.';
        }
        $('.primary_sentence_here').html(sentence);
    };

    this.browserResized = function() {
        $(window).resize(function() {
            //resize just happened, pixels changed
            self.placeChartTitles();
        });
    };

    this.setMatrixTitleOrder = function() {
        var array_of_scores = [];
        var array_of_matching_names = ['experience_popover', 'functional_popover', 'image_popover', 'mentor_popover'];
        var array_score_types = ['score_experience', 'score_functional', 'score_image', 'score_mentor'];
        $.each(array_score_types, function(index, value) {
            var obj = {};
            obj.match_type = array_of_matching_names[index];
            obj.type = value;
            obj.score = reportmatrix.data.scores[value];
            array_of_scores.push(obj);
        });
        //lets find the winner incase of a tie
        var the_winner_array = self.findTheWinner(array_of_scores);
        var counter = 1;
        $.each(the_winner_array, function(index, value) {
            var match_type_selector = value.match_type;
            var selector = '.' + match_type_selector;
            if (counter === 1) {
                $(selector).addClass('first').addClass('pulsate');
            } else if (counter === 2) {
                $(selector).addClass('second');
            } else if (counter === 3) {
                $(selector).addClass('third');
            } else if (counter === 4) {
                $(selector).addClass('fourth');
            }
            //add to counter
            counter += 1;
        });
    };

    this.findTheWinner = function(ordered_list) {
        var winner_primiary_type = reportmatrix.data.scores.primary_type;
        var the_winner = '';
        var index_the_winner = '';
        var winner_match_type = '';
        var removed_from_array = '';
        var starting_array = [];
        $.each(ordered_list, function(index, value) {
            if (winner_primiary_type === 'Experience' && value.match_type === 'experience_popover') {
                the_winner = value;
                index_the_winner = index;
                winner_match_type = value.match_type;
            } else if (winner_primiary_type === 'Functional' && value.match_type === 'functional_popover') {
                the_winner = value;
                index_the_winner = index;
                winner_match_type = value.match_type;
            } else if (winner_primiary_type === 'Image' && value.match_type === 'image_popover') {
                the_winner = value;
                index_the_winner = index;
                winner_match_type = value.match_type;
            } else if (winner_primiary_type === 'Mentor' && value.match_type === 'mentor_popover') {
                the_winner = value;
                index_the_winner = index;
                winner_match_type = value.match_type;
            }
            starting_array.push(value);
        });
        //remove the winner from the array
        var filtered = _(ordered_list).filter(function(item) {
            return item.match_type !== winner_match_type;
        });
        //order the filtered array by the score
        var sorted_filtered = _.sortBy(filtered, function(each_score) {
            return parseInt(each_score.score);
        });
        //reverse the array because its decending
        var ordered_sorted_filtered = sorted_filtered.reverse();
        //create the final array
        var final_array = [the_winner, ordered_sorted_filtered[0], ordered_sorted_filtered[1], ordered_sorted_filtered[2]];

        return final_array;
    };

    this.closePopOverX = function() {
        $(document).on('click', '.close', function(e) {
            e.preventDefault();
            $('.popover').popover('hide');
        });
    };

    this.functionalPopOver = function() {
        var html = '';
        html += '<div id="functional">';
        html += '<div class="close" data-closepopover="#functional"></div>';
        html += '<div class="pop-over-icon">';
        html += '<img class="img-responsive" src="/img/icon-functional.png" alt="Functional Brands">';
        html += '</div>';
        html += '<div class="pop-over-copy">';
        html += '<p>A <strong>functional brand</strong> is differentiated  primarily by helping customers do something better, perform more efficiently or be more economical in their daily lives.</p>';
        html += '<p class="margin-bottom-0">Examples of functional brands include Gillette<sup>&reg;</sup> razors and GEICO<sup>&reg;</sup> insurance.</p>';
        html += '</div>';
        html += '</div>';
        $('.functional_popover').popover({
            trigger: 'click hover',
            container: 'body',
            viewport: 'body',
            template: '<div class="popover" role="tooltip"><div class="arrow functional_arrow"></div><h3 class="popover-title"></h3><div class="popover-content"></div></div>',
            html: true,
            content: function() {
                return html;
            },
            placement: 'bottom'
        });
    };

    this.experiencePopOver = function() {
        var html = '';
        html += '<div id="experience">';
        html += '<div class="close" data-closepopover="#experience"></div>';
        html += '<div class="pop-over-icon">';
        html += '<img class="img-responsive" src="/img/icon-experience.png" alt="Experience Brands">';
        html += '</div>';
        html += '<div class="pop-over-copy">';
        html += '<p>An <strong>experience brand</strong> is differentiated primarily by offering its customers a unique or engaging experience.</p>';
        html += '<p class="margin-bottom-0">Examples of experience brands include American Girl<sup>&reg;</sup> stores and Starbucks<sup>&reg;</sup> coffee shops.</p>';
        html += '</div>';
        html += '</div>';

        $('.experience_popover').popover({
            trigger: 'click hover',
            container: 'body',
            viewport: 'body',
            template: '<div class="popover" role="tooltip"><div class="arrow experience_arrow"></div><h3 class="popover-title"></h3><div class="popover-content"></div></div>',
            html: true,
            content: function() {
                return html;
            },
            placement: 'top'
        });
    };

    this.mentorPopOver = function() {
        var html = '';
        html += '';
        html += '';
        html += '<div id="mentor">';
        html += '<div class="close" data-closepopover="#mentor"></div>';
        html += '<div class="pop-over-icon">';
        html += '<img class="img-responsive" src="/img/icon-mentor.png" alt="Mentor Brands">';
        html += '</div>';
        html += '<div class="pop-over-copy">';
        html += '<p>A <strong>mentor brand</strong> is differentiated primarily based on the value-added information, ongoing inspiration or customer advocacy it provides.</p>';
        html += '<p class="margin-bottom-0">Examples of mentor brands include Nike<sup>&reg;</sup> athletic apparel and Home Depot<sup>&reg;</sup> stores.</p>';
        html += '</div>';
        html += '</div>';
        html += '';
        html += '';
        $('.mentor_popover').popover({
            trigger: 'click hover',
            container: 'body',
            viewport: 'body',
            template: '<div class="popover" role="tooltip"><div class="arrow mentor_arrow"></div><h3 class="popover-title"></h3><div class="popover-content"></div></div>',
            html: true,
            content: function() {
                return html;
            },
            placement: 'top'
        });
    };

    this.imagePopOver = function() {
        var html = '';
        html += '';
        html += '';
        html += '<div id="image">';
        html += '<div class="close" data-closepopover="#image"></div>';
        html += '<div class="pop-over-icon">';
        html += '<img class="img-responsive" src="/img/icon-image.png" alt="Image Brands">';
        html += '</div>';
        html += '<div class="pop-over-copy">';
        html += '<p>An <strong>image brand</strong> is differentiated primarily based on the statement it makes about the customer to other people.</p>';
        html += '<p class="margin-bottom-0">Examples of image brands include Tiffany<sup>&reg;</sup> jewlery and Harley-Davidson<sup>&reg;</sup> motorcycles.</p>';
        html += '</div>';
        html += '</div>';
        html += '';
        html += '';
        $('.image_popover').popover({
            trigger: 'click hover',
            container: 'body',
            viewport: 'body',
            template: '<div class="popover" role="tooltip"><div class="arrow image_arrow"></div><h3 class="popover-title"></h3><div class="popover-content"></div></div>',
            html: true,
            content: function() {
                return html;
            },
            placement: 'bottom auto'
        });
    };

    this.placeChartTitles = function() {
        // so it supports position: relative parent elements
        var pos = $('#matrix').position();
        // .outerWidth() takes into account border and padding.
        var width = $('#matrix').outerWidth();
        //get height
        var height = $('#matrix').height();
        var document_width = $(document).width();
        var top_it = '';
        var bottom_it = '';
        var left_it = '';
        var right_it = '';
        if (document_width > 1199) {
            left_it = width * 0.20;
            right_id = width * 0.168;
            top_it = height * 0.47;
            bottom_it = height * 0.475;
        } else if (document_width > 991) {
            left_it = width * 0.20;
            right_id = width * 0.15;
            top_it = height * 0.47;
            bottom_it = height * 0.47;
        } else if (document_width > 767) {
            left_it = width * 0.18;
            right_id = width * 0.12;
            top_it = height * 0.455;
            bottom_it = height * 0.46;
        } else if (document_width < 768 && document_width > 480) {
            left_it = width * 0.20;
            right_id = width * 0.15;
            top_it = height * 0.475;
            bottom_it = height * 0.47;
        } else if (document_width < 480) {
            left_it = width * 0.17;
            right_id = width * 0.09;
            top_it = height * 0.445;
            bottom_it = height * 0.45;
        }
        //align matrix icons
        $('.place_experience_chart').css({ right: right_id + 'px', bottom: bottom_it + 'px' }).show();
        $('.place_mentor_chart').css({ left: left_it + 'px', top: top_it + 'px' }).show();
    };

    this.contactSubmit = function() {
        $('#submit-button').unbind('click').click(function(e) {
            e.preventDefault();
            var validForm = self.validateEntry();
            if (validForm === true) {
                __ss_noform.push(['submit', null, '2308ea44-d5c2-4139-a928-1285cc3d06cf']);
                //show the loading row
                reportmatrix.util.showloadingrow();
                fbq('trackCustom', 'click', { myParam: 'Submit Click Report' });
                ga('send', 'event', 'requested', 'click', 'pdf_request', 1);
                //show images we need
                self.showBuildTheChartImage();
                self.showPolarImage();
                self.showCompareRadarImage();
                setTimeout(function() {
                    $.when(self.sendReportImage(), self.sendPolarImage(), self.sendCompareRadarImage()).done(function(a1, a2, a3) {
                        var data = {};
                        data.action = 'bmmresults';
                        data.svc = 'requestthereport';
                        $('#email').qtip('hide');
                        $('#submit-button').css('opacity', '0.75');
                        $('#submit-button').attr('disabled', true);
                        data.email = $('#email').val();
                        data.optin = 'Yes';
                        data.bmm_session_seq = reportmatrix.data.bmm_session_seq;
                        webservices.app.SvcHandler.ajaxGet({
                            "url": "/svc/index.php",
                            "type": "POST",
                            "data": data,
                            "success": function(res) {
                                window.location.replace('/thankyou.html?survey=' + reportmatrix.data.bmm_session_seq);
                            },
                            "error": function(errorObj) {
                                //alertHandler.app.AlertHandler.showErrorAlert('');
                                //console.log(errorObj);
                            }
                        });

                    });
                }, 500);
            }
        });
    };

    this.successfulPush = function() {
        console.log('succcess');
    };

    this.validateEmail = function(email) {
        var re = /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
        return re.test(email);
    };

    this.validateEntry = function() {
        var valid_email = true;
        var email = $('#email').val();
        if (email === '') {
            $('#email').qtip('show');
            valid_email = false;
        } else if (!self.validateEmail(email)) {
            $('#email').qtip('show');
            valid_email = false;
        }
        return valid_email;
    };

    this.setPrimarySpan = function() {
        $('.primary_selection_here').html(reportmatrix.data.scores.primary_html);
    };

    // this.getItClick = function() {
    //     $('#getit').click(function() {
    //         $(this).hide();
    //         $('#report-request').fadeIn();
    //         $("html, body").animate({ scrollTop: $('#report-request').offset().top }, 300);
    //     });
    // };

    this.icheckCheckBoxColor = function() {
        $('input[type="checkbox"]').iCheck({
            checkboxClass: 'icheckbox_square-purple',
            radioClass: 'iradio_square-purple'
        });
    };

    this.icheckUncheckedReport = function() {
        $('#send-report').on('ifUnchecked', function(event) {
            $('#send-report').qtip('show');
        });
    };

    this.icheckCheckedReport = function() {
        $('#send-report').on('ifChecked', function(event) {
            $('#send-report').qtip('hide');
        });
    };

    this.icheckInput = function() {
        $('input[type="checkbox"]').iCheck('check');
    };

    this.getBackgroundColor = function() {
        var color = '';
        if (reportmatrix.data.scores.primary_type === 'Image') {
            color = 'rgba(0,175,227,0.75)';
        } else if (reportmatrix.data.scores.primary_type === 'Functional') {
            color = 'rgba(169,199,49,0.75)';
        } else if (reportmatrix.data.scores.primary_type === 'Experience') {
            color = 'rgba(243,139,0,0.75)';
        } else if (reportmatrix.data.scores.primary_type === 'Mentor') {
            color = 'rgba(51,11,56,0.75)';
        }
        return color;
    };

    this.getBorderColor = function() {
        var color = '';
        if (reportmatrix.data.scores.primary_type === 'Image') {
            color = 'rgba(0,175,227,0)';
        } else if (reportmatrix.data.scores.primary_type === 'Functional') {
            color = 'rgba(169,199,49,0)';
        } else if (reportmatrix.data.scores.primary_type === 'Experience') {
            color = 'rgba(243,139,0,0)';
        } else if (reportmatrix.data.scores.primary_type === 'Mentor') {
            color = 'rgba(51,11,56,0)';
        }
        return color;
    };

    this.buildTheChart = function() {
        var get_background_color = self.getBackgroundColor();
        var get_border_color = self.getBorderColor();
        var ctx = $('#matrix');
        var myChart = new Chart(ctx, {
            type: 'radar',
            data: {
                labels: ["", "", "", ""],
                datasets: [{
                    label: "",
                    backgroundColor: get_background_color,
                    borderColor: get_border_color,
                    data: [reportmatrix.data.scores.score_functional, reportmatrix.data.scores.score_experience, reportmatrix.data.scores.score_image, reportmatrix.data.scores.score_mentor]
                }]
            },
            options: {
                tooltips: {
                    enabled: false,
                    title: {

                    }
                },
                legend: {
                    display: false
                },
                scale: {
                    ticks: {
                        max: 100,
                        min: 0,
                        stepSize: 10,
                        display: false
                    }
                },
                bezierCurve: false,
                onComplete: self.hideBuildTheChartImage()
            }
        });
    };

    this.showBuildTheChartImage = function() {
        $('#matrix').show();
    };

    this.hideBuildTheChartImage = function() {
        setTimeout(function() {
            $('#matrix').hide();
        }, 1500);
    };

    this.getImage = function() {
        var data_image = document.getElementById("matrix").toDataURL('image/png');
        return data_image;
    };

    this.sendReportImage = function() {
        var data_image = self.getImage();
        var data = {};
        data.action = 'bmmresults';
        data.svc = 'addimage';
        data.type = 'main_brand_type';
        data.image_url = data_image;
        data.bmm_session_seq = reportmatrix.data.bmm_session_seq;
        return webservices.app.SvcHandler.ajaxGet({
            "url": "/svc/index.php",
            "type": "POST",
            "data": data,
            "success": function(res) {

            },
            "error": function(errorObj) {
                //alertHandler.app.AlertHandler.showErrorAlert('');
                //console.log(errorObj);
            }
        });
    };

    this.buildPolarChart = function() {
        //info advo inspir
//        var green_color = ["#a9c731", "#64a834", "#00953a"];
//        var blue_color = ['#205da7', '#288dc1', '#00afe3'];
//        var purple_color = ['#7c2582', '#962369', '#330b38'];
        
        var green_color = ["#a4c230", "#64a834", "#00953a"];
        var blue_color = ['#205da7', '#288dc1', '#00afe3'];
        var purple_color = ['#7f5dad', '#5e62ac', '#564f75'];
        
        //[functional,experience,image,mentor]
        //set a default
        var color_scheme = purple_color;
        var data_obj = [{
            score: reportmatrix.data.scores.mentor_subscore_info,
            type: 'information'
        }, {
            score: reportmatrix.data.scores.mentor_subscore_advo,
            type: 'advocacy'
        }, {
            score: reportmatrix.data.scores.mentor_subscore_insp,
            type: 'inspiration'
        }];
        //sort the data_obj array of objects
        var sorted_filtered = _.sortBy(data_obj, function(each_score) {
            return parseInt(each_score.score);
        });
        //reverse the array because its decending
        var ordered_sorted_filtered = sorted_filtered.reverse();
        //select the first one
        if (ordered_sorted_filtered[0].type === 'information') {
            color_scheme = green_color;
        } else if (ordered_sorted_filtered[0].type === 'advocacy') {
            color_scheme = blue_color;
        } else if (ordered_sorted_filtered[0].type === 'inspiration') {
            color_scheme = purple_color;
        }

        var data = {
            datasets: [{
                data: [
                    reportmatrix.data.scores.mentor_subscore_info,
                    reportmatrix.data.scores.mentor_subscore_advo,
                    reportmatrix.data.scores.mentor_subscore_insp
                ],
                backgroundColor: color_scheme
            }],
            labels: []
        };
        var options = {
            scale: {
                ticks: {
                    display: false,
                    beginAtZero: true,
                    min: 0,
                    max: 100
                }
            },
            onComplete: self.hidePolarImage()
        };
        var ctx = $('#polar_chart_img');
        new Chart(ctx, {
            data: data,
            type: 'polarArea',
            options: options,
        });
    };

    this.getPolarImage = function() {
        var data_image = document.getElementById("polar_chart_img").toDataURL('image/png');
        return data_image;
    };

    this.sendPolarImage = function() {
        var data_image = self.getPolarImage();
        var data = {};
        data.action = 'bmmresults';
        data.svc = 'addimage';
        data.type = 'polar_brand_type';
        data.image_url = data_image;
        data.bmm_session_seq = reportmatrix.data.bmm_session_seq;
        return webservices.app.SvcHandler.ajaxGet({
            "url": "/svc/index.php",
            "type": "POST",
            "data": data,
            "success": function(res) {
                self.hidePolarImage();
            },
            "error": function(errorObj) {
                self.hidePolarImage();
                //alertHandler.app.AlertHandler.showErrorAlert('');
                //console.log(errorObj);
            }
        });
    };

    this.showPolarImage = function() {
        $('.polar_chart_img_row').show();
    };

    this.hidePolarImage = function() {
        setTimeout(function() {
            $('.polar_chart_img_row').hide();
        }, 1500);
    };

    this.buildRadarChartCompare = function() {
        //#AAAAAA
        var array_of_scores = self.getAverageOfTypes();
        var get_background_color = self.getRadarBackgroundColor();
        var get_border_color = self.getRadarBorderColor();
        var ctx = $('#radar_compare_chart_img');
        var myChart = new Chart(ctx, {
            type: 'radar',
            data: {
                labels: ["", "", "", ""],
                datasets: [{
                        label: "",
                        backgroundColor: get_background_color,
                        borderColor: get_border_color,
                        data: [reportmatrix.data.scores.score_functional, reportmatrix.data.scores.score_experience, reportmatrix.data.scores.score_image, reportmatrix.data.scores.score_mentor]
                    },
                    {
                        label: "",
                        backgroundColor: 'rgba(170,170,170,0.80)',
                        borderColor: 'rgba(170,170,170,0)',
                        data: array_of_scores
                    }
                ]
            },
            options: {
                tooltips: {
                    enabled: false,
                    title: {

                    }
                },
                legend: {
                    display: false
                },
                scale: {
                    ticks: {
                        max: 100,
                        min: 0,
                        stepSize: 10,
                        display: false
                    }
                },
                bezierCurve: false,
                onComplete: self.hideCompareRadarImage()
            }
        });
    };

    this.getCompareRadarImage = function() {
        var data_image = document.getElementById("radar_compare_chart_img").toDataURL('image/png');
        return data_image;
    };

    this.sendCompareRadarImage = function() {
        var data_image = self.getCompareRadarImage();
        var data = {};
        data.action = 'bmmresults';
        data.svc = 'addimage';
        data.type = 'radar_compare_brand_type';
        data.image_url = data_image;
        data.bmm_session_seq = reportmatrix.data.bmm_session_seq;
        return webservices.app.SvcHandler.ajaxGet({
            "url": "/svc/index.php",
            "type": "POST",
            "data": data,
            "success": function(res) {
                self.hideCompareRadarImage();
            },
            "error": function(errorObj) {
                self.hideCompareRadarImage();
                //alertHandler.app.AlertHandler.showErrorAlert('');
                //console.log(errorObj);
            }
        });
    };

    this.showCompareRadarImage = function() {
        $('.radar_compare_chart_img_row').show();
    };

    this.hideCompareRadarImage = function() {
        setTimeout(function() {
            $('.radar_compare_chart_img_row').hide();
        }, 1500);

    };

    this.getRadarBackgroundColor = function() {
        var color = '';
        if (reportmatrix.data.scores.primary_type === 'Image') {
            color = 'rgba(0,175,227,0.25)';
        } else if (reportmatrix.data.scores.primary_type === 'Functional') {
            color = 'rgba(169,199,49,0.25)';
        } else if (reportmatrix.data.scores.primary_type === 'Experience') {
            color = 'rgba(243,139,0,0.25)';
        } else if (reportmatrix.data.scores.primary_type === 'Mentor') {
            color = 'rgba(51,11,56,0.25)';
        }
        return color;
    };

    this.getRadarBorderColor = function() {
        var color = '';
        if (reportmatrix.data.scores.primary_type === 'Image') {
            color = 'rgba(0,175,227,0)';
        } else if (reportmatrix.data.scores.primary_type === 'Functional') {
            color = 'rgba(169,199,49,0)';
        } else if (reportmatrix.data.scores.primary_type === 'Experience') {
            color = 'rgba(243,139,0,0)';
        } else if (reportmatrix.data.scores.primary_type === 'Mentor') {
            color = 'rgba(51,11,56,0)';
        }
        return color;
    };

    this.getAverageOfTypes = function() {
        //functional, experience, image, mentor
        var functional_score_1 = 0;
        var experience_score_1 = 0;
        var image_score_1 = 0;
        var mentor_score_1 = 0;

        var functional_score_2 = 0;
        var experience_score_2 = 0;
        var image_score_2 = 0;
        var mentor_score_2 = 0;

        var functional_average = 0;
        var experience_average = 0;
        var image_average = 0;
        var mentor_average = 0;
        $.each(reportmatrix.data.scores.compare_radar_charts, function(index, value) {
            if (index === 0) {
                functional_score_1 = parseInt(value.functional_score);
                experience_score_1 = parseInt(value.experience_score);
                image_score_1 = parseInt(value.image_score);
                mentor_score_1 = parseInt(value.mentor_score);
            } else if (index === 1) {
                functional_score_2 = parseInt(value.functional_score);
                experience_score_2 = parseInt(value.experience_score);
                image_score_2 = parseInt(value.image_score);
                mentor_score_2 = parseInt(value.mentor_score);
            }
        });

        functional_average = (functional_score_1 + functional_score_2) / 2;
        experience_average = (experience_score_1 + experience_score_2) / 2;
        image_average = (image_score_1 + image_score_2) / 2;
        mentor_average = (mentor_score_1 + mentor_score_2) / 2;

        var return_array = [functional_average, experience_average, image_average, mentor_average];

        return return_array;
    };

    this.activateSendReportQtip = function() {
        $('#send-report').qtip({ // Grab some elements to apply the tooltip to
            content: {
                text: 'By unchecking this box, you are electing not to receive your report.',
                button: true
            },
            show: {
                effect: function(offset) {
                    $(this).fadeIn(); // "this" refers to the tooltip
                },
                event: ''
            },
            hide: {
                effect: function(offset) {
                    $(this).fadeOut(); // "this" refers to the tooltip
                }
            },
            position: {
                my: 'bottom left',
                at: 'top center',
                target: $('#send-report')
            },
            style: {
                classes: 'qtip-orange',
                tip: {
                    corner: true,
                    width: 26,
                    height: 23
                },
                width: 340
            }
        });
        $('#email').qtip({ // Grab some elements to apply the tooltip to
            content: {
                text: 'Please enter a valid email address to continue.',
                button: true
            },
            show: {
                effect: function(offset) {
                    $(this).fadeIn(); // "this" refers to the tooltip
                },
                event: ''
            },
            hide: {
                effect: function(offset) {
                    $(this).fadeOut(); // "this" refers to the tooltip
                }
            },
            position: {
                my: 'bottom center',
                at: 'top center',
                target: $('#email')
            },
            style: {
                classes: 'qtip-orange',
                tip: {
                    corner: true,
                    width: 26,
                    height: 23
                },
                width: 280
            }
        });
    };

};
reportmatrix.activate_resultspage = new reportmatrix.app.Activate_ResultsPage();

$(document).ready(function() {
    reportmatrix.data.bmm_session_seq = reportmatrix.util.queryParam('survey');
    if (_.isEmpty(reportmatrix.data.bmm_session_seq)) {
        window.location.replace("/");
    }
    reportmatrix.resultspage.getCustomReport();
});