reportmatrix.util = {

	"log" : function (x,y) {
		if (window.console && console.log)
			console.log( x + ' - ' + y);
	},
	"dump" : function(x,y) {
		if (window.console && console.dir ){
			console.log(x);
			console.dir(y);
		}
	},
	"queryParam" : function(name) {
		name = name.replace(/[\[]/,"\\\[").replace(/[\]]/,"\\\]");
		var regexS = "[\\?&]"+name+"=([^&#]*)";
		var regex = new RegExp( regexS );
		var results = regex.exec( window.location.href );
		if( results === null )
			return "";
		else
			return decodeURIComponent(results[1].replace(/\+/g, " "));
	},
	"xhr" : function(o) {
		var options = {
			type: "GET",
			dataType: "json",
			show_loading: true
		};
		$.extend(options, o);
		if(options.show_loading === true){
			$("#loading-row").show();
		}
		var promise = $.ajax(options);
		return promise;
	},
	"template" : function(data) {
		var template = $(data.template).html(); // need to use .html instead of .text to get tags
		template = _.unescape(template); // needed to remove encoding on the <%= and %> tags
		var compiled = _.template(template, data.data);
		if(data.append === true ){
			compiled = $(data.target).html() + compiled; // removing template from DOM so that ids do not conflict
		}
		if(data.prepend === true ){
			compiled = compiled + $(data.target).html(); // removing template from DOM so that ids do not conflict
		}
		$(data.target).html(compiled);
		if(data.remove === true){
			$(data.template).remove(); // removing template from DOM so that ids do not conflict
		}
	},
	"generaterandom" : function(length) {
		var chars = '0123456789abcdefghijklmnopqrstuvwxyz';
	    var result = '';
	    for (var i = length; i > 0; --i) {
	    	result += chars[Math.floor(Math.random() * chars.length)];
	    }
	    return result;
	},
	"hideloadingrow": function() {
		$('#loader').fadeOut('slow');
	},
	"showloadingrow": function() {
		$('#loader').show();
	},
	"activatetips": function(data) {
		$(data.selector).qtip({ // Grab some elements to apply the tooltip to
		    content: {
		        text: data.text,
		        button: true
		    },
		    show: {
		    	effect: function(offset) {
		        	$(this).fadeIn(); // "this" refers to the tooltip
		    	},
		    	event: ''
		    },
		    hide: {
		    	effect: function(offset) {
		        	$(this).fadeOut(); // "this" refers to the tooltip
		    	},
		        event: ''
		    },
		    position: {
		        my: data.my,
		        at: data.at, 
		        target: $(data.target) 
		    },
		    style: {
		    	classes: data.class,
		    	tip: {
		    		corner: data.corner,
		        	width: data.width,
		    		height: data.height
		    	},
		    	width: data.full_width
		    }    	  
		});
	}
};

$.fn.serializeObject = function() {
	var o = {};
	var a = this.serializeArray();
	$.each(a, function() {
		if (o[this.name] !== undefined) {
			if (!o[this.name].push) {
				o[this.name] = [o[this.name]];
			}
			o[this.name].push(this.value || '');
		} else {
			o[this.name] = this.value || '';
		}
	});
	return o;
};

$.fn.scrollTo = function( target, options, callback ){
  if(typeof options == 'function' && arguments.length == 2){ callback = options; options = target; }
  var settings = $.extend({
    scrollTarget  : target,
    offsetTop     : 50,
    duration      : 500,
    easing        : 'swing'
  }, options);
  return this.each(function(){
    var scrollPane = $(this);
    var scrollTarget = (typeof settings.scrollTarget == "number") ? settings.scrollTarget : $(settings.scrollTarget);
    var scrollY = (typeof scrollTarget == "number") ? scrollTarget : scrollTarget.offset().top + scrollPane.scrollTop() - parseInt(settings.offsetTop);
    scrollPane.animate({scrollTop : scrollY }, parseInt(settings.duration), settings.easing, function(){
      if (typeof callback == 'function') { callback.call(this); }
    });
  });
};