reportmatrix.app.LastQuestionPage = function() {
    var self = this;

    this.validateSurveyGetScores = function() {
        var data = {};
        data.action = 'bmmuserscores';
        data.svc = 'gettopthree';
        data.bmm_session_seq = reportmatrix.data.bmm_session_seq;
        webservices.app.SvcHandler.ajaxGet({
            "url": "/svc/index.php",
            "type": "POST",
            "data": data,
            "success": function(res) {
                if(res.exists === false || res.completed === true) {
                    window.location.replace("/");
                } else {
                    reportmatrix.data.scores = res.results;
                    self.pageTemplate();
                }
            },
            "error": function(errorObj) {
                //alertHandler.app.AlertHandler.showErrorAlert('There was an error submitting your quote. Here is a reference ID ' + errorObj.errorID + ' our support has been notified. We will contact your soon.');
                // console.log(errorObj);
            }
        });
    };

    //call template to refresh
	this.pageTemplate = function() {
        var settings = {
            template: ".lastquestion_template",
            target: ".lastquestion_target"
        };
        //count all questions
        reportmatrix.data.totalQuestions = reportmatrix.all_questions.length;
        reportmatrix.util.template(settings);
        reportmatrix.util.hideloadingrow();
        reportmatrix.activate_surveypage.adjustHtmlFinalQuestion();
        reportmatrix.activate_surveypage.activateTips();
	};

};
reportmatrix.lastquestionpage = new reportmatrix.app.LastQuestionPage();

reportmatrix.app.Activate_SurveyPage = function() {
    var self = this;

    this.adjustHtmlFinalQuestion = function(res) {
        $('.radio').html('');
        var html = '';
        $.each(reportmatrix.data.scores, function(index, value) {
            html += '<div class="radio-field">';
            html += '<input type="radio" name="q'+reportmatrix.data.totalQuestions+'-val" id="q'+reportmatrix.data.totalQuestions+'-val-' + index + '" value="' + value.attribute_code + '"><label>'+ value.attributes_obj.attribute_full_text + '</label>';
            html += '</div>';
        });
        $('.radio').html(html);
        $('input[type="radio"]').iCheck('destroy');
        $('input[type="radio"]').iCheck({
            checkboxClass: 'icheckbox_square-purple',
            radioClass: 'iradio_square-purple'
        });
        self.lastQuestionClick();
    };

    //activate click of last button
    this.lastQuestionClick = function() {
        $('.last_button_click').click(function() {
            if (!$("input[name='q"+reportmatrix.data.totalQuestions+"-val']:checked").val()) {
               $('.radio').qtip('show');
            }
            else {
                ga('send', 'event', 'completed', 'click', 'done', 1);
                //Post final question to database
                var code = $("input[name='q"+reportmatrix.data.totalQuestions+"-val']:checked").val();
                var finalQuestion = {};
                finalQuestion.top_attribute_code = code;
                finalQuestion.action = 'bmmuser';
                finalQuestion.svc = 'postfinalquestion';
                finalQuestion.bmm_session_seq = reportmatrix.data.bmm_session_seq;
                webservices.app.SvcHandler.ajaxGet({
                    "url": "/svc/index.php",
                    "type": "POST",
                    "data": finalQuestion,
                    "success": function(res) {
                        window.location.replace('/results.html?survey='+reportmatrix.data.bmm_session_seq);
                    },
                    "error": function(errorObj) {
                        //alertHandler.app.AlertHandler.showErrorAlert('There was an error submitting your quote. Here is a reference ID ' + errorObj.errorID + ' our support has been notified. We will contact your soon.');
                        // console.log(errorObj);
                    }
                });
                
            }
        });
    };

    this.activateTips = function() {
        $('.radio').qtip({ // Grab some elements to apply the tooltip to
            content: {
                text: 'Please choose an answer to complete your brand assessment.',
                button: true
            },
            show: {
                effect: function(offset) {
                    $(this).fadeIn(); // "this" refers to the tooltip
                },
                event: ''
            },
            hide: {
                effect: function(offset) {
                    $(this).fadeOut(); // "this" refers to the tooltip
                }
            },
            position: {
                my: 'bottom left',  
                at: 'top left', 
                target: $('.radio'),
                adjust: {
                    x: 11
                }
            },
            style: {
                classes: 'qtip-orange',
                tip: {
                    corner: true,
                    width: 26,
                    height: 23
                },
                width:280
            }         
        });
    };
    
};
reportmatrix.activate_surveypage = new reportmatrix.app.Activate_SurveyPage();

$(document).ready(function() {
    reportmatrix.data.bmm_session_seq = reportmatrix.util.queryParam('survey');
     if(_.isEmpty(reportmatrix.data.bmm_session_seq)) {
       window.location.replace("/");
    }
	reportmatrix.lastquestionpage.validateSurveyGetScores();
});