reportmatrix.app.HomePage_Mentor = function() {
    var self = this;

    this.validateSurvey = function() {
        console.log('validate called');
        var data = {};
        data.action = 'bmmuser';
        data.svc = 'authenticate';
        data.bmm_session_seq = reportmatrix.data.bmm_session_seq;
        webservices.app.SvcHandler.ajaxGet({
            "url": "/svc/index.php",
            "type": "POST",
            "data": data,
            "success": function(res) {
                if(res.exists === false || res.completed === true) {
                    window.location.replace("/");
                } else {
                    self.pageTemplate();
                }
            },
            "error": function(errorObj) {
                //alertHandler.app.AlertHandler.showErrorAlert('There was an error submitting your quote. Here is a reference ID ' + errorObj.errorID + ' our support has been notified. We will contact your soon.');
                // console.log(errorObj);
            }
        });
    };

    //call template to refresh
	this.pageTemplate = function() {
        // var settings = {
        //     template: ".homepage_template",
        //     target: ".homepage_target"
        // };
        // reportmatrix.util.template(settings);
        if(_.isEmpty(reportmatrix.data.brand_name)) {
            reportmatrix.util.hideloadingrow();
        }
        reportmatrix.activate_custom_mentor.activateStartButton();
        reportmatrix.activate_custom_mentor.activateTips();
        self.checkForBrandNameParam();
	};

    this.checkForBrandNameParam = function() {
        if(!_.isEmpty(reportmatrix.data.brand_name)) {
            $('#brand-name').val(reportmatrix.data.brand_name);
            if(reportmatrix.data.brand_name !== '') {
                var brand_name_data = {};
                brand_name_data.brand_name = reportmatrix.data.brand_name;
                brand_name_data.action = 'bmmuser';
                brand_name_data.svc = 'add';
                brand_name_data.bmm_session_seq = reportmatrix.data.bmm_session_seq;
                webservices.app.SvcHandler.ajaxGet({
                    "url": "/svc/index.php",
                    "type": "POST",
                    "data": brand_name_data,
                    "success": function(res) {
                        window.location.replace("/intro.html?survey="+res.results);
                    },
                    "error": function(errorObj) {
                        //alertHandler.app.AlertHandler.showErrorAlert('There was an error submitting your quote. Here is a reference ID ' + errorObj.errorID + ' our support has been notified. We will contact your soon.');
                        // console.log(errorObj);
                    }
                });
            } else {
                reportmatrix.util.hideloadingrow();
                $('#brand-name').qtip('show');
            }
        }
    };

};
reportmatrix.homepage_mentor = new reportmatrix.app.HomePage_Mentor();

reportmatrix.app.Activate_Custom_Mentor = function() {
    var self = this;

    this.activateTips = function() {
    	var data_tips = {};
    	data_tips.selector = '#brand-name';
    	data_tips.text = "Please enter a value for your Brand's Name to continue.";
    	data_tips.my = 'bottom center';
		data_tips.at = 'top center';
		data_tips.target = '#brand-name';
		data_tips.class = 'qtip-orange';
		data_tips.corner = true;
		data_tips.width = 26;
		data_tips.height = 23;
		data_tips.full_width = 280;
    	reportmatrix.util.activatetips(data_tips);
    };

    //activate the start button
    this.activateStartButton = function() {
        $('#start button').click(function() {
            fbq('trackCustom', 'click', { myParam: 'Start Button Click' });
            //Start new session
            var brandname = $('#brand-name').val();
            if(brandname !== '') {
                var brand_name_data = {};
                brand_name_data.brand_name = brandname;
                brand_name_data.action = 'bmmuser';
                brand_name_data.svc = 'add';
                brand_name_data.bmm_session_seq = reportmatrix.data.bmm_session_seq;
                webservices.app.SvcHandler.ajaxGet({
                    "url": "/svc/index.php",
                    "type": "POST",
                    "data": brand_name_data,
                    "success": function(res) {
                        window.location.replace("/intro.html?survey="+res.results);
                    },
                    "error": function(errorObj) {
                        //alertHandler.app.AlertHandler.showErrorAlert('There was an error submitting your quote. Here is a reference ID ' + errorObj.errorID + ' our support has been notified. We will contact your soon.');
                        // console.log(errorObj);
                    }
                });
            } else {
                $('#brand-name').qtip('show');
            }
        });
    };

};
reportmatrix.activate_custom_mentor = new reportmatrix.app.Activate_Custom_Mentor();

$(document).ready(function() {
    reportmatrix.data.bmm_session_seq = reportmatrix.util.queryParam('survey');
    reportmatrix.data.brand_name = reportmatrix.util.queryParam('brandname');
     if(_.isEmpty(reportmatrix.data.bmm_session_seq)) {
       reportmatrix.data.bmm_session_seq = '';
    }
    if(reportmatrix.data.bmm_session_seq === '') {
        reportmatrix.homepage_mentor.pageTemplate();
    } else {
        reportmatrix.homepage_mentor.validateSurvey();
    }
	
});