<?php
    require_once($_SERVER["DOCUMENT_ROOT"] . '/models/VersionHandler.php');
    use \brandmeaningmatrix\model\VersionHandler;
    //this will bust the cache when new css or js is loaded
    $versionHandler = new VersionHandler();
    //get the current version
    $version = $versionHandler->get();
?>
<!DOCTYPE>
<html>
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<meta name="description" content="">
		<meta name="author" content="Meyocks">
		<title>Meyocks || Brand Typology Tool</title>
		<!-- facebook & linkedin -->
        <meta property="fb:app_id" content="1152368681498915">
        <meta property="og:type" content="article">
        <meta property="og:title" content="Brand Typology Tool Measures Your Brand's Marketplace Relevance">
        <meta property="og:description" content="Explore why customers choose your brand with the Brand Typology Tool. This online tool developed by Meyocks produces a visual matrix of the factors that shape your brand's marketplace meaning.">
        <meta property="og:image" content="http://brandtypologytool.com/img/purple_ad_box.png">
        <meta property="og:url" content="http://brandtypologytool.com">
        <meta property="og:site_name" content="Brand Typology Tool">
        <!-- <meta property='og:video' content="https://www.youtube.com/watch?v=1tq7TLpl5bY"> -->
        <meta property="og:image:type" content="image/png">
        <meta property="og:image:width" content="502">
        <meta property="og:image:height" content="502">
        <!-- twitter -->
        <meta property="twitter:card" content="summary_large_image">
        <meta property="twitter:site" content="@meyocks">
        <meta property="twitter:title" content="Brand Typology Tool Measures Your Brand's Marketplace Relevance">
        <meta property="twitter:description" content="The Brand Typology Tool – developed by Meyocks – helped me understand the factors that shape my brand's marketplace meaning. Try it now.">
        <meta property="twitter:creator" content="@meyocks">
        <meta property="twitter:url" content="http://brandtypologytool.com">
        <meta property="twitter:image" content="http://brandtypologytool.com/img/purple_ad_box_twitter.png">
        <meta name="twitter:image:width" content="438">
        <meta name="twitter:image:height" content="220">
        <!-- include favicon -->
        <link rel="icon" href="/resources/images/favicon.gif">
		<!-- include bootstrap -->
		<link href="/bower_components/bootstrap/dist/css/bootstrap.min.css?ver=<?= $version ?>" rel="stylesheet">
		<!-- include font awesome -->
		<link href="/bower_components/font-awesome/css/font-awesome.min.css?ver=<?= $version ?>" rel="stylesheet">
		<link rel="stylesheet" href="/css/jquery.qtip.min.css?ver=<?= $version ?>">
        <link rel="stylesheet" href="/css/rangeslider.css?ver=<?= $version ?>">
        <link rel="stylesheet" href="/css/purple.css?ver=<?= $version ?>" >
		<link href="/css/main.css?ver=<?= $version ?>" rel="stylesheet">
        <link href="/css/email_site.css?ver=<?= $version ?>" rel="stylesheet">
		<!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
	    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
	    <!--[if lt IE 9]>
			<script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
			<script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
	    <![endif]-->
	</head>