<?php
	ini_set('display_errors',1);
	require_once($_SERVER["DOCUMENT_ROOT"].'/models/JsonUtil.php');
	use \dragooffers\model\JsonUtil;

	$jsonUtil = new dragooffers\model\JsonUtil();
	
	$data = (isset($_POST['action'])) ? $_POST : $_GET;
	if(empty($data['action']) || empty($data['svc'])) {
		echo "invalid service specified.";
		exit();
	}
	
	// getting the class name and method from the URI
	$getClass = preg_replace('/[^a-zA-Z0-9_-]/','',$data['action']);
	$getMethod = preg_replace('/[^a-zA-Z0-9_-]/','',$data['svc']);
	$svc = preg_replace('/[^a-zA-Z0-9_-]/','',$data['action']);
	$methodName = $getMethod;

	$classFileName = $_SERVER["DOCUMENT_ROOT"].'/svc/'.$svc.'.php';
	if (file_exists($classFileName)) {
		require_once($classFileName);
	} else {
		$msg = "File ".$classFileName." not found.";
		$jsonUtil->writeJsonFail($msg);
		exit();
	}
	$className = ucfirst($svc);
	$className = "\\dragooffers\\svc\\".$className;
	try {
		$svcClass = new ReflectionClass($className);
		$method = new ReflectionMethod($className, $methodName);
	} catch (ReflectionException $e) {
		$msg = $e->getMessage();
		$jsonUtil->writeJsonFail($msg);
		exit();
	}

	// post and invoke the mehtod with those args
	$svcObj = $svcClass->newInstance();
	
	$method->invoke($svcObj, $data);

	exit();
	
?>