//Codekit dev mode
/*jshint devel:true */

/**
 * Nav Object Controls The Top Nav
 * app_fcsamerica contains the var drago_offers_site = { data: {}, app: {} };
 * 
 */

var drago_offers_site = { data: {}, app: {} };

(function($) {

    drago_offers_site.App = function() {
        var self = this;

        //init
        this.init = function() {
            self.initRetinaCover();
            self.formSubmit();
            $('.js-phone').mask('(000) 000-0000');
            $('#drago_offers_form').validate({
                rules: {
                    contact_method: {
                        required: true
                    }
                },
                messages: {
                    contact_method: "Required"
                }
            });
        };

        this.formSubmit = function() {
            $('.js-submit-form').unbind('click').click(function(e) {
                e.preventDefault();
                var form_is_valid = $('.js_drago_offers_form').valid();
                var check_value = $('.js-mylast-name').val();
                if (check_value === '') {
                    if (form_is_valid === true) {
                        __ss_noform.push(['submit', self.successfulSubmit(), '6eb26c9c-5a1f-4bab-9018-2d57cb71bdb9']);
                    }
                }
            });
        };

        /* activates full parent width image */
        this.initRetinaCover = function() {
            $('.bg-stretch').retinaCover();
        };

        this.successfulSubmit = function() {
            swal({
                type: 'success',
                title: 'Thank you for reaching out to us!',
                text: 'A team member will be in touch shortly.',
                confirmButtonColor: '#fff',
                confirmButtonText: 'Ok',
                allowOutsideClick: false,
            }).then(function() {
                $("#drago_offers_form")[0].reset();
            }).catch(swal.noop);
        };

        //call the init or construct
        self.init();
    };

    //instantiate the App object
    drago_offers_site.app.App = new drago_offers_site.App();

})(jQuery);