<?php
namespace dragooffers\model;
ini_set('display_errors',1);

class InputFilterUtil {
	public function __construct() {
	}

	public function sanitizeString($rawData) {
		$filteredData = filter_var($rawData, FILTER_SANITIZE_STRING);
		$filteredData = trim($filteredData);
		return $filteredData;
	}

	public function sanitizeStringAndEncodeSpecialChars($rawData) {
		$filteredData = filter_var($rawData, FILTER_SANITIZE_SPECIAL_CHARS);
		$filteredData = trim($filteredData);
		return $filteredData;
	}

	public function sanitizeStringArray($rawData) {
		$filteredArray = null;
		if (is_array($rawData)) {
			$filteredArray = array();
			foreach ($rawData as $rawStr) {
				$filteredStr = filter_var($rawStr, FILTER_SANITIZE_STRING);
				array_push($filteredArray, $filteredStr);
			}
		}
		return $filteredArray;
	}

	public function sanitizeInt($rawInt) {
		$filteredInt = preg_replace('/[^0-9]/','',$rawInt);
		return $filteredInt;
	}

	public function sanitizeDecimal($rawInt) {
		$filteredInt = preg_replace('/[^0-9-.]/','',$rawInt);
		return $filteredInt;
	}

	public function sanitizeDollarDecimal($rawInt) {
		$filteredInt = preg_replace('/[^$0-9-.]/','',$rawInt);
		return $filteredInt;
	}

	public function sanitizeEmail($rawEmailAddr) {
		$filteredEmailAddr = filter_var($rawEmailAddr, FILTER_SANITIZE_EMAIL);
		$filteredEmailAddr = trim($filteredEmailAddr);
		return $filteredEmailAddr;
	}

	public function sanitizeURL($rawEmailAddr) {
		$filteredEmailAddr = filter_var($rawEmailAddr, FILTER_SANITIZE_URL);
		$filteredEmailAddr = trim($filteredEmailAddr);
		return $filteredEmailAddr;
	}

	public function decodeString($encodedData) {
		$decodedData = htmlspecialchars_decode($encodedData,ENT_QUOTES);
		return $decodedData;
	}

}

?>