<?php
    require_once($_SERVER["DOCUMENT_ROOT"] . '/models/VersionHandler.php');
    use \dragooffers\model\VersionHandler;
    //this will bust the cache when new css or js is loaded
    $versionHandler = new VersionHandler();
    //get the current version
    $version = $versionHandler->get();
?>
<html lang="en-US">
    <head>
		<meta charset="UTF-8">
		<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=0">
        <title>Drago Offers</title>        
        <link rel="apple-touch-icon" sizes="180x180" href="/resources/images/apple-touch-icon-125d27148b.png">
        <link rel="icon" type="image/png" href="/resources/images/favicon-32x32-a2ba936381.png" sizes="32x32">
        <link rel="icon" type="image/png" href="/resources/images/favicon-16x16-04fd49d07e.png" sizes="16x16">
		<!-- include css -->
        <link rel="stylesheet" href="/resources/css/dragooffers-min.css?ver=<?= $version ?>" >
        <!-- Include a polyfill for ES6 Promises (optional) for IE11, UC Browser and Android browser support -->
  		<script src="/resources/js/sweetalert/dist/sweetalert-polyfill-core.js"></script>
		<!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
		<!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
		<!--[if lt IE 9]>
			<script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
			<script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
        <![endif]-->
        
        <!-- Facebook, Twitter & Linkedin -->
        <meta property="og:site_name" content="Drago Offers" />
        <meta property="og:url" content="https://www.dragooffers.com" />
        <meta property="og:type" content="article" />
        <meta property="og:title" content="No other corn head is engineered to capture more yield." />
        <meta property="og:description" content="Helping to manage stalk variability and minimize yield loss at harvest, Drago GT and Drago II corn heads raise the bar on performance." />
        <meta property="og:image" content="https://cdn.meyocks.com/drago/drago-og-image.jpg" />
        <meta property="og:image:type" content="image/jpeg" />
        <meta property="og:image:width" content="1200" />
        <meta property="og:image:height" content="630" />
        <meta property="og:image:alt" content="No other corn head is engineered to capture more yield." />
        <meta property="og:image:secure_url" content="https://cdn.meyocks.com/drago/drago-og-image.jpg" />
        
        <meta name="description" content=""/>
        <meta name="keywords" content=""/>
    </head>
    <body>
    <!--[if lt IE 8]>
        <p class="browserupgrade">You are using an <strong>outdated</strong> browser. Please <a href="http://browsehappy.com/">upgrade your browser</a> to improve your experience.</p>
    <![endif]-->
    <!-- Global site tag (gtag.js) - Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=UA-111266500-1"></script>
    <script>
    window.dataLayer = window.dataLayer || [];
    function gtag(){dataLayer.push(arguments);}
    gtag('js', new Date());

    gtag('config', 'UA-111266500-1');
    </script>

