var reconins = {
    data: {},
    app: {}
};
//Codekit dev mode
/*jshint devel:true */

(function($) {

    reconins.ReApp = function() {
        var self = this;

        /* 
         * init everything
         */
        this.init = function() {
            self.setSignup();
            self.submitButtonClick();
            self.radioButtonClick();
            self.inputChange();
        };

        this.setSignup = function() {
            reconins.data.signup = {
                mutual_name: '',
                contact_name: '',
                contact_type: '',
                contact_info: '',
                message: ''
            };
        };

        this.inputChange = function() {
            $(document).on('input', '.js-input-data', function() {
                var prop = $(this).attr('name');
                reconins.data.signup[prop] = $(this).val();
                self.validate();
            });
        };

        this.checkSubmitButton = function(enable_disable) {
            if (enable_disable === 'enable') {
                $('.js-submit-form').removeAttr('disabled');
            } else {
                $('.js-submit-form').attr('disabled', true);
            }
        };

        this.submitButtonClick = function() {
            $(document).on('click', '.js-submit-form', function(e) {
                e.preventDefault();
                var $e = $(this);
                var form_submit = self.serializeObject($($e.data("form")));
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    async: true,
                    url: "/svc/signupservice/add",
                    data: form_submit,
                    success: function(res) {
                        if (res.results == true) {
                            $($e.data("form"))[0].reset();
                            self.setSignup();
                            self.validate();
                            $('.js-contact-type-input').html('');
                            window.open('/thank-you');
                        } else {
                            swal("Error!", "There was an error submitting your form. Please try again.", "error");
                        }
                    },
                    error: function(qXHR, textStatus, errorThrown) {
                        swal("Error!", "There was a service error submitting your form. Please try again.", "error");
                    }
                });
            });
        };

        this.radioButtonClick = function() {
            $(document).on('click', '.js-radio-click', function() {
                var html = '<label class="ready-to-talk--label">Phone</label>';
                html += '<input type="text" class="ready-to-talk--input js-input-data" name="contact_info" id="phone">';
                if ($(this).val() === 'email') {
                    html = '<label class="ready-to-talk--label">Email</label>';
                    html += '<input type="text" class="ready-to-talk--input js-input-data" name="contact_info" id="email">';
                }
                $('.js-contact-type-input').removeClass('hidden');
                $('.js-contact-type-input').html(html);
                if ($(this).val() === 'phone') {
                    $('#phone').inputmask("999-999-9999");
                    reconins.data.signup.contact_type = 'phone';
                }
                if ($(this).val() === 'email') {
                    reconins.data.signup.contact_type = 'email';
                }
                reconins.data.signup.contact_info = '';
                self.validate();
            });
        };

        this.validate = function() {
            var errors = 0;
            if (reconins.data.signup.mutual_name === '') {
                errors += 1;
            }
            if (reconins.data.signup.contact_name === '') {
                errors += 1;
            }
            if (reconins.data.signup.contact_type === '') {
                errors += 1;
            }
            if (reconins.data.signup.contact_type === 'email') {
                var isEmailValid = self.validateEmail(reconins.data.signup.contact_info);
                if (isEmailValid !== true) {
                    errors += 1;
                }
            }
            if (reconins.data.signup.contact_type === 'phone') {
                var isPhoneValid = self.validatePhone(reconins.data.signup.contact_info);
                if (isPhoneValid !== true) {
                    errors += 1;
                }
            }
            if (reconins.data.signup.contact_info === '') {
                errors += 1;
            }
            if (errors === 0) {
                self.checkSubmitButton('enable');
            } else {
                self.checkSubmitButton('disable');
            }
            return errors;
        };

        this.validateEmail = function(email) {
            var re = /\S+@\S+\.\S+/;
            return re.test(email);
        };

        this.validatePhone = function(phone_number) {
            var re = /^[(]{0,1}[0-9]{3}[)]{0,1}[-\s\.]{0,1}[0-9]{3}[-\s\.]{0,1}[0-9]{4}$/;
            return re.test(phone_number);
        };

        this.serializeObject = function(selector) {
            var o = {};
            var a = selector.serializeArray();
            $.each(a, function() {
                if (o[this.name] !== undefined) {
                    if (!o[this.name].push) {
                        o[this.name] = [o[this.name]];
                    }
                    o[this.name].push(this.value || "");
                } else {
                    o[this.name] = this.value || "";
                }
            });
            return o;
        };

    };

    //instantiate the ReApp object
    reconins.app.ReApp = new reconins.ReApp();
    reconins.app.ReApp.init();
})(jQuery);