<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
require_once($_SERVER["DOCUMENT_ROOT"].'/models/DataAccess.php');
require_once($_SERVER["DOCUMENT_ROOT"].'/models/InputFilterUtil.php');

class SignUpDataAccess extends DataAccess {
	
	function __construct() {
	}

	public function add($mutual_name, $contact_name, $contact_type, $contact_info, $message) {
		//filter to clean
		$filterUtil = new InputFilterUtil();
		$params = array();
		$sql = "insert into signups ";
		$sql .= "(mutual_name, contact_name, contact_type, contact_info, message, created_at) ";
		$sql .= "values (";
		$sql .= ":mutual_name, ";
		$sql .= ":contact_name, ";
		$sql .= ":contact_type, ";
		$sql .= ":contact_info, ";
		$sql .= ":message, ";
		$sql .= ":created_at ";
		$sql .= ") ";
		//params
		$params['mutual_name'] = $filterUtil->sanitizeString($mutual_name);
        $params['contact_name'] = $filterUtil->sanitizeString($contact_name);
		$params['contact_type'] = $filterUtil->sanitizeString($contact_type);
		$params['contact_info'] = $filterUtil->sanitizeString($contact_info);
		$params['message'] = $filterUtil->sanitizeString($message);
		$params['created_at'] = date('Y-m-d H:i:s');
		//execute
		$pdo = $this->getPDO();
        $stmt = $pdo->prepare($sql);
        return $stmt->execute($params);
	}

}

?>