<?php
ini_set('display_errors',1);
require_once($_SERVER["DOCUMENT_ROOT"].'/models/JsonUtil.php');
$jsonUtil = new jsonUtil();
//get uri
$uri = $_SERVER['REQUEST_URI'];
$parsedUrl = parse_url($uri);
$page = preg_replace('/[^a-zA-Z0-9.\-]/','',$uri);
$pageParts = explode('.', $page);
$explodeFolders = explode('/', $parsedUrl['path']);
if($explodeFolders[1] === 'svc') {
	$res_request = new stdClass();
	$uri = $_SERVER['REQUEST_URI'];

	$tokens = explode('/', $uri);
	if (count($tokens) < 4) {
		echo "invalid service specified.";
		exit();
	}

	$svc = $tokens[2];
	$methodName = $tokens[3];
	$tokens = explode('?', $methodName);
	$methodName = $tokens[0];
	$svc = preg_replace('/[^a-zA-Z0-9_-]/','',$svc);
	$methodName = preg_replace('/[^a-zA-Z0-9_-]/','',$methodName);
	// using reflection to get the method name from the class
    // see http://php.net/manual/en/book.reflection.php
    // and http://en.wikipedia.org/wiki/Reflection_(computer_programming)
    // for more info.
    $classFileName = $_SERVER["DOCUMENT_ROOT"]. '/' .'svc/'.$svc.'.php';
    if (file_exists($classFileName)) {
        require_once($classFileName);
    } else {
        $msg = "File ".$classFileName." not found.";
        $jsonUtil->writeJsonFail($msg);
        exit();
    }
    $className = ucfirst($svc);
    $className = $className;
    try {
        $svcClass = new ReflectionClass($className);
        $method = new ReflectionMethod($className, $methodName);
    } catch (ReflectionException $e) {
        $msg = $e->getMessage();
        $jsonUtil->writeJsonFail($msg);
        exit();
    }
    
    // gather args from query string or post and invoke the mehtod with those args
    $svcObj = $svcClass->newInstance();
    $args = $method->getParameters();
    $argArray = array();
    foreach ($args as $arg) {
        if (isset($_REQUEST[$arg->name])) {
            $argValue = $_REQUEST[$arg->name];
            array_push($argArray, $argValue);
        } else {
            if ($arg->isDefaultValueAvailable()) {
                array_push($argArray, $arg->getDefaultValue());
            } else {
                $jsonUtil->writeJsonFail('The parameter '.$arg->name.' is a required.');
                exit();
            }
        }
    }

	$method->invokeArgs($svcObj, $argArray);
	
	exit();
} else {
	// pick the correct file to load
	if($page == '') {
		//map landing page
		$pagePHPFilename = $_SERVER["DOCUMENT_ROOT"].'/assets/views/homepage.php';
	} else {
		$pagePHPFilename = $_SERVER["DOCUMENT_ROOT"].'/assets/views/'.$pageParts[0].'.php';
	}

	if (file_exists($pagePHPFilename)) {
		// file exists, lets use it
		include ($pagePHPFilename);
		return;
	} else {
		// 404
		include ($_SERVER["DOCUMENT_ROOT"].'/assets/views/homepage.php');
		return;
	}
}


?>