var copper_cross_app = { data: {}, app: {} };
(function($) {

    copper_cross_app.StartApp = function() {
        var self = this;

        // construct
        this.init = function() {
            copper_cross_app.data.twenty_one_answer = '';
            copper_cross_app.data.image_array = '';
            self.twentyOneAnswerClick();
            self.enterWebsiteClick();
            self.scrollToClick();
            self.websiteScroll();
            self.pauseCarouselClick();
            self.setImages();
            self.toggleMobileNav();
            self.preLoadImages();
        };

        this.pauseCarouselClick = function() {
            $('.js-mobile-nav-button-click').click(function() {
                $('.carousel').carousel('pause');
            });
        };

        this.recipesSliders = function() {
            $('.js-recipes-slider-xs').slick({
                dots: false,
                infinite: true,
                speed: 300,
                slidesToShow: 1,
                arrows: false
            });

            $('.js-recipes-slider').slick({
                dots: false,
                infinite: true,
                speed: 300,
                slidesToShow: 1,
                arrows: true,
            });
        };

        this.scrollToClick = function() {
            $('.js-nav-item').unbind('click').click(function(e) {
                e.preventDefault();
                var link = $(this).data('thelocation');
                var is_mobile = $(this).data('ismobile');
                $('html,body').animate({
                    scrollTop: $(link).offset().top
                }, 'slow');
                if (is_mobile === 'yes') {
                    $('.navmenu').offcanvas();
                    //below will close and take to element
                    //$('.navmenu').offcanvas('toggle');
                }
            });
        };

        this.twentyOneAnswerClick = function() {
            $('.js-twenty-one-click').unbind('click').click(function(e) {
                e.preventDefault();
                copper_cross_app.data.twenty_one_answer = $(this).data('answer');
                self.handleBlueCornX();
            });
        };

        this.enterWebsiteClick = function() {
            $('.js-enter-button-click').unbind('click').click(function(e) {
                e.preventDefault();
                if (copper_cross_app.data.twenty_one_answer === 'yes') {
                    $('.must-be-twenty-one-row').addClass('hidden');
                    $('.enter-website-container').fadeOut('slow', function() {
                        $('header').fadeIn('slow');
                        $('footer').fadeIn('slow');
                        $('.main-website-area').fadeIn('slow', function() {
                            $('.carousel').carousel({
                                interval: 5000,
                                pause: false
                            });
                            self.recipesSliders();
                        });
                    });
                } else {
                    $('.must-be-twenty-one-row').removeClass('hidden');
                }

            });
        };

        this.handleBlueCornX = function() {
            if (copper_cross_app.data.twenty_one_answer === 'no') {
                $('.js-blue-corn-no').removeClass('hidden');
                if (!$('.js-blue-corn-yes').hasClass('hidden')) {
                    $('.js-blue-corn-yes').addClass('hidden');
                }
            } else {
                $('.js-blue-corn-yes').removeClass('hidden');
                if (!$('.js-blue-corn-no').hasClass('hidden')) {
                    $('.js-blue-corn-no').addClass('hidden');
                }
            }
        };

        this.toggleMobileNav = function() {
            $('.js-close-mobile-nav').unbind('click').click(function(e) {
                e.preventDefault();
                $('.carousel').carousel('cycle');
                $('.navmenu').offcanvas('toggle');
            });
        };

        this.websiteScroll = function() {
            $(document).on('scroll', function() {
                if ($(window).scrollTop() > 100) {
                    $('.scroll-top-wrapper').addClass('show');
                    $('.arrow-wrap').hide();
                } else {
                    $('.scroll-top-wrapper').removeClass('show');
                    $('.arrow-wrap').show();
                }
            });
        };

        this.preLoadImages = function() {
            $(window).on('load', function() {
                $.each(copper_cross_app.data.image_array, function(index, value) {
                    var img = new Image();
                    img.src = value;
                });
            });
        };

        this.setImages = function() {
            copper_cross_app.data.image_array = [
                '/resources/images/backgrounds/cch_bottle_glass_barn_3.png',
                '/resources/images/backgrounds/cch_bottle_glass_barn-xs.png',
                '/resources/images/backgrounds/cch_bottle_glass_barn-sm.png',
                '/resources/images/backgrounds/cch_grains_barrel_intro_3.png',
                'resources/images/backgrounds/cch_glass_cap_notes_4.png',
                '/resources/images/paper-top-xs.png',
                '/resources/images/paper-top.png',
                '/resources/images/sign-shape-year.png',
                '/resources/images/paper-bottom-xs.png',
                '/resources/images/paper-bottom.png',
                '/resources/images/wood-square.png',
                '/resources/images/products/manhattan.png',
                '/resources/images/products/old-fashioned.png',
                '/resources/images/products/collins.png',
                '/resources/images/products/mule.png',
                '/resources/images/copper-cross-logo.png',
                '/resources/images/backgrounds/mobile-nav-bg.png'
            ];
        };

        //call the constructor
        self.init();
    };

    copper_cross_app.app.StartApp = new copper_cross_app.StartApp();
})(jQuery);