<?php
    require_once($_SERVER["DOCUMENT_ROOT"] . '/models/VersionHandler.php');
    //this will bust the cache when new css or js is loaded
    $versionHandler = new VersionHandler();
    //get the current version
    $version = $versionHandler->get();
    //get uri
	$uri = $_SERVER['REQUEST_URI'];
	$page = preg_replace('/[^a-zA-Z0-9.\-]/','',$uri);
	$pageParts = explode('.', $page);
?>
<!DOCTYPE html>
<html lang="en">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=0">
		<meta name="description" content="Copper Cross whiskey, the perfect hybrid blend of bourbon and rye. Recipes - Manhattan, Old Fashioned, Collins, Moscow Mule">
		<meta name="keywords" content="copper cross, whiskey, hybrid blend, bourbon, rye, corn, grains, recipes, manhattan, old fashioned, collins, moscow mule">
		<meta name="author" content="Meyocks">
		<meta name="robots" content="index, follow">
		<link rel="icon" href="/resources/images/favicon/favicon.ico">
		<title>Copper Cross</title>
		<!-- include css -->
		<link href="/resources/css/coppercross.css?ver=<?= $version ?>" rel="stylesheet">
		<link rel="apple-touch-icon-precomposed" sizes="57x57" href="/resources/images/favicon/apple-touch-icon-57x57.png" />
		<link rel="apple-touch-icon-precomposed" sizes="114x114" href="/resources/images/favicon/apple-touch-icon-114x114.png" />
		<link rel="apple-touch-icon-precomposed" sizes="72x72" href="/resources/images/favicon/apple-touch-icon-72x72.png" />
		<link rel="apple-touch-icon-precomposed" sizes="144x144" href="/resources/images/favicon/apple-touch-icon-144x144.png" />
		<link rel="apple-touch-icon-precomposed" sizes="60x60" href="/resources/images/favicon/apple-touch-icon-60x60.png" />
		<link rel="apple-touch-icon-precomposed" sizes="120x120" href="/resources/images/favicon/apple-touch-icon-120x120.png" />
		<link rel="apple-touch-icon-precomposed" sizes="76x76" href="/resources/images/favicon/apple-touch-icon-76x76.png" />
		<link rel="apple-touch-icon-precomposed" sizes="152x152" href="/resources/images/favicon/apple-touch-icon-152x152.png" />
		<link rel="icon" type="image/png" href="/resources/images/favicon/favicon-196x196.png" sizes="196x196" />
		<link rel="icon" type="image/png" href="/resources/images/favicon/favicon-96x96.png" sizes="96x96" />
		<link rel="icon" type="image/png" href="/resources/images/favicon/favicon-32x32.png" sizes="32x32" />
		<link rel="icon" type="image/png" href="/resources/images/favicon/favicon-16x16.png" sizes="16x16" />
		<link rel="icon" type="image/png" href="/resources/images/favicon/favicon-128.png" sizes="128x128" />
		<!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
	    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
	    <!--[if lt IE 9]>
			<script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
			<script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
	    <![endif]-->
	    <!-- Picturefill allows the use of <picture> element on browsers without support -->
	    <script src="/resources/js/plugins/picturefill.min.js" async></script>
		<script>
		(function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
		(i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
		m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
		})(window,document,'script','https://www.google-analytics.com/analytics.js','ga');

		ga('create', 'UA-100806230-1', 'auto');
		ga('send', 'pageview');

		</script>
	</head>
		